package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.url.CDNSupport;
import com.atlassian.plugin.webresource.url.NamedHash;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * Operations on super batches
 * @since v3.0
 */
class SuperBatchOperations
{
    /**
     * Merges a plugin resource with a super batch. Assumes that the superbatch and plugin have the same params
     * @param superBatch super batch
     * @param pluginResource plugin resource to merge
     * @return merged superbatch resource
     */
    public static SuperBatchPluginResource mergeSameBatch(final SuperBatchPluginResource superBatch, final PluginResource pluginResource)
    {
        UrlParameters mergedUrlParams = superBatch.getUrlParameters().merge(pluginResource.getUrlParameters());
        SuperBatchPluginResource merged = new SuperBatchPluginResource(superBatch.getType(), mergedUrlParams, superBatch.getParams());
        for (BatchedWebResourceDescriptor bwrd : superBatch.getBatchedWebResourceDescriptors())
        {
            merged.addBatchedWebResourceDescriptor(bwrd);
        }
        for (BatchedWebResourceDescriptor bwrd : pluginResource.getBatchedWebResourceDescriptors())
        {
            merged.addBatchedWebResourceDescriptor(bwrd);
        }
        return merged;
    }
}
