/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.BatchResourceContentsWebFormatter;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.assembler.PluginUrlResourceFactory;
import com.atlassian.plugin.webresource.data.DataTagWriter;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebResourceSet
implements WebResourceSet {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebResourceSet.class);
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final WebResourceIntegration webResourceIntegration;
    private final Iterable<PluginResourceContainer> resources;
    private final Iterable<PluginDataResource> data;

    public DefaultWebResourceSet(ResourceBatchingConfiguration batchingConfiguration, WebResourceUrlProvider webResourceUrlProvider, WebResourceIntegration webResourceIntegration, Iterable<PluginResourceContainer> resources, Iterable<PluginDataResource> data) {
        this.batchingConfiguration = batchingConfiguration;
        this.webResourceIntegration = webResourceIntegration;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.resources = resources;
        this.data = data;
    }

    public Iterable<WebResource> getResources() {
        LinkedList webResources = Lists.newLinkedList(this.data);
        for (PluginResourceContainer container : this.resources) {
            webResources.add(container.pluginUrlResource);
        }
        return webResources;
    }

    public <T extends WebResource> Iterable<T> getResources(Class<T> clazz) {
        return Iterables.filter(this.getResources(), (Predicate)Predicates.instanceOf(clazz));
    }

    public void writeHtmlTags(Writer writer, UrlMode urlMode) {
        this.writeHtmlTags(writer, urlMode, (Predicate<WebResource>)Predicates.alwaysTrue(), (Predicate<PluginResource>)Predicates.alwaysTrue());
    }

    public void writeHtmlTags(Writer writer, UrlMode urlMode, Predicate<WebResource> predicate) {
        this.writeHtmlTags(writer, urlMode, predicate, (Predicate<PluginResource>)Predicates.alwaysTrue());
    }

    public void writeHtmlTags(Writer writer, UrlMode urlMode, final Predicate<WebResource> predicate, final Predicate<PluginResource> legacyPredicate) {
        try {
            new DataTagWriter().write(writer, Iterables.filter(this.data, predicate));
        }
        catch (IOException ex) {
            log.error("IOException encountered rendering data tags", (Throwable)ex);
        }
        ArrayList localCopyOfResources = Lists.newArrayList((Iterable)Iterables.filter(this.resources, (Predicate)new Predicate<PluginResourceContainer>(){

            public boolean apply(@Nullable PluginResourceContainer container) {
                return predicate.apply((Object)container.pluginUrlResource) && legacyPredicate.apply((Object)container.pluginResource);
            }
        }));
        for (WebResourceFormatter formatter : WebResourceFormatter.webResourceFormatters) {
            Iterator iter = localCopyOfResources.iterator();
            while (iter.hasNext()) {
                PluginResourceContainer container = (PluginResourceContainer)iter.next();
                if (!formatter.matches(container.pluginResource.getResourceName())) continue;
                this.writeResourceTag(urlMode, container, formatter, writer);
                iter.remove();
            }
        }
        for (PluginResourceContainer container : localCopyOfResources) {
            this.writeContentAndSwallowErrors(writer, "<!-- Error loading resource \"", container.pluginResource.getModuleCompleteKey(), "\".  No resource formatter matches \"", container.pluginResource.getResourceName(), "\" -->\n");
        }
    }

    private void writeResourceTag(UrlMode urlMode, PluginResourceContainer container, WebResourceFormatter formatter, Writer writer) {
        String formattedResource = formatter.formatResource(container.pluginUrlResource.getStaticUrl(urlMode), container.pluginUrlResource.getParams().all());
        if (this.batchingConfiguration.isBatchContentTrackingEnabled()) {
            formattedResource = BatchResourceContentsWebFormatter.insertBatchResourceContents(container.pluginResource, formattedResource);
        }
        this.writeContentAndSwallowErrors(writer, formattedResource);
    }

    private void writeContentAndSwallowErrors(Writer writer, String ... contents) {
        try {
            for (String content : contents) {
                writer.write(content);
            }
        }
        catch (IOException ex) {
            log.error("IOException encountered rendering resource", (Throwable)ex);
        }
    }

    public static Builder builder(WebResourceUrlProvider webResourceUrlProvider, WebResourceIntegration webResourceIntegration) {
        return new Builder(webResourceUrlProvider, webResourceIntegration);
    }

    public static class Builder {
        private final WebResourceUrlProvider webResourceUrlProvider;
        private final WebResourceIntegration webResourceIntegration;
        private Iterable<PluginResourceContainer> resources;
        private Iterable<PluginDataResource> data;

        public Builder(WebResourceUrlProvider webResourceUrlProvider, WebResourceIntegration webResourceIntegration) {
            this.webResourceUrlProvider = webResourceUrlProvider;
            this.webResourceIntegration = webResourceIntegration;
        }

        public Builder(Builder that) {
            this.webResourceUrlProvider = that.webResourceUrlProvider;
            this.webResourceIntegration = that.webResourceIntegration;
            this.resources = that.resources;
            this.data = that.data;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder resources(Iterable<PluginResource> resources) {
            this.resources = this.createPluginResourceContainers(resources);
            return this;
        }

        public Builder data(Iterable<PluginDataResource> data) {
            this.data = data;
            return this;
        }

        public WebResourceSet build(ResourceBatchingConfiguration batchingConfiguration) {
            return new DefaultWebResourceSet(batchingConfiguration, this.webResourceUrlProvider, this.webResourceIntegration, this.resources, this.data);
        }

        private Iterable<PluginResourceContainer> createPluginResourceContainers(Iterable<PluginResource> resources) {
            return Iterables.transform(resources, (Function)new Function<PluginResource, PluginResourceContainer>(){

                public PluginResourceContainer apply(@Nullable PluginResource pluginResource) {
                    return new PluginResourceContainer(Builder.this.webResourceIntegration, Builder.this.webResourceUrlProvider, pluginResource);
                }
            });
        }
    }

    private static class PluginResourceContainer {
        private final PluginResource pluginResource;
        private final PluginUrlResource pluginUrlResource;

        private PluginResourceContainer(WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, PluginResource pluginResource) {
            this.pluginResource = pluginResource;
            this.pluginUrlResource = PluginUrlResourceFactory.create(webResourceIntegration, webResourceUrlProvider, pluginResource);
        }
    }
}

