/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceTransformation {
    private final String extension;
    private final String type;
    private final Map<String, Element> transformerElements;
    private final Iterable<String> transformerKeys;
    private Logger log = LoggerFactory.getLogger(WebResourceTransformation.class);

    public WebResourceTransformation(Element element) {
        Validate.notNull((Object)element.attribute("extension"));
        this.type = element.attributeValue("extension");
        this.extension = "." + this.type;
        LinkedHashMap<String, Element> transformers = new LinkedHashMap<String, Element>();
        for (Element transformElement : element.elements("transformer")) {
            transformers.put(transformElement.attributeValue("key"), transformElement);
        }
        this.transformerElements = Collections.unmodifiableMap(transformers);
        this.transformerKeys = this.transformerElements.keySet();
    }

    public boolean matches(ResourceLocation location) {
        String loc = location.getLocation();
        if (loc == null || "".equals(loc.trim())) {
            loc = location.getName();
        }
        return loc.endsWith(this.extension);
    }

    public boolean matches(String location) {
        return location.equals(this.type);
    }

    public void addTransformParameters(TransformerCache transformerCache, WebResourceModuleDescriptor webResourceModuleDescriptor, UrlBuilder urlBuilder) {
        for (String key : this.transformerKeys) {
            UrlReadingWebResourceTransformerModuleDescriptor descriptor = transformerCache.getDescriptor(key);
            if (descriptor == null) continue;
            descriptor.getModule().makeUrlBuilder(TransformerParameters.of(webResourceModuleDescriptor)).addToUrl(urlBuilder);
        }
    }

    public boolean containsOnlyPureUrlReadingTransformers(TransformerCache transformerCache) {
        for (String key : this.transformerKeys) {
            WebResourceTransformerModuleDescriptor deprecatedTransformer = transformerCache.getDeprecatedDescriptor(key);
            if (deprecatedTransformer == null) continue;
            return false;
        }
        return true;
    }

    public Iterable<WebResourceTransformerModuleDescriptor> getDeprecatedTransformers(TransformerCache transformerCache) {
        LinkedList<WebResourceTransformerModuleDescriptor> deprecatedTransformers = new LinkedList<WebResourceTransformerModuleDescriptor>();
        for (String key : this.transformerKeys) {
            WebResourceTransformerModuleDescriptor deprecatedTransformer = transformerCache.getDeprecatedDescriptor(key);
            if (deprecatedTransformer == null) continue;
            deprecatedTransformers.add(deprecatedTransformer);
        }
        return deprecatedTransformers;
    }

    public DownloadableResource transformDownloadableResource(TransformerCache transformerCache, WebResourceModuleDescriptor webResourceModuleDescriptor, DownloadableResource resource, ResourceLocation resourceLocation, String filePath, QueryParams params) {
        DownloadableResource lastResource = resource;
        for (String transformerKey : this.transformerKeys) {
            UrlReadingWebResourceTransformerModuleDescriptor descriptor = transformerCache.getDescriptor(transformerKey);
            if (descriptor != null) {
                TransformableResource transformableResource = new TransformableResource(resourceLocation, filePath, lastResource);
                lastResource = descriptor.getModule().makeResourceTransformer(TransformerParameters.of(webResourceModuleDescriptor)).transform(transformableResource, params);
                continue;
            }
            WebResourceTransformerModuleDescriptor deprecatedDescriptor = transformerCache.getDeprecatedDescriptor(transformerKey);
            if (deprecatedDescriptor != null) {
                lastResource = deprecatedDescriptor.getModule().transform(this.transformerElements.get(transformerKey), resourceLocation, filePath, lastResource);
                continue;
            }
            this.log.warn("Web resource transformer {} not found for resource {}, skipping", (Object)transformerKey, (Object)resourceLocation.getName());
        }
        return lastResource;
    }
}

