/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.ContextBatchPluginResource;
import com.atlassian.plugin.webresource.PluginResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class BatchResourceContentsWebFormatter {
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("(<\\w+)[\\s|>]");

    public static String insertBatchResourceContents(PluginResource resource, String formattedResource) {
        Map<String, String> dependencyAttributes = BatchResourceContentsWebFormatter.createDependencyAttributes(resource);
        if (dependencyAttributes.isEmpty()) {
            return formattedResource;
        }
        ArrayList<String> nameValues = new ArrayList<String>(dependencyAttributes.size());
        for (Map.Entry<String, String> attr : dependencyAttributes.entrySet()) {
            String nameValuePair = StringEscapeUtils.escapeHtml((String)attr.getKey()) + "=\"" + StringEscapeUtils.escapeHtml((String)attr.getValue()) + "\"";
            nameValues.add(nameValuePair);
        }
        String nameValuesStr = StringUtils.join(nameValues, (char)' ');
        Matcher matcher = TAG_NAME_PATTERN.matcher(formattedResource);
        if (matcher.find()) {
            StringBuilder builder = new StringBuilder(formattedResource);
            builder.insert(matcher.end(1), " " + nameValuesStr);
            return builder.toString();
        }
        return formattedResource;
    }

    private static Map<String, String> createDependencyAttributes(PluginResource resource) {
        HashMap<String, String> dependencyAttributes = new HashMap<String, String>();
        Set<BatchedWebResourceDescriptor> descriptors = resource.getBatchedWebResourceDescriptors();
        ArrayList<String> dependencyValues = new ArrayList<String>(descriptors.size());
        for (BatchedWebResourceDescriptor descriptor : descriptors) {
            String attributeValue = descriptor.getCompleteKey() + "[" + descriptor.getPluginVersion() + "]";
            dependencyValues.add(attributeValue);
        }
        if (!dependencyValues.isEmpty()) {
            dependencyAttributes.put("data-atlassian-webresource-contents", StringUtils.join(dependencyValues, (char)','));
        }
        if (resource instanceof ContextBatchPluginResource) {
            Iterator<String> excludedContextsIterator;
            ContextBatchPluginResource contextBatchPluginResource = (ContextBatchPluginResource)resource;
            Iterator<String> contextsIterator = contextBatchPluginResource.getContexts().iterator();
            if (contextsIterator.hasNext()) {
                dependencyAttributes.put("data-atlassian-webresource-contexts", StringUtils.join(contextsIterator, (char)','));
            }
            if ((excludedContextsIterator = contextBatchPluginResource.getExcludedContexts().iterator()).hasNext()) {
                dependencyAttributes.put("data-atlassian-webresource-excluded-contexts", StringUtils.join(excludedContextsIterator, (char)','));
            }
        }
        return dependencyAttributes;
    }
}

