/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.TransformerUtils;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractTransformResource
implements DownloadableResource {
    static final Charset UTF8 = Charset.forName("UTF-8");
    protected final DownloadableResource originalResource;

    AbstractTransformResource(DownloadableResource originalResource) {
        this.originalResource = originalResource;
    }

    abstract CharSequence transform(CharSequence var1);

    public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
        return this.originalResource.isResourceModified(request, response);
    }

    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        String contentType = this.getContentType();
        if (StringUtils.isNotBlank((String)contentType)) {
            response.setContentType(contentType);
        }
        try {
            this.streamResource((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new DownloadException((Exception)e);
        }
    }

    public void streamResource(OutputStream out) throws DownloadException {
        TransformerUtils.transformAndStreamResource(this.originalResource, UTF8, out, new Function<CharSequence, CharSequence>(){

            public CharSequence apply(CharSequence originalContent) {
                return AbstractTransformResource.this.transform(originalContent);
            }
        });
    }

    public String getContentType() {
        return this.originalResource.getContentType();
    }

    DownloadableResource getOriginalResource() {
        return this.originalResource;
    }
}

