/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.webresource.AbstractPluginResource;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.url.CDNSupport;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.atlassian.util.concurrent.LazyReference;
import java.util.Collections;
import java.util.Map;

public class SinglePluginResource
extends AbstractPluginResource {
    static final String URL_PREFIX = "/download/resources";
    private final String resourceName;
    private final String moduleCompleteKey;
    private final boolean cached;
    private final LazyReference<String> type;

    public SinglePluginResource(String resourceName, String moduleCompleteKey, boolean cached, CDNSupport cdn) {
        this(resourceName, moduleCompleteKey, cached, UrlParameters.of(cdn), Collections.emptyMap());
    }

    public SinglePluginResource(final String resourceName, String moduleCompleteKey, boolean cached, UrlParameters urlParams, Map<String, String> params) {
        super(urlParams, params, Collections.<BatchedWebResourceDescriptor>emptySet());
        this.resourceName = resourceName;
        this.moduleCompleteKey = moduleCompleteKey;
        this.cached = cached;
        this.type = new LazyReference<String>(){

            protected String create() throws Exception {
                return ResourceUtils.getType(resourceName);
            }
        };
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getModuleCompleteKey() {
        return this.moduleCompleteKey;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        Plugin plugin = integration.getPluginAccessor().getEnabledPluginModule(this.getModuleCompleteKey()).getPlugin();
        return plugin.getPluginInformation().getVersion();
    }

    @Override
    public boolean isCacheSupported() {
        return this.cached;
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(URL_PREFIX).append("/").append(this.moduleCompleteKey).append("/").append(this.resourceName);
        ResourceUtils.addParamsToUrl(sb, this.getBatchableParams());
        return sb.toString();
    }

    @Override
    public String getType() {
        return (String)this.type.get();
    }
}

