/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.webresource.AbstractPluginResource;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.ResourceKey;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

public class BatchPluginResource
extends AbstractPluginResource {
    static final String URL_PREFIX = "/download/batch";
    private final ResourceKey resource;
    private int hash = 0;

    BatchPluginResource(ResourceKey resource, UrlParameters urlParams, Map<String, String> params, BatchedWebResourceDescriptor batchedWebResourceDescriptor) {
        super(urlParams, params, (Set<BatchedWebResourceDescriptor>)ImmutableSet.of((Object)batchedWebResourceDescriptor));
        this.resource = resource;
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(URL_PREFIX).append("/").append(this.resource.key()).append("/").append(this.resource.name());
        ResourceUtils.addParamsToUrl(sb, this.params, this.getBatchableParams());
        return sb.toString();
    }

    @Override
    public String getResourceName() {
        return this.resource.name();
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        Plugin plugin = integration.getPluginAccessor().getEnabledPluginModule(this.getModuleCompleteKey()).getPlugin();
        return plugin.getPluginInformation().getVersion();
    }

    @Override
    public String getModuleCompleteKey() {
        return this.resource.key();
    }

    @Override
    public boolean isCacheSupported() {
        return !"false".equals(this.params.get("cache"));
    }

    @Override
    public String getType() {
        return this.resource.suffix();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPluginResource that = (BatchPluginResource)o;
        return Objects.equal((Object)this.params, (Object)that.params) && Objects.equal((Object)this.resource, (Object)that.resource);
    }

    public int hashCode() {
        if (this.hash != 0) {
            this.hash = Objects.hashCode((Object[])new Object[]{this.resource, this.params});
        }
        return this.hash;
    }

    public String toString() {
        return "[moduleCompleteKey=" + this.resource.key() + ", type=" + this.resource.suffix() + ", params=" + this.params + "]";
    }
}

