/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.SuperBatchPluginResource;
import com.atlassian.plugin.webresource.url.NamedHash;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SuperBatchOperations {
    SuperBatchOperations() {
    }

    public static SuperBatchPluginResource mergeSameBatch(SuperBatchPluginResource superBatch, PluginResource pluginResource) {
        HashMap mergedBatchableParams = Maps.newHashMap(superBatch.getBatchableParams());
        mergedBatchableParams.putAll(pluginResource.getBatchableParams());
        ImmutableList mergedHashes = ImmutableList.copyOf((Iterable)Iterables.concat(superBatch.getHashes(), pluginResource.getHashes()));
        SuperBatchPluginResource merged = new SuperBatchPluginResource(superBatch.getType(), (List<NamedHash>)mergedHashes, superBatch.getParams(), (Map<String, String>)mergedBatchableParams);
        for (BatchedWebResourceDescriptor bwrd : superBatch.getBatchedWebResourceDescriptors()) {
            merged.addBatchedWebResourceDescriptor(bwrd);
        }
        for (BatchedWebResourceDescriptor bwrd : pluginResource.getBatchedWebResourceDescriptors()) {
            merged.addBatchedWebResourceDescriptor(bwrd);
        }
        return merged;
    }
}

