/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.cache.filecache.impl;

import com.atlassian.plugin.cache.filecache.FileCache;
import com.atlassian.plugin.cache.filecache.FileCacheStreamProvider;
import com.atlassian.plugin.cache.filecache.impl.CachedFile;
import com.atlassian.plugin.servlet.DownloadException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class FileCacheImpl<K>
implements FileCache<K> {
    static final String EXT = ".cachedfile";
    private final Cache<K, CachedFile> cache;
    private final File tmpDir;
    private final AtomicLong filenameCounter;

    public FileCacheImpl(File tmpDir, int maxSize, AtomicLong filenameCounter) throws IOException {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Max files can not be less than zero");
        }
        FileCacheImpl.initDirectory(tmpDir);
        this.tmpDir = tmpDir;
        this.cache = CacheBuilder.newBuilder().maximumSize(maxSize).removalListener(new RemovalListener<K, CachedFile>(){

            public void onRemoval(RemovalNotification<K, CachedFile> notification) {
                FileCacheImpl.this.onEviction((CachedFile)notification.getValue());
            }
        }).build(new CacheLoader<K, CachedFile>(){

            public CachedFile load(K key) throws Exception {
                return FileCacheImpl.this.newCachedFile();
            }
        });
        this.filenameCounter = filenameCounter;
    }

    private static void initDirectory(File tmpDir) throws IOException {
        tmpDir.mkdirs();
        File[] files = tmpDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().toLowerCase().endsWith(EXT) || f.delete()) continue;
                throw new IOException("Could not delete existing cache file " + f);
            }
        }
        if (!tmpDir.isDirectory()) {
            throw new IOException("Could not create tmp directory " + tmpDir);
        }
    }

    @Override
    public void stream(K key, OutputStream dest, FileCacheStreamProvider input) throws DownloadException {
        CachedFile cachedFile = (CachedFile)this.cache.getUnchecked(key);
        cachedFile.stream(dest, input);
    }

    @Override
    public void clear() {
        ArrayList cachedFiles = new ArrayList(this.cache.asMap().values());
        this.cache.invalidateAll();
        for (CachedFile cachedFile : cachedFiles) {
            cachedFile.deleteWhenPossible();
        }
    }

    private CachedFile newCachedFile() {
        File file = new File(this.tmpDir, this.filenameCounter.incrementAndGet() + EXT);
        return new CachedFile(file);
    }

    private void onEviction(CachedFile node) {
        node.deleteWhenPossible();
    }
}

