package com.atlassian.plugin.webresource.url;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Implementation of UrlBuilder
 *
 * @since v3.0
 */
public class DefaultUrlBuilder implements UrlBuilder
{
    private final List<NamedHash> hashes;
    private final Map<String, String> queryString;

    public DefaultUrlBuilder()
    {
        this.hashes = Lists.newLinkedList();
        this.queryString = Maps.newLinkedHashMap();
    }

    @Override
    public void addToHash(String name, Object value)
    {
        hashes.add(new NamedHash(name, value.toString()));
    }

    public List<NamedHash> allHashes()
    {
        return Collections.unmodifiableList(hashes);
    }

    @Override
    public void addToQueryString(String key, String value)
    {
        queryString.put(key, value);
    }

    public Map<String, String> toQueryString()
    {
        return Collections.unmodifiableMap(queryString);
    }
}
