package com.atlassian.plugin.cache.filecache.impl;

import com.atlassian.plugin.cache.filecache.FileCache;
import com.atlassian.plugin.cache.filecache.FileCacheStreamProvider;
import com.atlassian.plugin.servlet.DownloadException;

import java.io.OutputStream;

/**
 * Always streams each resource from the given input
 * @since v2.13
 */
public class PassThroughFileCache<K> implements FileCache<K> {
    public static <K>PassThroughFileCache<K> instance() {
        return new PassThroughFileCache<K>();
    }

    @Override
    public void stream(K key, OutputStream dest, FileCacheStreamProvider input) throws DownloadException {
        input.writeStream(dest);
    }

    @Override
    public void clear() {
    }
}
