/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultResourceDependencyResolver
implements ResourceDependencyResolver {
    private static final Log log = LogFactory.getLog(DefaultResourceDependencyResolver.class);
    private final WebResourceIntegration webResourceIntegration;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private String superBatchVersion;
    private LinkedHashSet<String> superBatchResources;

    public DefaultResourceDependencyResolver(WebResourceIntegration webResourceIntegration, ResourceBatchingConfiguration batchingConfiguration) {
        this.webResourceIntegration = webResourceIntegration;
        this.batchingConfiguration = batchingConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashSet<String> getSuperBatchDependencies() {
        if (!this.batchingConfiguration.isSuperBatchingEnabled()) {
            log.warn((Object)"Super batching not enabled, but getSuperBatchDependencies() called. Returning empty set.");
            return new LinkedHashSet<String>();
        }
        String version = this.webResourceIntegration.getSuperBatchVersion();
        if (this.superBatchVersion == null || !this.superBatchVersion.equals(version)) {
            LinkedHashSet<String> webResourceNames = new LinkedHashSet<String>();
            if (this.batchingConfiguration.getSuperBatchModuleCompleteKeys() != null) {
                for (String moduleKey : this.batchingConfiguration.getSuperBatchModuleCompleteKeys()) {
                    this.resolveDependencies(moduleKey, webResourceNames, Collections.emptySet(), new Stack<String>());
                }
            }
            DefaultResourceDependencyResolver defaultResourceDependencyResolver = this;
            synchronized (defaultResourceDependencyResolver) {
                this.superBatchResources = webResourceNames;
                this.superBatchVersion = version;
            }
        }
        return new LinkedHashSet<String>(this.superBatchResources);
    }

    @Override
    public LinkedHashSet<String> getDependencies(String moduleKey, boolean excludeSuperBatchedResources) {
        LinkedHashSet<String> orderedResourceKeys = new LinkedHashSet<String>();
        Set superBatchResources = excludeSuperBatchedResources ? this.getSuperBatchDependencies() : Collections.emptySet();
        this.resolveDependencies(moduleKey, orderedResourceKeys, superBatchResources, new Stack<String>());
        return orderedResourceKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveDependencies(String moduleKey, LinkedHashSet<String> orderedResourceKeys, Set superBatchResources, Stack<String> stack) {
        if (superBatchResources.contains(moduleKey)) {
            log.debug((Object)("Not requiring resource: " + moduleKey + " because it is part of a super-batch"));
            return;
        }
        if (stack.contains(moduleKey)) {
            log.warn((Object)("Cyclic plugin resource dependency has been detected with: " + moduleKey + "\n" + "Stack trace: " + stack));
            return;
        }
        ModuleDescriptor moduleDescriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleKey);
        if (!(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            if (this.webResourceIntegration.getPluginAccessor().getPluginModule(moduleKey) != null) {
                log.warn((Object)("Cannot include disabled web resource module: " + moduleKey));
            } else {
                log.warn((Object)("Cannot find web resource module for: " + moduleKey));
            }
            return;
        }
        List<String> dependencies = ((WebResourceModuleDescriptor)moduleDescriptor).getDependencies();
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to add resource [" + moduleKey + "] and its dependencies: " + dependencies));
        }
        stack.push(moduleKey);
        try {
            for (String dependency : dependencies) {
                if (orderedResourceKeys.contains(dependency)) continue;
                this.resolveDependencies(dependency, orderedResourceKeys, superBatchResources, stack);
            }
        }
        finally {
            stack.pop();
        }
        orderedResourceKeys.add(moduleKey);
    }
}

