/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.webresource.ContextBatchPluginResource;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceBatchParams;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.TransformDescriptorToKey;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;

class ContextBatch {
    private static final String UTF8 = "UTF-8";
    private static final String MD5 = "MD5";
    private static final Ordering<ModuleDescriptor<?>> MODULE_KEY_ORDERING = Ordering.natural().onResultOf((Function)new TransformDescriptorToKey());
    private final String key;
    private final List<String> contexts;
    private final Iterable<String> excludedContexts;
    private final Iterable<WebResourceModuleDescriptor> resources;
    private final Iterable<String> resourceKeys;
    private final Set<PluginResourceBatchParams> resourceParams;

    ContextBatch(String context, Iterable<WebResourceModuleDescriptor> resources) {
        this(context, (List<String>)ImmutableList.of((Object)context), resources, (Iterable<PluginResourceBatchParams>)ImmutableList.of());
    }

    ContextBatch(String key, List<String> contexts, Iterable<WebResourceModuleDescriptor> resources, Iterable<PluginResourceBatchParams> resourceParams) {
        this(key, contexts, null, resources, resourceParams);
    }

    ContextBatch(String key, List<String> contexts, Iterable<String> excludedContexts, Iterable<WebResourceModuleDescriptor> resources, Iterable<PluginResourceBatchParams> resourceParams) {
        this.key = key;
        this.contexts = ImmutableList.copyOf(contexts);
        this.excludedContexts = excludedContexts == null ? Collections.emptyList() : ImmutableList.copyOf(excludedContexts);
        this.resourceParams = Sets.newHashSet(resourceParams);
        this.resources = ImmutableSortedSet.copyOf(MODULE_KEY_ORDERING, resources);
        this.resourceKeys = Iterables.transform(resources, (Function)new TransformDescriptorToKey());
    }

    boolean isResourceIncluded(String resourceModuleKey) {
        return Iterables.contains(this.resourceKeys, (Object)resourceModuleKey);
    }

    void addResourceType(PluginResource pluginResource) {
        HashMap<String, String> parameters = new HashMap<String, String>(PluginResourceLocator.BATCH_PARAMS.length);
        String type = ResourceUtils.getType(pluginResource.getResourceName());
        for (String key : PluginResourceLocator.BATCH_PARAMS) {
            if (pluginResource.getParams().get(key) == null) continue;
            parameters.put(key, pluginResource.getParams().get(key));
        }
        this.resourceParams.add(new PluginResourceBatchParams(type, parameters));
    }

    Iterable<PluginResource> buildPluginResources() {
        final String hash = this.createHash();
        return Iterables.transform(this.resourceParams, (Function)new Function<PluginResourceBatchParams, PluginResource>(){

            public PluginResource apply(PluginResourceBatchParams param) {
                return new ContextBatchPluginResource(ContextBatch.this.key, hash, param.getType(), param.getParameters());
            }
        });
    }

    private String createHash() {
        try {
            MessageDigest md5 = MessageDigest.getInstance(MD5);
            for (WebResourceModuleDescriptor moduleDescriptor : this.resources) {
                String version = moduleDescriptor.getPlugin().getPluginInformation().getVersion();
                md5.update(moduleDescriptor.getCompleteKey().getBytes(UTF8));
                md5.update(version.getBytes(UTF8));
            }
            return new String(Hex.encodeHex((byte[])md5.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"MD5 hashing algorithm is not available.");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 encoding is not available.");
        }
    }

    String getKey() {
        return this.key;
    }

    List<String> getContexts() {
        return this.contexts;
    }

    public Iterable<String> getExcludedContexts() {
        return this.excludedContexts;
    }

    Iterable<WebResourceModuleDescriptor> getResources() {
        return this.resources;
    }

    Iterable<String> getResourceKeys() {
        return Iterables.transform(this.resources, (Function)new Function<WebResourceModuleDescriptor, String>(){

            public String apply(WebResourceModuleDescriptor input) {
                return input.getCompleteKey();
            }
        });
    }

    Iterable<PluginResourceBatchParams> getResourceParams() {
        return Collections.unmodifiableSet(this.resourceParams);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextBatch)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ContextBatch other = (ContextBatch)obj;
        return this.key.equals(other.key);
    }

    public int hashCode() {
        return 17 * this.key.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ContextBatch[key=");
        builder.append(this.getKey());
        if (this.contexts != null && Iterables.size(this.contexts) > 0) {
            builder.append(", includedContexts=").append(Iterables.toString(this.contexts));
        }
        if (this.excludedContexts != null && Iterables.size(this.excludedContexts) > 0) {
            builder.append(", excludedContexts=").append(Iterables.toString(this.excludedContexts));
        }
        if (this.resourceKeys != null && Iterables.size(this.resourceKeys) > 0) {
            builder.append(", resourceKeys=").append(Iterables.toString(this.resourceKeys));
        }
        builder.append("]");
        return builder.toString();
    }
}

