/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class BatchPluginResource
implements PluginResource {
    static final String URL_PREFIX = "/download/batch";
    private final String type;
    private final String moduleCompleteKey;
    private final Map<String, String> params;
    private final String resourceName;

    public BatchPluginResource(String moduleCompleteKey, String type, Map<String, String> params) {
        this(moduleCompleteKey + "." + type, moduleCompleteKey, type, params);
    }

    BatchPluginResource(String resourceName, String moduleCompleteKey, String type, Map<String, String> params) {
        this.resourceName = resourceName;
        this.moduleCompleteKey = moduleCompleteKey;
        this.type = type;
        this.params = ImmutableMap.copyOf(params);
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(URL_PREFIX).append("/").append(this.moduleCompleteKey).append("/").append(this.resourceName);
        ResourceUtils.addParamsToUrl(sb, this.params);
        return sb.toString();
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        Plugin plugin = integration.getPluginAccessor().getEnabledPluginModule(this.getModuleCompleteKey()).getPlugin();
        return plugin.getPluginInformation().getVersion();
    }

    @Override
    public String getModuleCompleteKey() {
        return this.moduleCompleteKey;
    }

    @Override
    public boolean isCacheSupported() {
        return !"false".equals(this.params.get("cache"));
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPluginResource that = (BatchPluginResource)o;
        if (this.moduleCompleteKey != null ? !this.moduleCompleteKey.equals(that.moduleCompleteKey) : that.moduleCompleteKey != null) {
            return false;
        }
        if (this.params != null ? !((Object)this.params).equals(that.params) : that.params != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.moduleCompleteKey != null ? this.moduleCompleteKey.hashCode() : 0);
        result = 31 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[moduleCompleteKey=" + this.moduleCompleteKey + ", type=" + this.type + ", params=" + this.params + "]";
    }
}

