/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.cache.filecache.FileCacheStreamProvider;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.NewlineResourceContentAnnotator;
import com.atlassian.plugin.webresource.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.TryCatchJsResourceContentAnnotator;
import com.atlassian.plugin.webresource.cache.CacheHandle;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchDownloadableResource
implements DownloadableResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchDownloadableResource.class);
    private static final ResourceContentAnnotator[] DEFAULT_ANNOTATORS = new ResourceContentAnnotator[]{new NewlineResourceContentAnnotator()};
    private static final ResourceContentAnnotator[] JS_WRAP_ANNOTATORS = new ResourceContentAnnotator[]{new NewlineResourceContentAnnotator(), new TryCatchJsResourceContentAnnotator()};
    private final String type;
    private final Map<String, String> params;
    private final Iterable<DownloadableResource> resources;
    private final CacheHandle cacher;

    AbstractBatchDownloadableResource(String type, Map<String, String> params, Iterable<DownloadableResource> resources, CacheHandle cacher) {
        this.type = type;
        this.params = ImmutableMap.copyOf(params);
        this.resources = ImmutableList.copyOf(resources);
        this.cacher = cacher;
    }

    public boolean isEmpty() {
        return Iterables.isEmpty(this.resources);
    }

    @Override
    public boolean isResourceModified(final HttpServletRequest request, final HttpServletResponse response) {
        return Iterables.any(this.resources, (Predicate)new Predicate<DownloadableResource>(){

            public boolean apply(DownloadableResource resource) {
                return resource.isResourceModified(request, response);
            }
        });
    }

    @Override
    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        ServletOutputStream out;
        if (log.isDebugEnabled()) {
            log.debug("Start to serve batch " + this.toString());
        }
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            throw new DownloadException(e);
        }
        this.streamResourceInternal((OutputStream)out, this.getAnnotators(request));
    }

    @Override
    public void streamResource(OutputStream originalOut) throws DownloadException {
        this.streamResourceInternal(originalOut, this.getAnnotators(null));
    }

    private void streamResourceInternal(OutputStream originalOut, final ResourceContentAnnotator[] annotators) throws DownloadException {
        FileCacheStreamProvider streamProvider = new FileCacheStreamProvider(){

            @Override
            public void writeStream(OutputStream dest) throws DownloadException {
                for (DownloadableResource resource : AbstractBatchDownloadableResource.this.resources) {
                    try {
                        AbstractBatchDownloadableResource.this.applyBeforeAnnotators(dest, annotators);
                        resource.streamResource(dest);
                        AbstractBatchDownloadableResource.this.applyAfterAnnotators(dest, annotators);
                    }
                    catch (IOException ex) {
                        throw new DownloadException(ex);
                    }
                }
            }
        };
        this.cacher.stream(originalOut, streamProvider);
    }

    @Override
    public String getContentType() {
        String contentType = this.params.get("content-type");
        if (contentType != null) {
            return contentType;
        }
        return null;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getType() {
        return this.type;
    }

    private void applyBeforeAnnotators(OutputStream str, ResourceContentAnnotator[] annotators) throws IOException {
        for (ResourceContentAnnotator annotator : annotators) {
            annotator.before(str);
        }
    }

    private void applyAfterAnnotators(OutputStream str, ResourceContentAnnotator[] annotators) throws IOException {
        for (int i = annotators.length - 1; i >= 0; --i) {
            annotators[i].after(str);
        }
    }

    private ResourceContentAnnotator[] getAnnotators(HttpServletRequest request) {
        if (request == null || !"js".equals(this.getType()) || !"true".equals(request.getParameter("trycatchwrap"))) {
            return DEFAULT_ANNOTATORS;
        }
        return JS_WRAP_ANNOTATORS;
    }
}

