/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.BatchResource;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPluginResource
implements DownloadableResource,
PluginResource,
BatchResource {
    private static final Logger log = LoggerFactory.getLogger(BatchPluginResource.class);
    static final String URL_PREFIX = "/download/batch";
    private final String type;
    private final String moduleCompleteKey;
    private final Map<String, String> params;
    private final String resourceName;
    private final Iterable<DownloadableResource> resources;

    public BatchPluginResource(String moduleCompleteKey, String type, Map<String, String> params) {
        this(moduleCompleteKey + "." + type, moduleCompleteKey, type, params, Collections.emptyList());
    }

    public BatchPluginResource(String moduleCompleteKey, String type, Map<String, String> params, Iterable<DownloadableResource> resources) {
        this(moduleCompleteKey + "." + type, moduleCompleteKey, type, params, resources);
    }

    BatchPluginResource(String resourceName, String moduleCompleteKey, String type, Map<String, String> params, Iterable<DownloadableResource> resources) {
        this.resourceName = resourceName;
        this.moduleCompleteKey = moduleCompleteKey;
        this.type = type;
        this.params = ImmutableMap.copyOf(params);
        this.resources = ImmutableList.copyOf(resources);
    }

    public boolean isEmpty() {
        return Iterables.isEmpty(this.resources);
    }

    @Override
    public boolean isResourceModified(final HttpServletRequest request, final HttpServletResponse response) {
        return Iterables.any(this.resources, (Predicate)new Predicate<DownloadableResource>(){

            public boolean apply(DownloadableResource resource) {
                return resource.isResourceModified(request, response);
            }
        });
    }

    @Override
    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        if (log.isDebugEnabled()) {
            log.debug("Start to serve batch " + this.toString());
        }
        for (DownloadableResource resource : this.resources) {
            resource.serveResource(request, response);
            BatchPluginResource.writeNewLine(response);
        }
    }

    @Override
    public void streamResource(OutputStream out) throws DownloadException {
        for (DownloadableResource resource : this.resources) {
            resource.streamResource(out);
            BatchPluginResource.writeNewLine(out);
        }
    }

    @Override
    public String getContentType() {
        String contentType = this.params.get("content-type");
        if (contentType != null) {
            return contentType;
        }
        return null;
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(URL_PREFIX).append("/").append(this.moduleCompleteKey).append("/").append(this.resourceName);
        this.addParamsToUrl(sb, this.params);
        return sb.toString();
    }

    protected void addParamsToUrl(StringBuilder sb, Map<String, String> params) {
        if (params.size() > 0) {
            sb.append("?");
            int count = 0;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                try {
                    sb.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                    if (++count >= params.size()) continue;
                    sb.append("&");
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Could not encode parameter to url for [" + entry.getKey() + "] with value [" + entry.getValue() + "]", (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        Plugin plugin = integration.getPluginAccessor().getEnabledPluginModule(this.getModuleCompleteKey()).getPlugin();
        return plugin.getPluginInformation().getVersion();
    }

    @Override
    public String getModuleCompleteKey() {
        return this.moduleCompleteKey;
    }

    @Override
    public boolean isCacheSupported() {
        return !"false".equals(this.params.get("cache"));
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPluginResource that = (BatchPluginResource)o;
        if (this.moduleCompleteKey != null ? !this.moduleCompleteKey.equals(that.moduleCompleteKey) : that.moduleCompleteKey != null) {
            return false;
        }
        if (this.params != null ? !((Object)this.params).equals(that.params) : that.params != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.moduleCompleteKey != null ? this.moduleCompleteKey.hashCode() : 0);
        result = 31 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[moduleCompleteKey=" + this.moduleCompleteKey + ", type=" + this.type + ", params=" + this.params + "]";
    }

    private static void writeNewLine(HttpServletResponse response) throws DownloadException {
        try {
            BatchPluginResource.writeNewLine((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new DownloadException(e);
        }
    }

    private static void writeNewLine(OutputStream out) throws DownloadException {
        try {
            out.write(10);
        }
        catch (IOException e) {
            throw new DownloadException(e);
        }
    }
}

