/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.util;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LastModifiedHandler {
    private long lastModified;
    private String etag;
    private static final int ONE_SECOND_MILLIS = 1000;

    public LastModifiedHandler() {
        this.modified(new Date());
    }

    public LastModifiedHandler(Date lastModifiedDate) {
        this.modified(lastModifiedDate);
    }

    public boolean checkRequest(HttpServletRequest request, HttpServletResponse response) {
        return LastModifiedHandler.checkRequest(request, response, this.lastModified, this.etag);
    }

    public void modified() {
        this.modified(new Date());
    }

    private void modified(Date date) {
        this.lastModified = LastModifiedHandler.calculateLastModifiedDate(date);
        this.etag = LastModifiedHandler.calculateEtag(this.lastModified);
    }

    private static long calculateLastModifiedDate(Date lastModifiedDate) {
        long lastModified = lastModifiedDate.getTime();
        lastModified -= lastModified % 1000L;
        return lastModified;
    }

    private static String calculateEtag(long lastModified) {
        return "\"" + lastModified + "\"";
    }

    public static boolean checkRequest(HttpServletRequest request, HttpServletResponse response, Date lastModifiedDate) {
        long lastModified = LastModifiedHandler.calculateLastModifiedDate(lastModifiedDate);
        return LastModifiedHandler.checkRequest(request, response, lastModified, LastModifiedHandler.calculateEtag(lastModified));
    }

    private static boolean checkRequest(HttpServletRequest request, HttpServletResponse response, long lastModified, String etagString) {
        if ("true".equals(System.getProperty("atlassian.disable.caches", "false"))) {
            return false;
        }
        response.setDateHeader("Last-Modified", lastModified);
        response.setHeader("ETag", etagString);
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (LastModifiedHandler.noConditionalGetHeadersFound(ifModifiedSince, ifNoneMatch) || LastModifiedHandler.isContentModifiedSince(ifModifiedSince, lastModified) || !LastModifiedHandler.etagMatches(ifNoneMatch, etagString)) {
            return false;
        }
        response.setStatus(304);
        return true;
    }

    private static boolean etagMatches(String ifNoneMatch, String etagString) {
        return ifNoneMatch != null && ifNoneMatch.equals(etagString);
    }

    private static boolean isContentModifiedSince(long ifModifiedSince, long lastModified) {
        return ifModifiedSince != -1L && ifModifiedSince < lastModified;
    }

    private static boolean noConditionalGetHeadersFound(long ifModifiedSince, String ifNoneMatch) {
        return ifModifiedSince == -1L && ifNoneMatch == null;
    }
}

