/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.compiler;

import com.atlassian.webresource.compiler.GCCUtil;
import com.atlassian.webresource.spi.CompilerEntry;
import com.atlassian.webresource.spi.ResourceCompiler;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCCResourceCompiler
implements ResourceCompiler {
    private static final Logger log = LoggerFactory.getLogger(GCCResourceCompiler.class);
    private final CompilerOptions options;
    private final Compiler compiler;
    private final List<SourceFile> externs;

    private GCCResourceCompiler(@Nonnull PrintStream out, @Nonnull CompilerOptions options) {
        this.options = (CompilerOptions)Preconditions.checkNotNull((Object)options);
        this.compiler = new Compiler((PrintStream)Preconditions.checkNotNull((Object)out));
        try {
            this.externs = AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions)options);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public GCCResourceCompiler() {
        this(System.out, GCCUtil.initOptionsFromLevel(CompilationLevel.WHITESPACE_ONLY));
    }

    public void compile(@Nonnull Stream<CompilerEntry> entries) {
        List sources = ((Stream)Preconditions.checkNotNull(entries, (Object)"entries can't be null")).flatMap(GCCUtil::entryToSource).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            log.debug("compiling sources: {}", sources);
        }
        this.compiler.compile(this.externs, sources, this.options);
    }

    public String content(@Nonnull String key) {
        Node node = this.getNodeByKey((String)Preconditions.checkNotNull((Object)key, (Object)"key can't be null"));
        if (node == null) {
            log.warn("can't find Node for: {}", (Object)key);
            return null;
        }
        return this.compiler.toSource(node);
    }

    private Node getNodeByKey(String key) {
        InputId id = new InputId(key);
        CompilerInput input = this.compiler.getInput(id);
        if (input == null) {
            log.warn("can't find CompilerInput for: {}", (Object)key);
            return null;
        }
        return input.getAstRoot((AbstractCompiler)this.compiler);
    }
}

