/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.cache.filter;

import com.atlassian.plugin.servlet.cache.model.CacheInformation;
import com.atlassian.plugin.servlet.cache.model.CacheableResponse;
import com.atlassian.plugin.servlet.cache.model.ETagToken;
import com.atlassian.plugin.servlet.util.function.FailableConsumer;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagCachingFilter
implements Filter {
    private static final Pattern CACHEABLE_FILE_PATTERN = Pattern.compile(".+\\.(css|js)");

    private static boolean isCacheableRequest(ServletRequest request, ServletResponse response) {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            return CACHEABLE_FILE_PATTERN.matcher(httpServletRequest.getRequestURI()).matches();
        }
        return false;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (ETagCachingFilter.isCacheableRequest(request, response)) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            this.doFilterWithCachingHeader(httpServletRequest, httpServletResponse, chain);
            return;
        }
        chain.doFilter(request, response);
    }

    private void doFilterWithCachingHeader(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        CacheableResponse wrappedResponse = new CacheableResponse(response);
        chain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
        CacheInformation cacheInformation = new CacheInformation(request);
        if (cacheInformation.hasFreshContent(wrappedResponse)) {
            wrappedResponse.getContentBody().ifPresent(FailableConsumer.wrapper(contentBody -> {
                response.setContentLength(((byte[])contentBody).length);
                response.getOutputStream().write(contentBody);
                response.getOutputStream().flush();
            }));
        }
        if (cacheInformation.hasNotFreshContent(wrappedResponse)) {
            response.setStatus(304);
        }
        wrappedResponse.toETagToken().map(ETagToken::getDoubleQuotedValue).ifPresent(etag -> response.setHeader("ETag", etag));
    }

    public void destroy() {
    }
}

