package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;

import javax.annotation.Nonnull;

/**
 * Describes a resource for transformation
 *
 * @since v3.0
 */
public class TransformableResource {
    private final ResourceLocation location;
    private final DownloadableResource nextResource;

    public TransformableResource(ResourceLocation location, DownloadableResource nextResource) {
        this.location = location;
        this.nextResource = nextResource;
    }

    /**
     * @deprecated since 5.0.0, will be removed in next major version,
     * use `TransformableResource(ResourceLocation location, DownloadableResource nextResource)` instead.
     */
    @Deprecated
    public TransformableResource(ResourceLocation location, String filePath, DownloadableResource nextResource) {
        this.location = location;
        this.nextResource = nextResource;
    }

    /**
     * The original resource location
     */
    public ResourceLocation location() {
        return this.location;
    }

    /**
     * Extra path information. Cannot be null, but can be an empty string if no extra path information
     *
     * @deprecated since 5.0.0, will be removed in next major version.
     */
    @Deprecated
    @Nonnull
    public String filePath() {
        return "";
    }

    /**
     * The original resource
     */
    public DownloadableResource nextResource() {
        return nextResource;
    }
}
