package com.atlassian.plugin.webresource.transformer;

/**
 * Transformer parameters to be passed to
 * {@link com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory}'s methods
 *
 * @since v3.0.5
 */
public class TransformerParameters
{
    private final String pluginKey;
    private final String moduleKey;

    public TransformerParameters(String pluginKey, String moduleKey)
    {
        this.pluginKey = pluginKey;
        this.moduleKey = moduleKey;
    }

    /**
     * @return the key of the plugin containing resources to be transformed
     */
    public String getPluginKey()
    {
        return pluginKey;
    }

    /**
     * @return the key of the web-resource module containing resources to be transformed
     */
    public String getModuleKey()
    {
        return moduleKey;
    }
}
