/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.pluginns;

import com.atlassian.plugin.osgi.hostcomponents.ContextClassLoaderStrategy;
import com.atlassian.plugin.spring.PluginBeanDefinitionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class PluginContextClassLoaderStrategyBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    private static final Logger log = LoggerFactory.getLogger(PluginContextClassLoaderStrategyBeanDefinitionDecorator.class);

    public BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder holder, ParserContext ctx) {
        String contextClassLoaderStrategy = ((Attr)source).getValue();
        if (contextClassLoaderStrategy != null) {
            new PluginBeanDefinitionRegistry(ctx.getRegistry()).addContextClassLoaderStrategy(holder.getBeanName(), this.getContextClassLoaderStrategy(contextClassLoaderStrategy));
        }
        return holder;
    }

    private ContextClassLoaderStrategy getContextClassLoaderStrategy(String contextClassLoaderStrategy) {
        try {
            return ContextClassLoaderStrategy.valueOf((String)contextClassLoaderStrategy);
        }
        catch (IllegalArgumentException e) {
            log.warn("Cannot parse '{}' to a valid context class loader strategy, will use default '{}'", (Object)contextClassLoaderStrategy, (Object)ContextClassLoaderStrategy.USE_HOST);
            return ContextClassLoaderStrategy.USE_HOST;
        }
    }
}

