/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.descriptors;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.BaseServletModuleDescriptor;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import java.util.Comparator;
import javax.servlet.Filter;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletFilterModuleDescriptor
extends BaseServletModuleDescriptor<Filter>
implements StateAware {
    static final String DEFAULT_LOCATION = FilterLocation.BEFORE_DISPATCH.name();
    static final String DEFAULT_WEIGHT = "100";
    private FilterLocation location;
    private int weight;
    private final ServletModuleManager servletModuleManager;
    private final HostContainer hostContainer;
    public static final Comparator<ServletFilterModuleDescriptor> byWeight = new Comparator<ServletFilterModuleDescriptor>(){

        @Override
        public int compare(ServletFilterModuleDescriptor lhs, ServletFilterModuleDescriptor rhs) {
            return Integer.valueOf(lhs.getWeight()).compareTo(rhs.getWeight());
        }
    };

    public ServletFilterModuleDescriptor(HostContainer hostContainer, ServletModuleManager servletModuleManager) {
        Validate.notNull((Object)hostContainer);
        Validate.notNull((Object)servletModuleManager);
        this.hostContainer = hostContainer;
        this.servletModuleManager = servletModuleManager;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        try {
            this.location = FilterLocation.parse(element.attributeValue("location", DEFAULT_LOCATION));
            this.weight = Integer.valueOf(element.attributeValue("weight", DEFAULT_WEIGHT));
        }
        catch (IllegalArgumentException ex) {
            throw new PluginParseException((Throwable)ex);
        }
    }

    public void enabled() {
        super.enabled();
        this.servletModuleManager.addFilterModule(this);
    }

    public void disabled() {
        this.servletModuleManager.removeFilterModule(this);
        super.disabled();
    }

    public Filter getModule() {
        Filter filter = null;
        filter = this.plugin instanceof AutowireCapablePlugin ? (Filter)((AutowireCapablePlugin)this.plugin).autowire(this.getModuleClass()) : (Filter)this.hostContainer.create(this.getModuleClass());
        return filter;
    }

    public FilterLocation getLocation() {
        return this.location;
    }

    public int getWeight() {
        return this.weight;
    }
}

