/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.util.validation.ValidationPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseServletModuleDescriptor<T>
extends AbstractModuleDescriptor<T> {
    protected static final Log log = LogFactory.getLog(BaseServletModuleDescriptor.class);
    private List<String> paths;
    private Map<String, String> initParams;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        List urlPatterns = element.elements("url-pattern");
        this.paths = new ArrayList<String>(urlPatterns.size());
        for (Element urlPattern : urlPatterns) {
            this.paths.add(urlPattern.getTextTrim());
        }
        this.initParams = new HashMap<String, String>();
        List paramsList = element.elements("init-param");
        for (Element initParamEl : paramsList) {
            Element paramNameEl = initParamEl.element("param-name");
            Element paramValueEl = initParamEl.element("param-value");
            this.initParams.put(paramNameEl.getTextTrim(), paramValueEl.getTextTrim());
        }
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@class").withError("The class is required"), ValidationPattern.test((String)"url-pattern").withError("There must be at least one path specified")}).rule("init-param", new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"param-name").withError("Parameter name is required"), ValidationPattern.test((String)"param-value").withError("Parameter value is required")});
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }
}

