/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.servlet.DelegatingPluginServlet;
import com.atlassian.plugin.servlet.PluginServletConfig;
import com.atlassian.plugin.servlet.PluginServletContextWrapper;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletContextListenerModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletContextParamModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.servlet.filter.DelegatingPluginFilter;
import com.atlassian.plugin.servlet.filter.FilterDispatcherCondition;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.plugin.servlet.filter.PluginFilterConfig;
import com.atlassian.plugin.servlet.util.DefaultPathMapper;
import com.atlassian.plugin.servlet.util.PathMapper;
import com.atlassian.plugin.servlet.util.ServletContextServletModuleManagerAccessor;
import com.atlassian.plugin.util.ClassLoaderStack;
import com.atlassian.util.concurrent.LazyReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServletModuleManager
implements ServletModuleManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultServletModuleManager.class);
    private final PathMapper servletMapper;
    private final Map<String, ServletModuleDescriptor> servletDescriptors = new HashMap<String, ServletModuleDescriptor>();
    private final ConcurrentMap<String, LazyReference<HttpServlet>> servletRefs = new ConcurrentHashMap<String, LazyReference<HttpServlet>>();
    private final PathMapper filterMapper;
    private final Map<String, ServletFilterModuleDescriptor> filterDescriptors = new HashMap<String, ServletFilterModuleDescriptor>();
    private final ConcurrentMap<String, LazyReference<Filter>> filterRefs = new ConcurrentHashMap<String, LazyReference<Filter>>();
    private final ConcurrentMap<Plugin, ContextLifecycleReference> pluginContextRefs = new ConcurrentHashMap<Plugin, ContextLifecycleReference>();

    public DefaultServletModuleManager(ServletContext servletContext, PluginEventManager pluginEventManager) {
        this(pluginEventManager);
        ServletContextServletModuleManagerAccessor.setServletModuleManager(servletContext, this);
    }

    public DefaultServletModuleManager(PluginEventManager pluginEventManager) {
        this(pluginEventManager, new DefaultPathMapper(), new DefaultPathMapper());
    }

    public DefaultServletModuleManager(PluginEventManager pluginEventManager, PathMapper servletPathMapper, PathMapper filterPathMapper) {
        this.servletMapper = servletPathMapper;
        this.filterMapper = filterPathMapper;
        pluginEventManager.register((Object)this);
    }

    @Override
    public void addServletModule(ServletModuleDescriptor descriptor) {
        this.servletDescriptors.put(descriptor.getCompleteKey(), descriptor);
        List<String> paths = descriptor.getPaths();
        for (String path : paths) {
            this.servletMapper.put(descriptor.getCompleteKey(), path);
        }
        LazyReference servletRef = (LazyReference)this.servletRefs.remove(descriptor.getCompleteKey());
        if (servletRef != null) {
            ((HttpServlet)servletRef.get()).destroy();
        }
    }

    @Override
    public HttpServlet getServlet(String path, ServletConfig servletConfig) throws ServletException {
        String completeKey = this.servletMapper.get(path);
        if (completeKey == null) {
            return null;
        }
        ServletModuleDescriptor descriptor = this.servletDescriptors.get(completeKey);
        if (descriptor == null) {
            return null;
        }
        HttpServlet servlet = this.getServlet(descriptor, servletConfig);
        if (servlet == null) {
            this.servletRefs.remove(descriptor.getCompleteKey());
        }
        return servlet;
    }

    @Override
    public void removeServletModule(ServletModuleDescriptor descriptor) {
        this.servletDescriptors.remove(descriptor.getCompleteKey());
        this.servletMapper.put(descriptor.getCompleteKey(), null);
        LazyReference servletRef = (LazyReference)this.servletRefs.remove(descriptor.getCompleteKey());
        if (servletRef != null) {
            ((HttpServlet)servletRef.get()).destroy();
        }
    }

    @Override
    public void addFilterModule(ServletFilterModuleDescriptor descriptor) {
        this.filterDescriptors.put(descriptor.getCompleteKey(), descriptor);
        for (String path : descriptor.getPaths()) {
            this.filterMapper.put(descriptor.getCompleteKey(), path);
        }
        LazyReference filterRef = (LazyReference)this.filterRefs.remove(descriptor.getCompleteKey());
        if (filterRef != null) {
            ((Filter)filterRef.get()).destroy();
        }
    }

    @Override
    public Iterable<Filter> getFilters(FilterLocation location, String path, FilterConfig filterConfig) throws ServletException {
        return this.getFilters(location, path, filterConfig, FilterDispatcherCondition.REQUEST);
    }

    @Override
    public Iterable<Filter> getFilters(FilterLocation location, String path, FilterConfig filterConfig, FilterDispatcherCondition condition) throws ServletException {
        Validate.notNull((Object)((Object)condition));
        ArrayList matchingFilterDescriptors = new ArrayList();
        for (String completeKey : this.filterMapper.getAll(path)) {
            ServletFilterModuleDescriptor descriptor = this.filterDescriptors.get(completeKey);
            if (!descriptor.getDispatcherConditions().contains((Object)condition)) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Skipping filter " + descriptor.getCompleteKey() + " as condition " + (Object)((Object)condition) + " doesn't match list:" + Arrays.asList(descriptor.getDispatcherConditions()));
                continue;
            }
            if (!location.equals((Object)descriptor.getLocation())) continue;
            DefaultServletModuleManager.sortedInsert(matchingFilterDescriptors, descriptor, ServletFilterModuleDescriptor.byWeight);
        }
        LinkedList<Filter> filters = new LinkedList<Filter>();
        for (ServletFilterModuleDescriptor descriptor : matchingFilterDescriptors) {
            Filter filter = this.getFilter(descriptor, filterConfig);
            if (filter == null) {
                this.filterRefs.remove(descriptor.getCompleteKey());
                continue;
            }
            filters.add(this.getFilter(descriptor, filterConfig));
        }
        return filters;
    }

    static <T> void sortedInsert(List<T> list, T e, Comparator<T> comparator) {
        int insertIndex = Collections.binarySearch(list, e, comparator);
        if (insertIndex < 0) {
            insertIndex = -insertIndex - 1;
        } else {
            while (insertIndex < list.size() && comparator.compare(list.get(insertIndex), e) == 0) {
                ++insertIndex;
            }
        }
        list.add(insertIndex, e);
    }

    @Override
    public void removeFilterModule(ServletFilterModuleDescriptor descriptor) {
        this.filterDescriptors.remove(descriptor.getCompleteKey());
        this.filterMapper.put(descriptor.getCompleteKey(), null);
        LazyReference filterRef = (LazyReference)this.filterRefs.remove(descriptor.getCompleteKey());
        if (filterRef != null) {
            ((Filter)filterRef.get()).destroy();
        }
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        Plugin plugin = event.getPlugin();
        ContextLifecycleReference context = (ContextLifecycleReference)((Object)this.pluginContextRefs.remove(plugin));
        if (context == null) {
            return;
        }
        ((ContextLifecycleManager)context.get()).contextDestroyed();
    }

    HttpServlet getServlet(ServletModuleDescriptor descriptor, ServletConfig servletConfig) {
        LazyReference servletRef = (LazyReference)this.servletRefs.get(descriptor.getCompleteKey());
        if (servletRef == null) {
            ServletContext servletContext = this.getWrappedContext(descriptor.getPlugin(), servletConfig.getServletContext());
            servletRef = new LazyLoadedServletReference(descriptor, servletContext);
            if (this.servletRefs.putIfAbsent(descriptor.getCompleteKey(), (LazyReference<HttpServlet>)servletRef) != null) {
                servletRef = (LazyReference)this.servletRefs.get(descriptor.getCompleteKey());
            }
        }
        HttpServlet servlet = null;
        try {
            servlet = (HttpServlet)servletRef.get();
        }
        catch (RuntimeException ex) {
            log.error("Unable to create servlet", (Throwable)ex);
        }
        return servlet;
    }

    Filter getFilter(ServletFilterModuleDescriptor descriptor, FilterConfig filterConfig) {
        LazyReference filterRef = (LazyReference)this.filterRefs.get(descriptor.getCompleteKey());
        if (filterRef == null) {
            ServletContext servletContext = this.getWrappedContext(descriptor.getPlugin(), filterConfig.getServletContext());
            filterRef = new LazyLoadedFilterReference(descriptor, servletContext);
            if (this.filterRefs.putIfAbsent(descriptor.getCompleteKey(), (LazyReference<Filter>)filterRef) != null) {
                filterRef = (LazyReference)this.filterRefs.get(descriptor.getCompleteKey());
            }
        }
        try {
            return (Filter)filterRef.get();
        }
        catch (RuntimeException ex) {
            log.error("Unable to create filter", (Throwable)ex);
            return null;
        }
    }

    private ServletContext getWrappedContext(Plugin plugin, ServletContext baseContext) {
        ContextLifecycleReference pluginContextRef = (ContextLifecycleReference)((Object)this.pluginContextRefs.get(plugin));
        if (pluginContextRef == null && this.pluginContextRefs.putIfAbsent(plugin, pluginContextRef = new ContextLifecycleReference(plugin, baseContext)) != null) {
            pluginContextRef = (ContextLifecycleReference)((Object)this.pluginContextRefs.get(plugin));
        }
        return ((ContextLifecycleManager)pluginContextRef.get()).servletContext;
    }

    static <T extends ModuleDescriptor<?>> Iterable<T> findModuleDescriptorsByType(Class<T> type, Plugin plugin) {
        HashSet<T> descriptors = new HashSet<T>();
        for (ModuleDescriptor descriptor : plugin.getModuleDescriptors()) {
            if (!type.isAssignableFrom(descriptor.getClass())) continue;
            descriptors.add(type.cast(descriptor));
        }
        return descriptors;
    }

    static final class ContextLifecycleManager {
        private final ServletContext servletContext;
        private final Iterable<ServletContextListener> listeners;

        ContextLifecycleManager(ServletContext servletContext, Iterable<ServletContextListener> listeners) {
            this.servletContext = servletContext;
            this.listeners = listeners;
            for (ServletContextListener listener : listeners) {
                listener.contextInitialized(new ServletContextEvent(servletContext));
            }
        }

        ServletContext getServletContext() {
            return this.servletContext;
        }

        void contextDestroyed() {
            ServletContextEvent event = new ServletContextEvent(this.servletContext);
            for (ServletContextListener listener : this.listeners) {
                listener.contextDestroyed(event);
            }
        }
    }

    private static final class ContextLifecycleReference
    extends LazyReference<ContextLifecycleManager> {
        private final Plugin plugin;
        private final ServletContext baseContext;

        private ContextLifecycleReference(Plugin plugin, ServletContext baseContext) {
            this.plugin = plugin;
            this.baseContext = baseContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ContextLifecycleManager create() throws Exception {
            ConcurrentHashMap<String, Object> contextAttributes = new ConcurrentHashMap<String, Object>();
            Map<String, String> initParams = this.mergeInitParams(this.baseContext, this.plugin);
            PluginServletContextWrapper context = new PluginServletContextWrapper(this.plugin, this.baseContext, contextAttributes, initParams);
            ClassLoaderStack.push((ClassLoader)this.plugin.getClassLoader());
            ArrayList<ServletContextListener> listeners = new ArrayList<ServletContextListener>();
            try {
                for (ServletContextListenerModuleDescriptor descriptor : DefaultServletModuleManager.findModuleDescriptorsByType(ServletContextListenerModuleDescriptor.class, this.plugin)) {
                    listeners.add(descriptor.getModule());
                }
            }
            finally {
                ClassLoaderStack.pop();
            }
            return new ContextLifecycleManager(context, listeners);
        }

        private Map<String, String> mergeInitParams(ServletContext baseContext, Plugin plugin) {
            HashMap<String, String> mergedInitParams = new HashMap<String, String>();
            Enumeration e = baseContext.getInitParameterNames();
            while (e.hasMoreElements()) {
                String paramName = (String)e.nextElement();
                mergedInitParams.put(paramName, baseContext.getInitParameter(paramName));
            }
            for (ServletContextParamModuleDescriptor descriptor : DefaultServletModuleManager.findModuleDescriptorsByType(ServletContextParamModuleDescriptor.class, plugin)) {
                mergedInitParams.put(descriptor.getParamName(), descriptor.getParamValue());
            }
            return Collections.unmodifiableMap(mergedInitParams);
        }
    }

    private static final class LazyLoadedServletReference
    extends LazyReference<HttpServlet> {
        private final ServletModuleDescriptor descriptor;
        private final ServletContext servletContext;

        private LazyLoadedServletReference(ServletModuleDescriptor descriptor, ServletContext servletContext) {
            this.descriptor = descriptor;
            this.servletContext = servletContext;
        }

        protected HttpServlet create() throws Exception {
            DelegatingPluginServlet servlet = new DelegatingPluginServlet(this.descriptor);
            servlet.init(new PluginServletConfig(this.descriptor, this.servletContext));
            return servlet;
        }
    }

    private static final class LazyLoadedFilterReference
    extends LazyReference<Filter> {
        private final ServletFilterModuleDescriptor descriptor;
        private final ServletContext servletContext;

        private LazyLoadedFilterReference(ServletFilterModuleDescriptor descriptor, ServletContext servletContext) {
            this.descriptor = descriptor;
            this.servletContext = servletContext;
        }

        protected Filter create() throws Exception {
            DelegatingPluginFilter filter = new DelegatingPluginFilter(this.descriptor);
            filter.init(new PluginFilterConfig(this.descriptor, this.servletContext));
            return filter;
        }
    }
}

