/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl;

import com.atlassian.plugin.DefaultModuleDescriptorFactory;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.hostcontainer.SimpleConstructorHostContainer;
import com.atlassian.plugin.main.AtlassianPlugins;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.main.PluginsConfigurationBuilder;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.module.ClassPrefixModuleFactory;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.module.PrefixDelegatingModuleFactory;
import com.atlassian.plugin.module.PrefixModuleFactory;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.impl.DefaultPackageScannerConfiguration;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.osgi.module.BeanPrefixModuleFactory;
import com.atlassian.plugin.refimpl.ContainerManager;
import com.atlassian.plugin.refimpl.DefaultPluginPersistentStateStore;
import com.atlassian.plugin.refimpl.servlet.SimpleContentTypeResolver;
import com.atlassian.plugin.refimpl.servlet.SimpleServletContextFactory;
import com.atlassian.plugin.refimpl.webresource.SimpleWebResourceIntegration;
import com.atlassian.plugin.servlet.ContentTypeResolver;
import com.atlassian.plugin.servlet.DefaultServletModuleManager;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.plugin.servlet.PluginResourceDownload;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletContextListenerModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletContextParamModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.PluginResourceLocatorImpl;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceManagerImpl;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerManager {
    private static final String BUNDLED_PLUGINS_ZIP = "/atlassian-bundled-plugins.zip";
    private final ServletModuleManager servletModuleManager;
    private final SimpleWebResourceIntegration webResourceIntegration;
    private final WebResourceManager webResourceManager;
    private final OsgiContainerManager osgiContainerManager;
    private final PluginAccessor pluginAccessor;
    private final HostComponentProvider hostComponentProvider;
    private final DefaultModuleDescriptorFactory moduleDescriptorFactory;
    private final Map<Class<?>, Object> publicContainer;
    private final AtlassianPlugins plugins;
    private final HostContainer hostContainer;
    private static ContainerManager instance;
    private final List<DownloadStrategy> downloadStrategies;

    public ContainerManager(ServletContext servletContext) {
        instance = this;
        this.webResourceIntegration = new SimpleWebResourceIntegration(servletContext);
        1 delegatingHostContainer = new /* Unavailable Anonymous Inner Class!! */;
        this.moduleDescriptorFactory = new DefaultModuleDescriptorFactory((HostContainer)delegatingHostContainer);
        this.moduleDescriptorFactory.addModuleDescriptor("servlet", ServletModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("servlet-filter", ServletFilterModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("servlet-context-param", ServletContextParamModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("servlet-context-listener", ServletContextListenerModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("web-resource", WebResourceModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("web-resource-transformer", WebResourceTransformerModuleDescriptor.class);
        DefaultPackageScannerConfiguration scannerConfig = new DefaultPackageScannerConfiguration(this.determineVersion());
        scannerConfig.setServletContext(servletContext);
        ArrayList<String> packageIncludes = new ArrayList<String>(scannerConfig.getPackageIncludes());
        packageIncludes.add("org.bouncycastle*");
        packageIncludes.add("org.dom4j*");
        packageIncludes.add("javax.servlet*");
        packageIncludes.add("com.opensymphony.module.sitemesh*");
        scannerConfig.setPackageIncludes(packageIncludes);
        scannerConfig.setPackageVersions((Map)new /* Unavailable Anonymous Inner Class!! */);
        this.hostComponentProvider = new SimpleHostComponentProvider(this, null);
        File osgiCache = System.getProperty("osgi.cache") != null ? this.makeSureDirectoryExists(System.getProperty("osgi.cache")) : this.makeSureDirectoryExists(servletContext, "/WEB-INF/osgi-cache");
        PluginsConfiguration config = new PluginsConfigurationBuilder().useLegacyDynamicPluginDeployer(true).bundledPluginUrl(this.getClass().getResource(BUNDLED_PLUGINS_ZIP)).bundledPluginCacheDirectory(this.makeSureDirectoryExists(servletContext, "/WEB-INF/bundled-plugins")).pluginDirectory(this.makeSureDirectoryExists(servletContext, "/WEB-INF/plugins")).moduleDescriptorFactory((ModuleDescriptorFactory)this.moduleDescriptorFactory).packageScannerConfiguration((PackageScannerConfiguration)scannerConfig).hostComponentProvider(this.hostComponentProvider).osgiPersistentCache(osgiCache).pluginStateStore((PluginPersistentStateStore)new DefaultPluginPersistentStateStore(osgiCache)).applicationKey("refapp").build();
        PrefixDelegatingModuleFactory moduleFactory = new PrefixDelegatingModuleFactory((Set)ImmutableSet.of((Object)new BeanPrefixModuleFactory()));
        this.plugins = new AtlassianPlugins(config);
        PluginEventManager pluginEventManager = this.plugins.getPluginEventManager();
        this.osgiContainerManager = this.plugins.getOsgiContainerManager();
        this.servletModuleManager = new DefaultServletModuleManager(servletContext, pluginEventManager);
        this.pluginAccessor = this.plugins.getPluginAccessor();
        PluginResourceLocatorImpl pluginResourceLocator = new PluginResourceLocatorImpl((WebResourceIntegration)this.webResourceIntegration, (ServletContextFactory)new SimpleServletContextFactory(servletContext));
        PluginResourceDownload pluginDownloadStrategy = new PluginResourceDownload((PluginResourceLocator)pluginResourceLocator, (ContentTypeResolver)new SimpleContentTypeResolver(), "UTF-8");
        this.webResourceManager = new WebResourceManagerImpl((PluginResourceLocator)pluginResourceLocator, (WebResourceIntegration)this.webResourceIntegration, (ResourceBatchingConfiguration)new DefaultResourceBatchingConfiguration());
        this.publicContainer = new HashMap();
        this.publicContainer.put(PluginController.class, this.plugins.getPluginController());
        this.publicContainer.put(PluginAccessor.class, this.pluginAccessor);
        this.publicContainer.put(ServletModuleManager.class, this.servletModuleManager);
        this.publicContainer.put(WebResourceManager.class, this.webResourceManager);
        this.publicContainer.put(Map.class, this.publicContainer);
        this.publicContainer.put(ModuleFactory.class, moduleFactory);
        this.hostContainer = new SimpleConstructorHostContainer(this.publicContainer);
        moduleFactory.addPrefixModuleFactory((PrefixModuleFactory)new ClassPrefixModuleFactory(this.hostContainer));
        try {
            this.plugins.start();
        }
        catch (PluginParseException e) {
            throw new RuntimeException(e);
        }
        this.downloadStrategies = new ArrayList();
        this.downloadStrategies.add(pluginDownloadStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String determineVersion() {
        InputStream in;
        block4: {
            String string;
            in = null;
            Properties props = new Properties();
            try {
                in = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/com.atlassian.plugins/atlassian-plugins-core/pom.properties");
                if (in == null) break block4;
                props.load(in);
                string = props.getProperty("version");
            }
            catch (IOException e) {
                String string2;
                try {
                    e.printStackTrace();
                    string2 = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                return string2;
            }
            IOUtils.closeQuietly((InputStream)in);
            return string;
        }
        IOUtils.closeQuietly((InputStream)in);
        return null;
    }

    private File makeSureDirectoryExists(ServletContext servletContext, String relativePath) {
        return this.makeSureDirectoryExists(servletContext.getRealPath(relativePath));
    }

    private File makeSureDirectoryExists(String path) {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Could not create directory <" + dir + ">");
        }
        return dir;
    }

    public static synchronized void setInstance(ContainerManager mgr) {
        instance = mgr;
    }

    public static synchronized ContainerManager getInstance() {
        return instance;
    }

    public ServletModuleManager getServletModuleManager() {
        return this.servletModuleManager;
    }

    public OsgiContainerManager getOsgiContainerManager() {
        return this.osgiContainerManager;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public HostComponentProvider getHostComponentProvider() {
        return this.hostComponentProvider;
    }

    public ModuleDescriptorFactory getModuleDescriptorFactory() {
        return this.moduleDescriptorFactory;
    }

    public List<DownloadStrategy> getDownloadStrategies() {
        return this.downloadStrategies;
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    public WebResourceIntegration getWebResourceIntegration() {
        return this.webResourceIntegration;
    }

    void shutdown() {
        this.plugins.stop();
    }

    static /* synthetic */ HostContainer access$000(ContainerManager x0) {
        return x0.hostContainer;
    }

    static /* synthetic */ Map access$200(ContainerManager x0) {
        return x0.publicContainer;
    }
}

