/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.container.felix;

import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.felix.ExportBuilderUtils;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.PluginFrameworkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.pkgscanner.DefaultOsgiVersionConverter;
import org.twdata.pkgscanner.ExportPackage;
import org.twdata.pkgscanner.PackageScanner;

class ExportsBuilder {
    static final String JDK_6 = "1.6";
    static final String JDK_7 = "1.7";
    static final String OSGI_PACKAGES_PATH = "osgi-packages.txt";
    static final String JDK_PACKAGES_PATH = "jdk-packages.txt";
    private static Logger log = LoggerFactory.getLogger(ExportsBuilder.class);
    private static String exportStringCache;
    @VisibleForTesting
    static final Predicate<String> UNDER_PLUGIN_FRAMEWORK;
    private final CachedExportPackageLoader cachedExportPackageLoader;

    public static String getLegacyScanModeProperty() {
        return "com.atlassian.plugin.export.legacy.scan.mode";
    }

    public ExportsBuilder() {
        this(new PackageScannerExportsFileLoader("package-scanner-exports.xml"));
    }

    public ExportsBuilder(CachedExportPackageLoader loader) {
        this.cachedExportPackageLoader = loader;
    }

    public String getExports(List<HostComponentRegistration> regs, PackageScannerConfiguration packageScannerConfig) {
        if (exportStringCache == null) {
            exportStringCache = this.determineExports(regs, packageScannerConfig);
        }
        return exportStringCache;
    }

    public void clearExportCache() {
        exportStringCache = null;
    }

    public String determineExports(List<HostComponentRegistration> regs, PackageScannerConfiguration packageScannerConfig, File cacheDir) {
        return this.determineExports(regs, packageScannerConfig);
    }

    String determineExports(List<HostComponentRegistration> regs, PackageScannerConfiguration packageScannerConfig) {
        HashMap<String, String> exportPackages = new HashMap<String, String>();
        ExportBuilderUtils.copyUnlessExist(exportPackages, ExportBuilderUtils.parseExportFile(OSGI_PACKAGES_PATH));
        ExportBuilderUtils.copyUnlessExist(exportPackages, ExportBuilderUtils.parseExportFile(JDK_PACKAGES_PATH));
        Collection<ExportPackage> scannedPackages = this.generateExports(packageScannerConfig);
        ExportBuilderUtils.copyUnlessExist(exportPackages, ExportBuilderUtils.toMap(scannedPackages));
        try {
            Map<String, String> referredPackages = OsgiHeaderUtil.findReferredPackageVersions(regs, packageScannerConfig.getPackageVersions());
            ExportBuilderUtils.copyUnlessExist(exportPackages, referredPackages);
        }
        catch (IOException ex) {
            log.error("Unable to calculate necessary exports based on host components", (Throwable)ex);
        }
        this.enforceFrameworkVersion(exportPackages);
        String exports = OsgiHeaderUtil.generatePackageVersionString(exportPackages);
        if (log.isDebugEnabled()) {
            log.debug("Exports:\n" + exports.replaceAll(",", "\r\n"));
        }
        return exports;
    }

    private void enforceFrameworkVersion(Map<String, String> exportPackages) {
        String frameworkVersion = PluginFrameworkUtils.getPluginFrameworkVersion();
        DefaultOsgiVersionConverter converter = new DefaultOsgiVersionConverter();
        String frameworkVersionOsgi = converter.getVersion(frameworkVersion);
        for (String pkg : Sets.filter(exportPackages.keySet(), UNDER_PLUGIN_FRAMEWORK)) {
            exportPackages.put(pkg, frameworkVersionOsgi);
        }
    }

    Collection<ExportPackage> generateExports(PackageScannerConfiguration packageScannerConfig) {
        Collection exports;
        String[] arrType = new String[]{};
        HashMap<String, String> pkgVersions = new HashMap<String, String>(packageScannerConfig.getPackageVersions());
        String javaxServletPattern = "javax.servlet*";
        ServletContext servletContext = packageScannerConfig.getServletContext();
        if (null == pkgVersions.get("javax.servlet*") && null != servletContext) {
            String servletVersion = servletContext.getMajorVersion() + "." + servletContext.getMinorVersion();
            pkgVersions.put("javax.servlet*", servletVersion);
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        PackageScanner scanner = new PackageScanner().useClassLoader(contextClassLoader).select(PackageScanner.jars((String[])PackageScanner.include((String[])packageScannerConfig.getJarIncludes().toArray(arrType)), (String[])PackageScanner.exclude((String[])packageScannerConfig.getJarExcludes().toArray(arrType))), PackageScanner.packages((String[])PackageScanner.include((String[])packageScannerConfig.getPackageIncludes().toArray(arrType)), (String[])PackageScanner.exclude((String[])packageScannerConfig.getPackageExcludes().toArray(arrType)))).withMappings(pkgVersions);
        if (log.isDebugEnabled()) {
            scanner.enableDebug();
        }
        if ((exports = this.cachedExportPackageLoader.load()) == null) {
            boolean legacyMode = Boolean.getBoolean(ExportsBuilder.getLegacyScanModeProperty());
            if (legacyMode) {
                exports = scanner.scan();
            } else {
                List<URLClassLoader> urlClassLoaders = ExportsBuilder.getUrlClassLoaders(contextClassLoader);
                URL[] urls = this.getUrlClassPath(urlClassLoaders);
                exports = scanner.scan(urls);
            }
        }
        log.info("Package scan completed. Found " + exports.size() + " packages to export.");
        if (!ExportsBuilder.isPackageScanSuccessful(exports) && servletContext != null) {
            log.warn("Unable to find expected packages via classloader scanning.  Trying ServletContext scanning...");
            try {
                exports = scanner.scan(new URL[]{servletContext.getResource("/WEB-INF/lib"), servletContext.getResource("/WEB-INF/classes")});
            }
            catch (MalformedURLException e) {
                log.warn("Unable to scan webapp for packages", (Throwable)e);
            }
        }
        if (!ExportsBuilder.isPackageScanSuccessful(exports)) {
            throw new IllegalStateException("Unable to find required packages via classloader or servlet context scanning, most likely due to an application server bug.");
        }
        return exports;
    }

    private static List<URLClassLoader> getUrlClassLoaders(ClassLoader leafClassLoader) {
        ImmutableList.Builder urlClassLoaders = ImmutableList.builder();
        for (ClassLoader classLoader = leafClassLoader; classLoader != null; classLoader = classLoader.getParent()) {
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                urlClassLoaders.add((Object)urlClassLoader);
                continue;
            }
            log.warn("ignoring non-URLClassLoader {}", classLoader.getClass());
        }
        return urlClassLoaders.build().reverse();
    }

    private URL[] getUrlClassPath(List<URLClassLoader> urlClassLoaders) {
        ArrayList<URL> allUrls = new ArrayList<URL>();
        for (URLClassLoader urlClassLoader : urlClassLoaders) {
            ArrayDeque<URL> loaderUrls = new ArrayDeque<URL>((Collection<URL>)ImmutableList.copyOf((Object[])urlClassLoader.getURLs()));
            while (!loaderUrls.isEmpty()) {
                URL url = (URL)loaderUrls.pop();
                try {
                    File file = FileUtils.toFile((URL)url);
                    if (null == file) {
                        log.warn("Cannot deep scan non file '{}'", (Object)url);
                        continue;
                    }
                    if (!file.exists()) {
                        log.debug("Cannot deep scan missing file '{}'", (Object)url);
                        continue;
                    }
                    if (file.isDirectory()) {
                        allUrls.add(url);
                        continue;
                    }
                    if (file.isFile() && file.getName().endsWith(".jar")) {
                        allUrls.add(url);
                        JarFile jar = new JarFile(file);
                        this.collectClassPath(loaderUrls, url, jar);
                        continue;
                    }
                    log.debug("Skipping deep scan of non jar-file ");
                }
                catch (Exception exception) {
                    log.warn("Failed to deep scan '{}'", (Object)url, (Object)exception);
                }
            }
        }
        return allUrls.toArray(new URL[allUrls.size()]);
    }

    private void collectClassPath(Deque<URL> loaderUrls, URL url, JarFile jar) throws IOException {
        Manifest manifest = jar.getManifest();
        if (null == manifest) {
            log.debug("Missing manifest prevents deep scan of '{}'", (Object)url);
            return;
        }
        String classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (null != classPath) {
            StringTokenizer tokenizer = new StringTokenizer(classPath);
            while (tokenizer.hasMoreTokens()) {
                String classPathEntry = tokenizer.nextToken();
                try {
                    loaderUrls.push(new URL(url, classPathEntry));
                    log.debug("Deep scan found url '{}'", (Object)loaderUrls.peekFirst());
                }
                catch (MalformedURLException emu) {
                    log.warn("Cannot deep scan unparseable Class-Path entry '{}' in '{}'", (Object)url, (Object)classPath);
                }
            }
        }
    }

    private static boolean isPackageScanSuccessful(Collection<ExportPackage> exports) {
        boolean slf4jFound = false;
        for (ExportPackage export : exports) {
            if (!export.getPackageName().equals("org.slf4j")) continue;
            slf4jFound = true;
            break;
        }
        return slf4jFound;
    }

    static {
        UNDER_PLUGIN_FRAMEWORK = new Predicate<String>(){
            private Iterable<String> packagesNotInPlugins = Lists.newArrayList((Object[])new String[]{"com.atlassian.plugin.remotable", "com.atlassian.plugin.cache.filecache", "com.atlassian.plugin.webresource", "com.atlassian.plugin.web"});

            public boolean apply(final String pkg) {
                Predicate<String> underPackage = new Predicate<String>(){

                    public boolean apply(@Nullable String input) {
                        return pkg.equals(input) || pkg.startsWith(input + ".");
                    }
                };
                return pkg.startsWith("com.atlassian.plugin.") && !Iterables.any(this.packagesNotInPlugins, (Predicate)underPackage);
            }
        };
    }

    static class PackageScannerExportsFileLoader
    implements CachedExportPackageLoader {
        private final String path;

        public PackageScannerExportsFileLoader(String path) {
            this.path = path;
        }

        @Override
        public Collection<ExportPackage> load() {
            URL exportsUrl = this.getClass().getClassLoader().getResource(this.path);
            if (exportsUrl != null) {
                log.debug("Precalculated exports found, loading...");
                ArrayList result = Lists.newArrayList();
                try {
                    Document doc = new SAXReader().read(exportsUrl);
                    for (Element export : doc.getRootElement().elements()) {
                        String packageName = export.attributeValue("package");
                        String version = export.attributeValue("version");
                        String location = export.attributeValue("location");
                        if (packageName == null || location == null) {
                            log.warn("Invalid configuration: package({}) and location({}) are required, aborting precalculated exports and reverting to normal scanning", (Object)packageName, (Object)location);
                            return Collections.emptyList();
                        }
                        result.add(new ExportPackage(packageName, version, new File(location)));
                    }
                    log.debug("Loaded {} precalculated exports", (Object)result.size());
                    return result;
                }
                catch (DocumentException e) {
                    log.warn("Unable to load exports from " + this.path + " due to malformed XML", (Throwable)e);
                }
            }
            log.debug("No precalculated exports found");
            return null;
        }
    }

    public static interface CachedExportPackageLoader {
        public Collection<ExportPackage> load();
    }
}

