/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.module.ContainerAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiPluginHelper;
import com.atlassian.plugin.osgi.factory.transform.JarUtils;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OsgiPluginUninstalledHelper
implements OsgiPluginHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String key;
    private final OsgiContainerManager osgiContainerManager;
    private final PluginArtifact pluginArtifact;

    public OsgiPluginUninstalledHelper(String key, OsgiContainerManager mgr, PluginArtifact artifact) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.pluginArtifact = (PluginArtifact)Preconditions.checkNotNull((Object)artifact);
        this.osgiContainerManager = (OsgiContainerManager)Preconditions.checkNotNull((Object)mgr);
    }

    @Override
    public Bundle getBundle() {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage() + " This is probably because the module " + "descriptor is trying to load classes in its init() method.  Move all classloading into the " + "enabled() method, and be sure to properly drop class and instance references in disabled().");
    }

    @Override
    public URL getResource(String name) {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public ClassLoader getClassLoader() {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public Bundle install() {
        File osgiPlugin = this.pluginArtifact.toFile();
        boolean allowReference = PluginArtifact.AllowsReference.Default.allowsReference((PluginArtifact)this.pluginArtifact);
        this.logger.debug("Installing OSGi plugin '{}'", (Object)osgiPlugin);
        Bundle bundle = OsgiContainerManager.AllowsReferenceInstall.Default.installBundle(this.osgiContainerManager, osgiPlugin, allowReference);
        if (!OsgiHeaderUtil.getPluginKey(bundle).equals(this.key)) {
            throw new IllegalArgumentException("The plugin key '" + this.key + "' must either match the OSGi bundle symbolic " + "name (Bundle-SymbolicName) or be specified in the Atlassian-Plugin-Key manifest header");
        }
        return bundle;
    }

    @Override
    public void onEnable(ServiceTracker ... serviceTrackers) throws OsgiContainerException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public void onDisable() throws OsgiContainerException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public void onUninstall() throws OsgiContainerException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public Set<String> getRequiredPlugins() {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public void setPluginContainer(Object container) {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public ContainerAccessor getContainerAccessor() {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public ContainerAccessor getRequiredContainerAccessor() {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    private String getNotInstalledMessage() {
        return "This operation requires the plugin '" + this.key + "' to be installed";
    }

    @Override
    public boolean isRemotePlugin() {
        return JarUtils.hasManifestEntry(JarUtils.getManifest(this.pluginArtifact.toFile()), "Remote-Plugin");
    }
}

