/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiBundlePlugin;
import com.atlassian.plugin.osgi.factory.OsgiPluginXmlDescriptorParserFactory;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.parsers.DescriptorParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiBundleFactory
implements PluginFactory {
    private static final Logger log = LoggerFactory.getLogger(OsgiBundleFactory.class);
    private final OsgiContainerManager osgi;
    private final PluginEventManager pluginEventManager;
    private final OsgiPluginXmlDescriptorParserFactory descriptorParserFactory;
    private final String pluginDescriptorFileName;

    public OsgiBundleFactory(OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        this("atlassian-plugin.xml", osgi, pluginEventManager);
    }

    public OsgiBundleFactory(String pluginDescriptorFileName, OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        this.pluginDescriptorFileName = pluginDescriptorFileName;
        Validate.notNull((Object)osgi, (String)"The osgi container is required");
        Validate.notNull((Object)pluginEventManager, (String)"The plugin event manager is required");
        this.osgi = osgi;
        this.pluginEventManager = pluginEventManager;
        this.descriptorParserFactory = new OsgiPluginXmlDescriptorParserFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact is required");
        String pluginKey = null;
        InputStream manifestStream = null;
        InputStream descriptorStream = null;
        try {
            manifestStream = pluginArtifact.getResourceAsStream("META-INF/MANIFEST.MF");
            if (manifestStream != null) {
                Manifest mf;
                try {
                    mf = new Manifest(manifestStream);
                }
                catch (IOException e) {
                    throw new PluginParseException("Unable to parse manifest", (Throwable)e);
                }
                String symName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
                if (symName != null) {
                    DescriptorParser descriptorParser;
                    pluginKey = OsgiHeaderUtil.getPluginKey(mf);
                    descriptorStream = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
                    if (descriptorStream != null && (descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream, new String[0])).getPluginsVersion() == 1) {
                        pluginKey = null;
                    }
                }
            }
            String string = pluginKey;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)manifestStream);
            IOUtils.closeQuietly(descriptorStream);
        }
    }

    public Plugin create(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Validate.notNull((Object)deploymentUnit, (String)"The deployment unit is required");
        return this.create((PluginArtifact)new JarPluginArtifact(deploymentUnit.getPath()), moduleDescriptorFactory);
    }

    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Bundle bundle;
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact is required");
        Validate.notNull((Object)moduleDescriptorFactory, (String)"The module descriptor factory is required");
        File file = pluginArtifact.toFile();
        try {
            bundle = this.osgi.installBundle(file);
        }
        catch (OsgiContainerException ex) {
            return this.reportUnloadablePlugin(file, (Exception)((Object)ex));
        }
        String key = OsgiHeaderUtil.getPluginKey(bundle);
        return new OsgiBundlePlugin(bundle, key, this.pluginEventManager);
    }

    private Plugin reportUnloadablePlugin(File file, Exception e) {
        log.error("Unable to load plugin: " + file, (Throwable)e);
        UnloadablePlugin plugin = new UnloadablePlugin();
        plugin.setErrorText("Unable to load plugin: " + e.getMessage());
        return plugin;
    }
}

