/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.container.felix;

import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.felix.ExportBuilderUtils;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.PluginFrameworkUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.pkgscanner.DefaultOsgiVersionConverter;
import org.twdata.pkgscanner.ExportPackage;
import org.twdata.pkgscanner.PackageScanner;

class ExportsBuilder {
    static final String JDK_6 = "1.6";
    static final String JDK_7 = "1.7";
    static final String OSGI_PACKAGES_PATH = "osgi-packages.txt";
    static final String JDK_PACKAGES_PATH = "jdk-packages.txt";
    private static Logger log = LoggerFactory.getLogger(ExportsBuilder.class);
    private static String exportStringCache;
    private static final Predicate<String> UNDER_PLUGIN_FRAMEWORK;

    ExportsBuilder() {
    }

    public String getExports(List<HostComponentRegistration> regs, PackageScannerConfiguration packageScannerConfig) {
        if (exportStringCache == null) {
            exportStringCache = this.determineExports(regs, packageScannerConfig);
        }
        return exportStringCache;
    }

    public void clearExportCache() {
        exportStringCache = null;
    }

    public String determineExports(List<HostComponentRegistration> regs, PackageScannerConfiguration packageScannerConfig, File cacheDir) {
        return this.determineExports(regs, packageScannerConfig);
    }

    String determineExports(List<HostComponentRegistration> regs, PackageScannerConfiguration packageScannerConfig) {
        HashMap<String, String> exportPackages = new HashMap<String, String>();
        ExportBuilderUtils.copyUnlessExist(exportPackages, ExportBuilderUtils.parseExportFile(OSGI_PACKAGES_PATH));
        ExportBuilderUtils.copyUnlessExist(exportPackages, ExportBuilderUtils.parseExportFile(JDK_PACKAGES_PATH));
        Collection<ExportPackage> scannedPackages = this.generateExports(packageScannerConfig);
        ExportBuilderUtils.copyUnlessExist(exportPackages, ExportBuilderUtils.toMap(scannedPackages));
        try {
            Map<String, String> referredPackages = OsgiHeaderUtil.findReferredPackageVersions(regs, packageScannerConfig.getPackageVersions());
            ExportBuilderUtils.copyUnlessExist(exportPackages, referredPackages);
        }
        catch (IOException ex) {
            log.error("Unable to calculate necessary exports based on host components", (Throwable)ex);
        }
        this.enforceFrameworkVersion(exportPackages);
        String exports = OsgiHeaderUtil.generatePackageVersionString(exportPackages);
        if (log.isDebugEnabled()) {
            log.debug("Exports:\n" + exports.replaceAll(",", "\r\n"));
        }
        return exports;
    }

    private void enforceFrameworkVersion(Map<String, String> exportPackages) {
        String frameworkVersion = PluginFrameworkUtils.getPluginFrameworkVersion();
        DefaultOsgiVersionConverter converter = new DefaultOsgiVersionConverter();
        String frameworkVersionOsgi = converter.getVersion(frameworkVersion);
        for (String pkg : Sets.filter(exportPackages.keySet(), UNDER_PLUGIN_FRAMEWORK)) {
            exportPackages.put(pkg, frameworkVersionOsgi);
        }
    }

    Collection<ExportPackage> generateExports(PackageScannerConfiguration packageScannerConfig) {
        String[] arrType = new String[]{};
        HashMap<String, String> pkgVersions = new HashMap<String, String>(packageScannerConfig.getPackageVersions());
        if (packageScannerConfig.getServletContext() != null) {
            String ver = packageScannerConfig.getServletContext().getMajorVersion() + "." + packageScannerConfig.getServletContext().getMinorVersion();
            pkgVersions.put("javax.servlet*", ver);
        }
        PackageScanner scanner = new PackageScanner().select(PackageScanner.jars((String[])PackageScanner.include((String[])packageScannerConfig.getJarIncludes().toArray(arrType)), (String[])PackageScanner.exclude((String[])packageScannerConfig.getJarExcludes().toArray(arrType))), PackageScanner.packages((String[])PackageScanner.include((String[])packageScannerConfig.getPackageIncludes().toArray(arrType)), (String[])PackageScanner.exclude((String[])packageScannerConfig.getPackageExcludes().toArray(arrType)))).withMappings(pkgVersions);
        if (log.isDebugEnabled()) {
            scanner.enableDebug();
        }
        Collection exports = scanner.scan();
        log.info("Package scan completed. Found " + exports.size() + " packages to export.");
        if (!ExportsBuilder.isPackageScanSuccessful(exports) && packageScannerConfig.getServletContext() != null) {
            log.warn("Unable to find expected packages via classloader scanning.  Trying ServletContext scanning...");
            ServletContext ctx = packageScannerConfig.getServletContext();
            try {
                exports = scanner.scan(new URL[]{ctx.getResource("/WEB-INF/lib"), ctx.getResource("/WEB-INF/classes")});
            }
            catch (MalformedURLException e) {
                log.warn("Unable to scan webapp for packages", (Throwable)e);
            }
        }
        if (!ExportsBuilder.isPackageScanSuccessful(exports)) {
            throw new IllegalStateException("Unable to find required packages via classloader or servlet context scanning, most likely due to an application server bug.");
        }
        return exports;
    }

    private static boolean isPackageScanSuccessful(Collection<ExportPackage> exports) {
        boolean slf4jFound = false;
        for (ExportPackage export : exports) {
            if (!export.getPackageName().equals("org.slf4j")) continue;
            slf4jFound = true;
            break;
        }
        return slf4jFound;
    }

    static {
        UNDER_PLUGIN_FRAMEWORK = new Predicate<String>(){

            public boolean apply(String pkg) {
                return pkg.startsWith("com.atlassian.plugin.");
            }
        };
    }
}

