/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class JunitOSGiRunListener
extends RunListener {
    private final RunNotifier notifier;
    private Set<String> passedMethodNames;
    private Set<String> failedMethodNames;
    private Set<String> ignoredMethodNames;

    public JunitOSGiRunListener(RunNotifier notifier) {
        this.notifier = notifier;
        this.passedMethodNames = new HashSet<String>();
        this.failedMethodNames = new HashSet<String>();
        this.ignoredMethodNames = new HashSet<String>();
    }

    public void testFailure(Failure failure) throws Exception {
        this.failedMethodNames.add(failure.getDescription().getMethodName());
    }

    public void testFinished(Description description) throws Exception {
        String methodName = description.getMethodName();
        if (!this.failedMethodNames.contains(methodName) && !this.ignoredMethodNames.contains(methodName)) {
            this.passedMethodNames.add(methodName);
        }
    }

    public void testIgnored(Description description) throws Exception {
        this.ignoredMethodNames.add(description.getMethodName());
    }

    public void testAssumptionFailure(Failure failure) {
        this.notifier.fireTestIgnored(failure.getDescription());
    }

    public Set<String> getPassedMethodNames() {
        return ImmutableSet.copyOf(this.passedMethodNames);
    }

    public Set<String> getFailedMethodNames() {
        return ImmutableSet.copyOf(this.failedMethodNames);
    }

    public Set<String> getIgnoredMethodNames() {
        return ImmutableSet.copyOf(this.ignoredMethodNames);
    }
}

