/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.annotation.Nullable;

public class JavassistHelper {
    private static final Joiner ARRAY_MEMBER_VALUE_JOINER = Joiner.on((String)",");

    public List<String> getClassAnnotationNames(ClassFile aClass) {
        return this.getAnnotationNames((AnnotationsAttribute)aClass.getAttribute("RuntimeVisibleAnnotations"));
    }

    private List<String> getAnnotationNames(AnnotationsAttribute ... annotationsAttributes) {
        ArrayList result = Lists.newArrayList();
        if (annotationsAttributes != null) {
            for (AnnotationsAttribute annotationsAttribute : annotationsAttributes) {
                if (annotationsAttribute == null) continue;
                for (Annotation annotation : annotationsAttribute.getAnnotations()) {
                    result.add(annotation.getTypeName());
                }
            }
        }
        return result;
    }

    Set<String> getAnnotationMemberSet(ClassFile classFile, String annotationType, String memberName) {
        MemberValue value = this.getMemberValue(classFile, annotationType, memberName);
        if (value != null && value instanceof ArrayMemberValue) {
            MemberValue[] arrayMemberValueValues;
            HashSet<String> values = new HashSet<String>();
            ArrayMemberValue arrayMemberValue = (ArrayMemberValue)value;
            for (MemberValue memberValue : arrayMemberValueValues = arrayMemberValue.getValue()) {
                if (memberValue == null) continue;
                values.add(this.removeQuotes(memberValue.toString()));
            }
            return values;
        }
        return Collections.emptySet();
    }

    private MemberValue getMemberValue(ClassFile classFile, String annotationType, String memberName) {
        AnnotationsAttribute annotations = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        Annotation annotation = annotations.getAnnotation(annotationType);
        return annotation == null ? null : annotation.getMemberValue(memberName);
    }

    private String removeQuotes(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    String getAnnotationMember(ClassFile classFile, String annotationType, String memberName) {
        MemberValue value = this.getMemberValue(classFile, annotationType, memberName);
        return this.dataForMemberValue(value);
    }

    String getAnnotationMember(Annotation annotation, String memberName) {
        MemberValue value = annotation == null ? null : annotation.getMemberValue(memberName);
        return this.dataForMemberValue(value);
    }

    private String dataForMemberValue(MemberValue memberValue) {
        if (memberValue instanceof StringMemberValue) {
            return ((StringMemberValue)memberValue).getValue();
        }
        if (memberValue instanceof ClassMemberValue) {
            return ((ClassMemberValue)memberValue).getValue();
        }
        if (memberValue instanceof ArrayMemberValue) {
            Object[] entryValues = ((ArrayMemberValue)memberValue).getValue();
            Iterable entryData = Iterables.transform((Iterable)ImmutableList.copyOf((Object[])entryValues), (Function)new Function<MemberValue, String>(){

                public String apply(@Nullable MemberValue entryValue) {
                    return JavassistHelper.this.dataForMemberValue(entryValue);
                }
            });
            return ARRAY_MEMBER_VALUE_JOINER.join(entryData);
        }
        return memberValue == null ? null : this.removeQuotes(memberValue.toString());
    }

    List<Annotation> getParameterAnnotations(MethodInfo method, int parameterIndex) {
        Annotation[] annotations;
        Annotation[][] allAnnotations;
        ArrayList result = Lists.newArrayList();
        ParameterAnnotationsAttribute parameterAnnotationsAttribute = (ParameterAnnotationsAttribute)method.getAttribute("RuntimeVisibleParameterAnnotations");
        if (parameterAnnotationsAttribute != null && parameterIndex < (allAnnotations = parameterAnnotationsAttribute.getAnnotations()).length && (annotations = allAnnotations[parameterIndex]) != null) {
            Collections.addAll(result, annotations);
        }
        return result;
    }
}

