/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.maven;

import com.atlassian.plugin.spring.scanner.core.AtlassianSpringByteCodeScanner;
import com.atlassian.plugin.spring.scanner.core.ByteCodeScannerConfiguration;
import com.atlassian.plugin.spring.scanner.maven.MavenLogAdapter;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.Utils;
import org.slf4j.Logger;

@Mojo(name="atlassian-spring-scanner", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class AtlassianSpringScannerMojo
extends AbstractMojo {
    public static final String OUR_NAME = "Atlassian Spring Byte Code Scanner";
    private static final String DEFAULT_INCLUDE_EXCLUDE = "-java\\..*, -javax\\..*, -sun\\..*, -com\\.sun\\..*";
    @Component
    private MavenProject project;
    @Parameter(defaultValue="-java\\..*, -javax\\..*, -sun\\..*, -com\\.sun\\..*")
    private String includeExclude;
    @Parameter(defaultValue="false")
    private Boolean parallel;
    @Parameter(defaultValue="false")
    private Boolean verbose;
    @Parameter
    private List<Dependency> scannedDependencies = new ArrayList<Dependency>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Starting Atlassian Spring Byte Code Scanner...");
        this.getLog().info((CharSequence)"");
        long then = System.currentTimeMillis();
        String outputDirectory = this.resolveOutputDirectory();
        if (!new File(outputDirectory).exists()) {
            this.getLog().warn((CharSequence)String.format("Skipping because %s was not found", outputDirectory));
            return;
        }
        ByteCodeScannerConfiguration.Builder config = ByteCodeScannerConfiguration.builder().setOutputDirectory(outputDirectory).setClassPathUrls(this.parseUrls()).setIncludeExclude(this.includeExclude).setLog(this.makeLogger()).setVerbose(this.verbose);
        AtlassianSpringByteCodeScanner scanner = new AtlassianSpringByteCodeScanner(config.build());
        long ms = System.currentTimeMillis() - then;
        this.getLog().info((CharSequence)String.format("", new Object[0]));
        this.getLog().info((CharSequence)String.format("\tAnalysis ran in %d ms.", ms));
        this.getLog().info((CharSequence)String.format("\tEncountered %d total classes", scanner.getStats().getClassesEncountered()));
        this.getLog().info((CharSequence)String.format("\tProcessed %d annotated classes", scanner.getStats().getComponentClassesEncountered()));
    }

    private Logger makeLogger() {
        return new MavenLogAdapter(this.getLog());
    }

    private Set<URL> parseUrls() throws MojoExecutionException {
        HashSet urls = Sets.newHashSet();
        urls.add(this.parseOutputDirUrl());
        if (!Utils.isEmpty((String)this.includeExclude)) {
            for (String string : this.includeExclude.split(",")) {
                String trimmed = string.trim();
                char prefix = trimmed.charAt(0);
                String pattern = trimmed.substring(1);
                if (prefix != '+') continue;
                this.logVerbose(String.format("\tAdding include / exclude %s", Character.valueOf(prefix)));
                urls.addAll(ClasspathHelper.forPackage((String)pattern, (ClassLoader[])new ClassLoader[0]));
            }
        }
        LinkedHashSet dependencyJars = Sets.newLinkedHashSet();
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            if (this.isInScannedDeps(artifact)) {
                this.logVerbose(String.format("\t(/) Including dependency for scanning %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getScope()));
                File file = artifact.getFile();
                try {
                    URL url = file.toURI().toURL();
                    dependencyJars.add(url);
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)String.format("Enable to create URL from plugin artifact : %s", file), (Throwable)e);
                }
                continue;
            }
            this.logVerbose(String.format("\t\t(X) Ignoring dependency for scanning %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getScope()));
        }
        urls.addAll(dependencyJars);
        if (dependencyJars.size() > 0) {
            this.getLog().info((CharSequence)String.format("\t(/) The following dependencies will also be scanned for annotations : ", new Object[0]));
            this.getLog().info((CharSequence)String.format("", new Object[0]));
            for (URL jar : dependencyJars) {
                this.getLog().info((CharSequence)String.format("\t\t%s", jar));
            }
        }
        return urls;
    }

    private void logVerbose(String message) {
        if (this.verbose.booleanValue()) {
            this.getLog().info((CharSequence)message);
        }
    }

    private boolean isInScannedDeps(final Artifact artifact) {
        if (!this.isSensibleScope(artifact)) {
            return false;
        }
        Predicate<Dependency> matchesGA = new Predicate<Dependency>(){

            public boolean apply(Dependency input) {
                return artifact.getGroupId().equals(input.getGroupId()) && artifact.getArtifactId().equals(input.getArtifactId());
            }
        };
        return Iterables.any(this.scannedDependencies, (Predicate)matchesGA);
    }

    private boolean isSensibleScope(Artifact artifact) {
        return !"test".equals(artifact.getScope());
    }

    private URL parseOutputDirUrl() throws MojoExecutionException {
        try {
            File outputDirectoryFile = new File(this.resolveOutputDirectory() + '/');
            return outputDirectoryFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private String resolveOutputDirectory() {
        return this.getProject().getBuild().getOutputDirectory();
    }

    public MavenProject getProject() {
        return this.project;
    }
}

