/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionTracker;
import org.ofbiz.core.entity.transaction.TransactionIsolations;
import org.ofbiz.core.entity.util.PropertyUtils;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCPConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(DBCPConnectionFactory.class);
    protected static final Map<String, BasicDataSource> dsCache = CopyOnWriteMap.newHashMap();
    protected static final Map<String, ConnectionTracker> trackerCache = CopyOnWriteMap.newHashMap();
    private static final String PROP_JMX = "jmx";
    private static final String DBCP_PROPERTIES = "dbcp.properties";
    private static final String PROP_MBEANNAME = "mbeanName";
    public static final String VALIDATION_QUERY = "select 1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String helperName, JdbcDatasourceInfo jdbcDatasource) throws SQLException, GenericEntityException {
        block8: {
            BasicDataSource dataSource = dsCache.get(helperName);
            if (dataSource != null) {
                return DBCPConnectionFactory.trackConnection(helperName, (DataSource)dataSource);
            }
            try {
                Class<DBCPConnectionFactory> clazz = DBCPConnectionFactory.class;
                synchronized (DBCPConnectionFactory.class) {
                    dataSource = dsCache.get(helperName);
                    if (dataSource != null) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return DBCPConnectionFactory.trackConnection(helperName, (DataSource)dataSource);
                    }
                    Properties info = jdbcDatasource.getConnectionProperties() != null ? PropertyUtils.copyOf(jdbcDatasource.getConnectionProperties()) : new Properties();
                    dataSource = DBCPConnectionFactory.createDataSource(jdbcDatasource);
                    dataSource.setConnectionProperties(DBCPConnectionFactory.toString(info));
                    ConnectionPoolInfo poolInfo = jdbcDatasource.getConnectionPoolInfo();
                    DBCPConnectionFactory.initConnectionPoolSettings(dataSource, poolInfo);
                    dataSource.setLogWriter(Debug.getPrintWriter());
                    dsCache.put(helperName, dataSource);
                    trackerCache.put(helperName, new ConnectionTracker(poolInfo));
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return DBCPConnectionFactory.trackConnection(helperName, (DataSource)dataSource);
                }
            }
            catch (Exception e) {
                Debug.logError((Throwable)e, (String)("Error getting datasource via DBCP: " + jdbcDatasource));
            }
            catch (AbstractMethodError err) {
                if (!DBCPConnectionFactory.checkIfProblemMayBeCausedByIsValidMethod(dataSource, err)) break block8;
                DBCPConnectionFactory.unregisterDatasourceFromJmx(dataSource);
                log.warn("*********************************************** IMPORTANT  ***********************************************");
                log.warn("                                                                                                          ");
                log.warn("  We found that you may experience problems with database connectivity because your database driver       ");
                log.warn("  is not fully JDBC 4 compatible. As a workaround of this problem a validation query was added to your    ");
                log.warn("  runtime configuration. Please add a line with validation query:                                       \n");
                log.warn("                          <validation-query>select 1</validation-query>                                 \n");
                log.warn("  to your JIRA_HOME/dbconfig.xml or update your database driver to version which fully supports JDBC 4.   ");
                log.warn("  More information about this problem can be found here: https://jira.atlassian.com/browse/JRA-59768      ");
                log.warn("                                                                                                          ");
                log.warn("**********************************************************************************************************");
                return DBCPConnectionFactory.getConnection(helperName, DBCPConnectionFactory.getUpdatedJdbcDatasource(jdbcDatasource));
            }
        }
        return null;
    }

    private static void unregisterDatasourceFromJmx(BasicDataSource dataSource) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(ObjectName.getInstance(dataSource.getJmxName()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static JdbcDatasourceInfo getUpdatedJdbcDatasource(JdbcDatasourceInfo jdbcDatasource) {
        ConnectionPoolInfo cpi = jdbcDatasource.getConnectionPoolInfo();
        ConnectionPoolInfo newConnectionPoolInfo = new ConnectionPoolInfo(cpi.getMaxSize(), cpi.getMinSize(), cpi.getMaxWait(), cpi.getSleepTime(), cpi.getLifeTime(), cpi.getDeadLockMaxWait(), cpi.getDeadLockRetryWait(), VALIDATION_QUERY, cpi.getMinEvictableTimeMillis(), cpi.getTimeBetweenEvictionRunsMillis());
        return new JdbcDatasourceInfo(jdbcDatasource.getUri(), jdbcDatasource.getDriverClassName(), jdbcDatasource.getUsername(), jdbcDatasource.getPassword(), jdbcDatasource.getIsolationLevel(), jdbcDatasource.getConnectionProperties(), newConnectionPoolInfo);
    }

    @VisibleForTesting
    static boolean checkIfProblemMayBeCausedByIsValidMethod(BasicDataSource dataSource, AbstractMethodError error) {
        String validationQuery = dataSource.getValidationQuery();
        if (validationQuery == null || validationQuery.isEmpty()) {
            ArrayList stackTraceElements = Lists.newArrayList((Object[])error.getStackTrace());
            return stackTraceElements.stream().anyMatch(stackTraceElement -> stackTraceElement.getMethodName().contains("isValid"));
        }
        return false;
    }

    private static void initConnectionPoolSettings(BasicDataSource dataSource, ConnectionPoolInfo poolInfo) {
        if (poolInfo == null) {
            return;
        }
        dataSource.setMaxTotal(poolInfo.getMaxSize());
        dataSource.setMinIdle(poolInfo.getMinSize());
        dataSource.setMaxIdle(poolInfo.getMaxIdle());
        dataSource.setMaxWaitMillis(poolInfo.getMaxWait());
        dataSource.setDefaultCatalog(poolInfo.getDefaultCatalog());
        if (poolInfo.getInitialSize() != null) {
            dataSource.setInitialSize(poolInfo.getInitialSize().intValue());
        }
        if (UtilValidate.isNotEmpty((String)poolInfo.getValidationQuery())) {
            dataSource.setTestOnBorrow(poolInfo.getTestOnBorrow() == null || poolInfo.getTestOnBorrow() != false);
            if (poolInfo.getTestOnReturn() != null) {
                dataSource.setTestOnReturn(poolInfo.getTestOnReturn().booleanValue());
            }
            if (poolInfo.getTestWhileIdle() != null) {
                dataSource.setTestWhileIdle(poolInfo.getTestWhileIdle().booleanValue());
            }
            dataSource.setValidationQuery(poolInfo.getValidationQuery());
            if (poolInfo.getValidationQueryTimeout() != null) {
                dataSource.setValidationQueryTimeout(poolInfo.getValidationQueryTimeout().intValue());
            }
        }
        if (poolInfo.getPoolPreparedStatements() != null) {
            dataSource.setPoolPreparedStatements(poolInfo.getPoolPreparedStatements().booleanValue());
            if (dataSource.isPoolPreparedStatements() && poolInfo.getMaxOpenPreparedStatements() != null) {
                dataSource.setMaxOpenPreparedStatements(poolInfo.getMaxOpenPreparedStatements().intValue());
            }
        }
        if (poolInfo.getRemoveAbandonedOnBorrow() != null) {
            dataSource.setRemoveAbandonedOnBorrow(poolInfo.getRemoveAbandonedOnBorrow().booleanValue());
        }
        if (poolInfo.getRemoveAbandonedOnMaintanance() != null) {
            dataSource.setRemoveAbandonedOnMaintenance(poolInfo.getRemoveAbandonedOnMaintanance().booleanValue());
        }
        if (poolInfo.getRemoveAbandonedTimeout() != null) {
            dataSource.setRemoveAbandonedTimeout(poolInfo.getRemoveAbandonedTimeout().intValue());
        }
        if (poolInfo.getMinEvictableTimeMillis() != null) {
            dataSource.setMinEvictableIdleTimeMillis(poolInfo.getMinEvictableTimeMillis().longValue());
        }
        if (poolInfo.getNumTestsPerEvictionRun() != null) {
            dataSource.setNumTestsPerEvictionRun(poolInfo.getNumTestsPerEvictionRun().intValue());
        }
        if (poolInfo.getTimeBetweenEvictionRunsMillis() != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(poolInfo.getTimeBetweenEvictionRunsMillis().longValue());
        }
    }

    private static BasicDataSource createDataSource(JdbcDatasourceInfo jdbcDatasource) throws Exception {
        Properties dbcpProperties = DBCPConnectionFactory.loadDbcpProperties();
        BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)dbcpProperties);
        dataSource.setDriverClassLoader(Thread.currentThread().getContextClassLoader());
        dataSource.setDriverClassName(jdbcDatasource.getDriverClassName());
        dataSource.setUrl(jdbcDatasource.getUri());
        dataSource.setUsername(jdbcDatasource.getUsername());
        dataSource.setPassword(jdbcDatasource.getPassword());
        if (UtilValidate.isNotEmpty((String)jdbcDatasource.getIsolationLevel())) {
            dataSource.setDefaultTransactionIsolation(TransactionIsolations.fromString(jdbcDatasource.getIsolationLevel()));
        }
        if (dbcpProperties.containsKey(PROP_JMX) && Boolean.valueOf(dbcpProperties.getProperty(PROP_JMX)).booleanValue()) {
            dataSource.setJmxName(ObjectName.getInstance(dbcpProperties.getProperty(PROP_MBEANNAME)).getCanonicalName());
        }
        return dataSource;
    }

    private static String toString(Properties properties) {
        ArrayList<String> props = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            props.add(key + "=" + properties.getProperty(key));
        }
        return Joiner.on((char)';').skipNulls().join(props);
    }

    private static Properties loadDbcpProperties() {
        Properties dbcpProperties = new Properties();
        InputStream fileProperties = DBCPConnectionFactory.class.getResourceAsStream("/dbcp.properties");
        if (fileProperties != null) {
            try {
                dbcpProperties.load(fileProperties);
            }
            catch (IOException e) {
                log.error("Error loading dbcp.properties", (Throwable)e);
            }
        }
        Properties systemProperties = System.getProperties();
        for (String systemProp : systemProperties.stringPropertyNames()) {
            String prefix = "dbcp.";
            if (!systemProp.startsWith("dbcp.")) continue;
            dbcpProperties.setProperty(systemProp.substring("dbcp.".length()), System.getProperty(systemProp));
        }
        return dbcpProperties;
    }

    private static Connection trackConnection(String helperName, final DataSource dataSource) {
        ConnectionTracker connectionTracker = trackerCache.get(helperName);
        return connectionTracker.trackConnection(helperName, new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                return dataSource.getConnection();
            }
        });
    }

    public static synchronized void removeDatasource(String helperName) {
        BasicDataSource dataSource = dsCache.get(helperName);
        if (dataSource != null) {
            try {
                dataSource.close();
                DBCPConnectionFactory.unregisterMBeanIfPresent();
            }
            catch (Exception e) {
                Debug.logError((Throwable)e, (String)"Error closing connection pool in DBCP");
            }
            dsCache.remove(helperName);
        }
        trackerCache.remove(helperName);
    }

    private static void unregisterMBeanIfPresent() {
        Properties dbcpProperties = DBCPConnectionFactory.loadDbcpProperties();
        if (dbcpProperties.containsKey(PROP_JMX) && Boolean.valueOf(dbcpProperties.getProperty(PROP_JMX)).booleanValue()) {
            String mBeanName = dbcpProperties.getProperty(PROP_MBEANNAME);
            try {
                ObjectName objectName = ObjectName.getInstance(dbcpProperties.getProperty(PROP_MBEANNAME));
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                if (platformMBeanServer.isRegistered(objectName)) {
                    platformMBeanServer.unregisterMBean(objectName);
                }
            }
            catch (Exception e) {
                log.error("Exception un-registering MBean data source " + mBeanName, (Throwable)e);
            }
        }
    }
}

