/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.jdbc.alternative.IndexAlternativeAction;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.util.ClassLoaderUtils;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModelIndex {
    protected ModelEntity mainEntity;
    protected String name;
    protected boolean unique;
    protected List<String> fieldNames = new ArrayList<String>();
    protected List<IndexAlternativeAction> alternativeActions = new ArrayList<IndexAlternativeAction>();

    public ModelIndex() {
        this.name = "";
        this.unique = false;
    }

    public ModelIndex(ModelEntity mainEntity, Element indexElement) {
        this.mainEntity = mainEntity;
        this.populateFieldsFromIndexElement(indexElement);
        this.instantiateAlternativeActionsFromIndexElement(indexElement);
    }

    private void populateFieldsFromIndexElement(Element indexElement) {
        this.name = UtilXml.checkEmpty((String)indexElement.getAttribute("name"));
        this.unique = "true".equals(UtilXml.checkEmpty((String)indexElement.getAttribute("unique")));
        NodeList indexFieldList = indexElement.getElementsByTagName("index-field");
        for (int i = 0; i < indexFieldList.getLength(); ++i) {
            Element indexFieldElement = (Element)indexFieldList.item(i);
            if (indexFieldElement.getParentNode() != indexElement) continue;
            String fieldName = indexFieldElement.getAttribute("name");
            this.fieldNames.add(fieldName);
        }
    }

    private void instantiateAlternativeActionsFromIndexElement(Element indexElement) {
        NodeList alternativeActionList = indexElement.getElementsByTagName("alternative");
        for (int i = 0; i < alternativeActionList.getLength(); ++i) {
            try {
                Element alternativeAction = (Element)alternativeActionList.item(i);
                String actionClass = alternativeAction.getAttribute("action");
                IndexAlternativeAction indexAlternativeAction = (IndexAlternativeAction)ClassLoaderUtils.loadClass(actionClass, ModelIndex.class).newInstance();
                this.alternativeActions.add(indexAlternativeAction);
                continue;
            }
            catch (ReflectiveOperationException re) {
                throw new RuntimeException(re);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public ModelEntity getMainEntity() {
        return this.mainEntity;
    }

    public void setMainEntity(ModelEntity mainEntity) {
        this.mainEntity = mainEntity;
    }

    public Iterator<String> getIndexFieldsIterator() {
        return this.fieldNames.iterator();
    }

    public int getIndexFieldsSize() {
        return this.fieldNames.size();
    }

    public String getIndexField(int index) {
        return this.fieldNames.get(index);
    }

    public void addIndexField(String fieldName) {
        this.fieldNames.add(fieldName);
    }

    public String removeIndexField(int index) {
        return this.fieldNames.remove(index);
    }

    public Optional<IndexAlternativeAction> getAlternativeIndexAction(DatabaseUtil dbUtil) throws SQLException, GenericEntityException {
        LinkedList<IndexAlternativeAction> runnableAlternativeActions = new LinkedList<IndexAlternativeAction>();
        for (IndexAlternativeAction alternativeAction : this.alternativeActions) {
            if (!alternativeAction.shouldRun(this.mainEntity, this, dbUtil)) continue;
            runnableAlternativeActions.add(alternativeAction);
        }
        switch (runnableAlternativeActions.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(runnableAlternativeActions.get(0));
            }
        }
        throw new IllegalStateException("There can't be two runnable alternative actions for one index");
    }

    public void addAlternativeAction(IndexAlternativeAction indexAlternativeAction) {
        this.alternativeActions.add(indexAlternativeAction);
    }
}

