/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.model.FunctionDefinitionBuilder;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelUtil;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;

public class ModelFunctionBasedIndex {
    private final ModelEntity mainEntity;
    private final String name;
    private String function;
    private final boolean unique;
    private final FunctionDefinitionBuilder builder;
    private String type;

    public ModelFunctionBasedIndex(ModelEntity mainEntity, String name, boolean unique, FunctionDefinitionBuilder builder) {
        this.mainEntity = mainEntity;
        this.name = name;
        this.unique = unique;
        this.builder = builder;
        this.type = builder.getType();
    }

    public ModelFunctionBasedIndex(ModelEntity mainEntity, Element indexElement) {
        this.mainEntity = mainEntity;
        this.name = UtilXml.checkEmpty((String)indexElement.getAttribute("name"));
        this.unique = "true".equals(UtilXml.checkEmpty((String)indexElement.getAttribute("unique")));
        this.function = UtilXml.checkEmpty((String)indexElement.getAttribute("function"));
        Element builderElement = UtilXml.firstChildElement((Element)indexElement, (String)"builder");
        String builderClass = builderElement.getAttribute("class");
        Element functionDefinitionElement = UtilXml.firstChildElement((Element)builderElement, (String)"function-definition");
        this.type = functionDefinitionElement.getAttribute("type");
        String virtualColumn = functionDefinitionElement.getAttribute("virtual-column");
        String argList = functionDefinitionElement.getAttribute("arg-list");
        List<String> columns = UtilXml.childElementList((Element)functionDefinitionElement, (String)"column").stream().map(element -> element.getAttribute("name")).collect(Collectors.toList());
        this.builder = this.getFunctionDefinitionBuilder(builderClass, virtualColumn, this.type, columns, argList);
    }

    private FunctionDefinitionBuilder getFunctionDefinitionBuilder(String clazz, String virtualColumn, String type, List<String> columns, @Nullable String argsList) {
        FunctionDefinitionBuilder builder;
        try {
            Constructor<?> cons = Class.forName(clazz).getConstructor(String.class, String.class, List.class, String.class);
            builder = (FunctionDefinitionBuilder)cons.newInstance(virtualColumn, type, columns, argsList);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public String getFunction(DatabaseType dbType) {
        return this.builder.getFunctionDefinition(dbType);
    }

    public boolean getUnique() {
        return this.unique;
    }

    public String getVirtualColumn(DatabaseType dbType) {
        return this.builder.getVirtualColumn(dbType);
    }

    public String getType() {
        return this.type;
    }

    public ModelEntity getMainEntity() {
        return this.mainEntity;
    }

    public ModelField getVirtualColumnModelField(DatabaseType dbType) {
        ModelField modelField = null;
        String virtualColumn = this.builder.getVirtualColumn(dbType);
        if (virtualColumn != null) {
            modelField = new ModelField();
            modelField.setName(virtualColumn);
            modelField.setType(this.type);
            modelField.setColName(ModelUtil.javaNameToDbName(virtualColumn));
        }
        return modelField;
    }

    public boolean supportsFunctionBasedIndices(DatabaseType databaseType) {
        return this.builder.supportsFunctionBasedIndices(databaseType);
    }
}

