/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionParam;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.jdbc.sql.escape.SqlEscapeHelper;
import org.ofbiz.core.entity.model.ModelEntity;

public class EntityConditionList
extends EntityCondition {
    protected List<? extends EntityCondition> conditionList;
    protected EntityOperator operator;

    protected EntityConditionList() {
    }

    public EntityConditionList(List<? extends EntityCondition> conditionList, EntityOperator operator) {
        this.conditionList = conditionList;
        this.operator = operator;
    }

    public EntityOperator getOperator() {
        return this.operator;
    }

    public EntityCondition getCondition(int index) {
        return this.conditionList.get(index);
    }

    public int getConditionListSize() {
        return this.conditionList.size();
    }

    public Iterator<? extends EntityCondition> getConditionIterator() {
        return this.conditionList.iterator();
    }

    @Override
    public String makeWhereString(ModelEntity modelEntity, List<? super EntityConditionParam> entityConditionParams, SqlEscapeHelper sqlEscapeHelper) {
        StringBuilder whereStringBuilder = new StringBuilder();
        if (this.conditionList != null && this.conditionList.size() > 0) {
            for (int i = 0; i < this.conditionList.size(); ++i) {
                EntityCondition condition = this.conditionList.get(i);
                whereStringBuilder.append('(');
                whereStringBuilder.append(condition.makeWhereString(modelEntity, entityConditionParams, sqlEscapeHelper));
                whereStringBuilder.append(')');
                if (i >= this.conditionList.size() - 1) continue;
                whereStringBuilder.append(' ');
                whereStringBuilder.append(this.operator.getCode());
                whereStringBuilder.append(' ');
            }
        }
        return whereStringBuilder.toString();
    }

    @Override
    public void checkCondition(ModelEntity modelEntity) throws GenericModelException {
        for (EntityCondition entityCondition : this.conditionList) {
            entityCondition.checkCondition(modelEntity);
        }
    }

    @Override
    public int getParameterCount(ModelEntity modelEntity, SqlEscapeHelper sqlEscapeHelper) {
        int count = 0;
        for (EntityCondition entityCondition : this.conditionList) {
            count += entityCondition.getParameterCount(modelEntity, sqlEscapeHelper);
        }
        return count;
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        toStringBuilder.append("[conditionList::");
        if (this.conditionList != null && this.conditionList.size() > 0) {
            for (int i = 0; i < this.conditionList.size(); ++i) {
                EntityCondition condition = this.conditionList.get(i);
                toStringBuilder.append(condition.toString());
                if (i <= 0) continue;
                toStringBuilder.append("::");
            }
        }
        toStringBuilder.append(']');
        return toStringBuilder.toString();
    }
}

