/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.interceptors.connection;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;
import org.ofbiz.core.util.Debug;

public class SafeDelegatingSqlConnectionInterceptor
implements SQLConnectionInterceptor {
    private static final String MODULE = SafeDelegatingSqlConnectionInterceptor.class.getName();
    private final SQLConnectionInterceptor delegate;

    public SafeDelegatingSqlConnectionInterceptor(SQLConnectionInterceptor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onConnectionTaken(Connection connection, ConnectionPoolState connectionPoolState) {
        try {
            this.delegate.onConnectionTaken(connection, connectionPoolState);
        }
        catch (LinkageError | RuntimeException e) {
            SafeDelegatingSqlConnectionInterceptor.logError(e, "onConnectionTaken", connection, connectionPoolState);
        }
    }

    @Override
    public void onConnectionReplaced(Connection connection, ConnectionPoolState connectionPoolState) {
        try {
            this.delegate.onConnectionReplaced(connection, connectionPoolState);
        }
        catch (LinkageError | RuntimeException e) {
            SafeDelegatingSqlConnectionInterceptor.logError(e, "onConnectionReplaced", connection, connectionPoolState);
        }
    }

    @Override
    public void beforeExecution(String sqlString, List<String> parameterValues, Statement statement) {
        try {
            this.delegate.beforeExecution(sqlString, parameterValues, statement);
        }
        catch (LinkageError | RuntimeException e) {
            SafeDelegatingSqlConnectionInterceptor.logError(e, "beforeExecution", sqlString, parameterValues, statement);
        }
    }

    @Override
    public void afterSuccessfulExecution(String sqlString, List<String> parameterValues, Statement statement, ResultSet resultSet, int rowsUpdated) {
        try {
            this.delegate.afterSuccessfulExecution(sqlString, parameterValues, statement, resultSet, rowsUpdated);
        }
        catch (LinkageError | RuntimeException e) {
            SafeDelegatingSqlConnectionInterceptor.logError(e, "afterSuccessfulExecution", sqlString, parameterValues, statement, resultSet, rowsUpdated);
        }
    }

    @Override
    public void onException(String sqlString, List<String> parameterValues, Statement statement, SQLException sqlException) {
        try {
            this.delegate.onException(sqlString, parameterValues, statement, sqlException);
        }
        catch (LinkageError | RuntimeException e) {
            SafeDelegatingSqlConnectionInterceptor.logError(e, "onException", sqlString, parameterValues, statement, sqlException);
        }
    }

    private static void logError(Throwable e, String fn, Object ... args) {
        Debug.logError((Throwable)e, (String)("Unexpected exception from SQL connection interceptor callback: " + fn + '(' + Arrays.deepToString(args) + ')'), (String)MODULE);
    }
}

