/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.config;

public class ConnectionPoolInfo {
    public static final int DEFAULT_POOL_MAX_SIZE = 8;
    public static final int DEFAULT_POOL_MIN_SIZE = 2;
    public static final long DEFAULT_POOL_MAX_WAIT = 60000L;
    public static final long DEFAULT_POOL_SLEEP_TIME = 300000L;
    public static final long DEFAULT_POOL_LIFE_TIME = 600000L;
    public static final long DEFAULT_DEADLOCK_MAX_WAIT = 600000L;
    public static final long DEFAULT_DEADLOCK_RETRY_WAIT = 10000L;
    private final int maxSize;
    private final int minSize;
    private final int maxIdle;
    private final long maxWait;
    private final long sleepTime;
    private final long lifeTime;
    private final long deadLockMaxWait;
    private final long deadLockRetryWait;
    private final Long minEvictableTimeMillis;
    private final Long timeBetweenEvictionRunsMillis;
    private final String defaultCatalog;
    private final Integer initialSize;
    private final Integer maxOpenPreparedStatements;
    private final Integer numTestsPerEvictionRun;
    private final Boolean poolPreparedStatements;
    private final Boolean removeAbandonedOnBorrow;
    private final Boolean removeAbandonedOnMaintanance;
    private final Integer removeAbandonedTimeout;
    private final Boolean testOnBorrow;
    private final Boolean testOnReturn;
    private final Boolean testWhileIdle;
    private final Integer validationQueryTimeout;
    private final String validationQuery;

    public static Builder builder() {
        return new Builder();
    }

    public ConnectionPoolInfo(Integer maxSize, Integer minSize, Long maxWait, long sleepTime, long lifeTime, long deadLockMaxWait, long deadLockRetryWait, String validationQuery, Long minEvictableTimeMillis, Long timeBetweenEvictionRunsMillis) {
        this(new Builder().setPoolMaxSize(maxSize).setPoolMinSize(minSize).setPoolMaxWait(maxWait).setPoolSleepTime(sleepTime).setPoolLifeTime(lifeTime).setDeadLockMaxWait(deadLockMaxWait).setDeadLockRetryWait(deadLockRetryWait).setValidationQuery(validationQuery).setMinEvictableTimeMillis(minEvictableTimeMillis).setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis));
    }

    ConnectionPoolInfo(Builder builder) {
        this.deadLockMaxWait = this.longWithDefault(builder.getDeadLockMaxWait(), 600000L);
        this.deadLockRetryWait = this.longWithDefault(builder.getDeadLockRetryWait(), 10000L);
        this.defaultCatalog = builder.getDefaultCatalog();
        this.initialSize = builder.getPoolInitialSize();
        this.lifeTime = this.longWithDefault(builder.getPoolLifeTime(), 600000L);
        this.maxOpenPreparedStatements = builder.getMaxOpenPreparedStatements();
        this.maxSize = this.intWithDefault(builder.getPoolMaxSize(), 8);
        this.maxIdle = this.intWithDefault(builder.getPoolMaxIdle(), this.maxSize);
        this.maxWait = this.longWithDefault(builder.getPoolMaxWait(), 60000L);
        this.minEvictableTimeMillis = builder.getMinEvictableTimeMillis();
        this.minSize = this.intWithDefault(builder.getPoolMinSize(), 2);
        this.numTestsPerEvictionRun = builder.getNumTestsPerEvictionRun();
        this.poolPreparedStatements = builder.getPoolPreparedStatements();
        this.removeAbandonedTimeout = builder.getRemoveAbandonedTimeout();
        this.removeAbandonedOnBorrow = builder.getRemoveAbandonedOnBorrow();
        this.removeAbandonedOnMaintanance = builder.getRemoveAbandonedOnMaintenance();
        this.sleepTime = this.longWithDefault(builder.getPoolSleepTime(), 300000L);
        this.testOnBorrow = builder.getTestOnBorrow();
        this.testOnReturn = builder.getTestOnReturn();
        this.testWhileIdle = builder.getTestWhileIdle();
        this.timeBetweenEvictionRunsMillis = builder.getTimeBetweenEvictionRunsMillis();
        this.validationQuery = builder.getValidationQuery();
        this.validationQueryTimeout = builder.getValidationQueryTimeout();
    }

    public Builder toBuilder() {
        return ConnectionPoolInfo.builder().setDeadLockMaxWait(this.nullIfDefault(this.deadLockMaxWait, 600000L)).setDeadLockRetryWait(this.nullIfDefault(this.deadLockRetryWait, 10000L)).setDefaultCatalog(this.defaultCatalog).setPoolInitialSize(this.initialSize).setPoolLifeTime(this.nullIfDefault(this.lifeTime, 600000L)).setMaxOpenPreparedStatements(this.maxOpenPreparedStatements).setPoolMaxSize(this.maxSize).setPoolMaxIdle(this.nullIfDefault(this.maxIdle, this.maxSize)).setPoolMaxWait(this.nullIfDefault(this.maxWait, 60000L)).setMinEvictableTimeMillis(this.minEvictableTimeMillis).setPoolMinSize(this.nullIfDefault(this.minSize, 2)).setNumTestsPerEvictionRun(this.numTestsPerEvictionRun).setPoolPreparedStatements(this.poolPreparedStatements).setRemoveAbandonedTimeout(this.removeAbandonedTimeout).setRemoveAbandonedOnBorrow(this.removeAbandonedOnBorrow).setRemoveAbandonedOnMaintenance(this.removeAbandonedOnMaintanance).setPoolSleepTime(this.nullIfDefault(this.sleepTime, 300000L)).setTestOnBorrow(this.testOnBorrow).setTestOnReturn(this.testOnReturn).setTestWhileIdle(this.testWhileIdle).setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis).setValidationQuery(this.validationQuery).setValidationQueryTimeout(this.validationQueryTimeout);
    }

    private Integer nullIfDefault(int value, int defaultValue) {
        return value != defaultValue ? Integer.valueOf(value) : null;
    }

    private int intWithDefault(Integer value, int defaultValue) {
        return value != null ? value : defaultValue;
    }

    private Long nullIfDefault(long value, long defaultValue) {
        return value != defaultValue ? Long.valueOf(value) : null;
    }

    private long longWithDefault(Long value, long defaultValue) {
        return value != null ? value : defaultValue;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public long getDeadLockMaxWait() {
        return this.deadLockMaxWait;
    }

    public long getDeadLockRetryWait() {
        return this.deadLockRetryWait;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Long getMinEvictableTimeMillis() {
        return this.minEvictableTimeMillis;
    }

    public Long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public Boolean getPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public Boolean getRemoveAbandonedOnBorrow() {
        return this.removeAbandonedOnBorrow;
    }

    public Boolean getRemoveAbandonedOnMaintanance() {
        return this.removeAbandonedOnMaintanance;
    }

    public Boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public Boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public Boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public Integer getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public Integer getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public Integer getRemoveAbandonedTimeout() {
        return this.removeAbandonedTimeout;
    }

    public Integer getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionPoolInfo");
        sb.append("{maxSize=").append(this.maxSize);
        sb.append(", minSize=").append(this.minSize);
        sb.append(", initialSize=").append(this.initialSize);
        sb.append(", maxIdle=").append(this.maxIdle);
        sb.append(", maxWait=").append(this.maxWait);
        sb.append(", sleepTime=").append(this.sleepTime);
        sb.append(", lifeTime=").append(this.lifeTime);
        sb.append(", deadLockMaxWait=").append(this.deadLockMaxWait);
        sb.append(", deadLockRetryWait=").append(this.deadLockRetryWait);
        sb.append(", validationQuery=");
        if (this.validationQuery != null) {
            sb.append('\'').append(this.validationQuery).append('\'');
        } else {
            sb.append("null");
        }
        sb.append(", minEvictableTimeMillis=").append(this.minEvictableTimeMillis);
        sb.append(", timeBetweenEvictionRunsMillis=").append(this.timeBetweenEvictionRunsMillis);
        sb.append(", poolPreparedStatements=").append(this.poolPreparedStatements);
        sb.append(", testOnBorrow=").append(this.testOnBorrow);
        sb.append(", testOnReturn=").append(this.testOnReturn);
        sb.append(", testWhileIdle=").append(this.testWhileIdle);
        sb.append(", maxOpenPreparedStatements=").append(this.maxOpenPreparedStatements);
        sb.append(", numTestsPerEvictionRun=").append(this.numTestsPerEvictionRun);
        sb.append(", removeAbandonedOnBorrow=").append(this.removeAbandonedOnBorrow);
        sb.append(", removeAbandonedOnMaintanance=").append(this.removeAbandonedOnMaintanance);
        sb.append(", removeAbandonedTimeout=").append(this.removeAbandonedTimeout);
        sb.append(", validationQueryTimeout=").append(this.validationQueryTimeout);
        sb.append(", defaultCatalog=").append(this.defaultCatalog);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConnectionPoolInfo)) {
            return false;
        }
        ConnectionPoolInfo other = (ConnectionPoolInfo)o;
        return this.maxIdle == other.maxIdle && this.maxSize == other.maxSize && this.maxWait == other.maxWait && this.minSize == other.minSize && this.lifeTime == other.lifeTime && this.sleepTime == other.sleepTime && ConnectionPoolInfo.equals(this.deadLockMaxWait, other.deadLockMaxWait) && ConnectionPoolInfo.equals(this.deadLockRetryWait, other.deadLockRetryWait) && ConnectionPoolInfo.equals(this.defaultCatalog, other.defaultCatalog) && ConnectionPoolInfo.equals(this.maxOpenPreparedStatements, other.maxOpenPreparedStatements) && ConnectionPoolInfo.equals(this.minEvictableTimeMillis, other.minEvictableTimeMillis) && ConnectionPoolInfo.equals(this.numTestsPerEvictionRun, other.numTestsPerEvictionRun) && ConnectionPoolInfo.equals(this.initialSize, other.initialSize) && ConnectionPoolInfo.equals(this.removeAbandonedOnBorrow, other.removeAbandonedOnBorrow) && ConnectionPoolInfo.equals(this.removeAbandonedOnMaintanance, other.removeAbandonedOnMaintanance) && ConnectionPoolInfo.equals(this.removeAbandonedTimeout, other.removeAbandonedTimeout) && ConnectionPoolInfo.equals(this.testOnBorrow, other.testOnBorrow) && ConnectionPoolInfo.equals(this.testOnReturn, other.testOnReturn) && ConnectionPoolInfo.equals(this.testWhileIdle, other.testWhileIdle) && ConnectionPoolInfo.equals(this.timeBetweenEvictionRunsMillis, other.timeBetweenEvictionRunsMillis) && ConnectionPoolInfo.equals(this.validationQuery, other.validationQuery) && ConnectionPoolInfo.equals(this.validationQueryTimeout, other.validationQueryTimeout);
    }

    public int hashCode() {
        int h = 523124044;
        h = ConnectionPoolInfo.hash(h, this.deadLockMaxWait);
        h = ConnectionPoolInfo.hash(h, this.deadLockRetryWait);
        h = ConnectionPoolInfo.hash(h, this.defaultCatalog);
        h = ConnectionPoolInfo.hash(h, this.maxOpenPreparedStatements);
        h = ConnectionPoolInfo.hash(h, this.minEvictableTimeMillis);
        h = ConnectionPoolInfo.hash(h, this.numTestsPerEvictionRun);
        h = ConnectionPoolInfo.hash(h, this.initialSize);
        h = ConnectionPoolInfo.hash(h, this.lifeTime);
        h = ConnectionPoolInfo.hash(h, this.maxIdle);
        h = ConnectionPoolInfo.hash(h, this.maxSize);
        h = ConnectionPoolInfo.hash(h, this.maxWait);
        h = ConnectionPoolInfo.hash(h, this.minSize);
        h = ConnectionPoolInfo.hash(h, this.sleepTime);
        h = ConnectionPoolInfo.hash(h, this.removeAbandonedOnBorrow);
        h = ConnectionPoolInfo.hash(h, this.removeAbandonedOnMaintanance);
        h = ConnectionPoolInfo.hash(h, this.removeAbandonedTimeout);
        h = ConnectionPoolInfo.hash(h, this.testOnBorrow);
        h = ConnectionPoolInfo.hash(h, this.testOnReturn);
        h = ConnectionPoolInfo.hash(h, this.testWhileIdle);
        h = ConnectionPoolInfo.hash(h, this.timeBetweenEvictionRunsMillis);
        h = ConnectionPoolInfo.hash(h, this.validationQueryTimeout);
        h = ConnectionPoolInfo.hash(h, this.validationQuery);
        return h;
    }

    private static int hash(int h, Object o) {
        return h * 17 + (o != null ? o.hashCode() : 0);
    }

    private static <T> boolean equals(T o1, T o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public static class Builder {
        private Boolean poolPreparedStatements;
        private Boolean removeAbandonedOnBorrow;
        private Boolean removeAbandonedOnMaintenance;
        private Boolean testOnBorrow;
        private Boolean testOnReturn;
        private Boolean testWhileIdle;
        private Integer poolMinSize;
        private Integer poolMaxSize;
        private Integer poolInitialSize;
        private Integer poolMaxIdle;
        private Long poolMaxWait;
        private Long poolSleepTime;
        private Long poolLifeTime;
        private Long deadLockMaxWait;
        private Long deadLockRetryWait;
        private Integer maxOpenPreparedStatements;
        private Integer numTestsPerEvictionRun;
        private Integer removeAbandonedTimeout;
        private Integer validationQueryTimeout;
        private String validationQuery;
        private String defaultCatalog;
        private Long minEvictableTimeMillis;
        private Long timeBetweenEvictionRunsMillis;

        public ConnectionPoolInfo build() {
            return new ConnectionPoolInfo(this);
        }

        public String getValidationQuery() {
            return this.validationQuery;
        }

        public Builder setValidationQuery(String validationQuery) {
            this.validationQuery = this.ignoreBlank(validationQuery);
            return this;
        }

        public Long getMinEvictableTimeMillis() {
            return this.minEvictableTimeMillis;
        }

        public Builder setMinEvictableTimeMillis(Long minEvictableTimeMillis) {
            this.minEvictableTimeMillis = minEvictableTimeMillis;
            return this;
        }

        public Long getTimeBetweenEvictionRunsMillis() {
            return this.timeBetweenEvictionRunsMillis;
        }

        public Builder setTimeBetweenEvictionRunsMillis(Long timeBetweenEvictionRunsMillis) {
            this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
            return this;
        }

        public Long getPoolMaxWait() {
            return this.poolMaxWait;
        }

        public Builder setPoolMaxWait(Long poolMaxWait) {
            this.poolMaxWait = poolMaxWait;
            return this;
        }

        public Integer getPoolMinSize() {
            return this.poolMinSize;
        }

        public Builder setPoolMinSize(Integer poolMinSize) {
            this.poolMinSize = poolMinSize;
            return this;
        }

        public Integer getPoolMaxSize() {
            return this.poolMaxSize;
        }

        public Builder setPoolMaxSize(Integer poolMaxSize) {
            this.poolMaxSize = poolMaxSize;
            return this;
        }

        public Integer getPoolMaxIdle() {
            return this.poolMaxIdle;
        }

        public Builder setPoolMaxIdle(Integer poolMaxIdle) {
            this.poolMaxIdle = poolMaxIdle;
            return this;
        }

        public Integer getPoolInitialSize() {
            return this.poolInitialSize;
        }

        public Builder setPoolInitialSize(Integer poolInitialSize) {
            this.poolInitialSize = poolInitialSize;
            return this;
        }

        public Boolean getPoolPreparedStatements() {
            return this.poolPreparedStatements;
        }

        public Builder setPoolPreparedStatements(Boolean poolPreparedStatements) {
            this.poolPreparedStatements = poolPreparedStatements;
            return this;
        }

        public Boolean getRemoveAbandonedOnBorrow() {
            return this.removeAbandonedOnBorrow;
        }

        public Builder setRemoveAbandonedOnBorrow(Boolean removeAbandonedOnBorrow) {
            this.removeAbandonedOnBorrow = removeAbandonedOnBorrow;
            return this;
        }

        public Boolean getRemoveAbandonedOnMaintenance() {
            return this.removeAbandonedOnMaintenance;
        }

        public Builder setRemoveAbandonedOnMaintenance(Boolean removeAbandonedOnMaintenance) {
            this.removeAbandonedOnMaintenance = removeAbandonedOnMaintenance;
            return this;
        }

        public Boolean getTestOnBorrow() {
            return this.testOnBorrow;
        }

        public Builder setTestOnBorrow(Boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
            return this;
        }

        public Boolean getTestOnReturn() {
            return this.testOnReturn;
        }

        public Builder setTestOnReturn(Boolean testOnReturn) {
            this.testOnReturn = testOnReturn;
            return this;
        }

        public Boolean getTestWhileIdle() {
            return this.testWhileIdle;
        }

        public Builder setTestWhileIdle(Boolean testWhileIdle) {
            this.testWhileIdle = testWhileIdle;
            return this;
        }

        public Integer getMaxOpenPreparedStatements() {
            return this.maxOpenPreparedStatements;
        }

        public Builder setMaxOpenPreparedStatements(Integer maxOpenPreparedStatements) {
            this.maxOpenPreparedStatements = maxOpenPreparedStatements;
            return this;
        }

        public Integer getNumTestsPerEvictionRun() {
            return this.numTestsPerEvictionRun;
        }

        public Builder setNumTestsPerEvictionRun(Integer numTestsPerEvictionRun) {
            this.numTestsPerEvictionRun = numTestsPerEvictionRun;
            return this;
        }

        public Integer getRemoveAbandonedTimeout() {
            return this.removeAbandonedTimeout;
        }

        public Builder setRemoveAbandonedTimeout(Integer removeAbandonedTimeout) {
            this.removeAbandonedTimeout = removeAbandonedTimeout;
            return this;
        }

        public Integer getValidationQueryTimeout() {
            return this.validationQueryTimeout;
        }

        public Builder setValidationQueryTimeout(Integer validationQueryTimeout) {
            this.validationQueryTimeout = validationQueryTimeout;
            return this;
        }

        public String getDefaultCatalog() {
            return this.defaultCatalog;
        }

        public Builder setDefaultCatalog(String defaultCatalog) {
            this.defaultCatalog = this.ignoreBlank(defaultCatalog);
            return this;
        }

        public Long getPoolSleepTime() {
            return this.poolSleepTime;
        }

        public Builder setPoolSleepTime(Long poolSleepTime) {
            this.poolSleepTime = poolSleepTime;
            return this;
        }

        public Long getPoolLifeTime() {
            return this.poolLifeTime;
        }

        public Builder setPoolLifeTime(Long poolLifeTime) {
            this.poolLifeTime = poolLifeTime;
            return this;
        }

        public Long getDeadLockMaxWait() {
            return this.deadLockMaxWait;
        }

        public Builder setDeadLockMaxWait(Long deadLockMaxWait) {
            this.deadLockMaxWait = deadLockMaxWait;
            return this;
        }

        public Long getDeadLockRetryWait() {
            return this.deadLockRetryWait;
        }

        public Builder setDeadLockRetryWait(Long deadLockRetryWait) {
            this.deadLockRetryWait = deadLockRetryWait;
            return this;
        }

        private String ignoreBlank(String s) {
            if (s != null && (s = s.trim()).length() > 0) {
                return s;
            }
            return null;
        }

        public boolean equals(Object o) {
            return o instanceof Builder && this.build().equals(((Builder)o).build());
        }

        public int hashCode() {
            return this.build().hashCode();
        }
    }
}

