/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.config;

import java.util.Properties;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.util.PropertyUtils;

public class JdbcDatasourceInfo {
    private final String uri;
    private final String driverClassName;
    private final String username;
    private final String password;
    private final String isolationLevel;
    private final Properties connectionProperties;
    private final ConnectionPoolInfo connectionPoolInfo;

    public JdbcDatasourceInfo(String uri, String driverClassName, String username, String password, String isolationLevel, Properties connectionProperties, ConnectionPoolInfo connectionPoolInfo) {
        this.uri = uri;
        this.driverClassName = driverClassName;
        this.username = username;
        this.password = password;
        this.isolationLevel = isolationLevel;
        this.connectionProperties = PropertyUtils.copyOf(connectionProperties);
        this.connectionPoolInfo = connectionPoolInfo;
    }

    public String getUri() {
        return this.uri;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public ConnectionPoolInfo getConnectionPoolInfo() {
        return this.connectionPoolInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JdbcDatasourceInfo");
        sb.append("{uri='").append(this.uri).append('\'');
        sb.append(", driverClassName='").append(this.driverClassName).append('\'');
        sb.append(", username='").append(this.username).append('\'');
        sb.append(", password='").append("********").append('\'');
        sb.append(", isolationLevel='").append(this.isolationLevel).append('\'');
        sb.append(", connectionProperties=").append(this.connectionProperties);
        sb.append(", connectionPoolInfo=").append(this.connectionPoolInfo);
        sb.append('}');
        return sb.toString();
    }
}

