/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.util.UtilDateTime;
import org.ofbiz.core.util.UtilMisc;
import org.ofbiz.core.util.UtilValidate;

public class EntityUtil {
    public static GenericValue getFirst(List<? extends GenericValue> values) {
        if (values != null && values.size() > 0) {
            return values.iterator().next();
        }
        return null;
    }

    public static GenericValue getOnly(List<? extends GenericValue> values) {
        if (values != null) {
            int size = values.size();
            if (size <= 0) {
                return null;
            }
            if (size == 1) {
                return values.iterator().next();
            }
            throw new IllegalArgumentException("Passed List had more than one value.");
        }
        return null;
    }

    public static <T extends GenericEntity> List<T> filterByDate(List<T> datedValues) {
        return EntityUtil.filterByDate(datedValues, UtilDateTime.nowTimestamp(), "fromDate", "thruDate", true);
    }

    public static <T extends GenericEntity> List<T> filterByDate(List<T> datedValues, boolean allAreSame) {
        return EntityUtil.filterByDate(datedValues, UtilDateTime.nowTimestamp(), "fromDate", "thruDate", allAreSame);
    }

    public static <T extends GenericEntity> List<T> filterByDate(List<T> datedValues, Date moment) {
        return EntityUtil.filterByDate(datedValues, new Timestamp(moment.getTime()), "fromDate", "thruDate", true);
    }

    public static <T extends GenericEntity> List<T> filterByDate(List<T> datedValues, Timestamp moment) {
        return EntityUtil.filterByDate(datedValues, moment, "fromDate", "thruDate", true);
    }

    public static <T extends GenericEntity> List<T> filterByDate(List<T> datedValues, Timestamp moment, String fromDateName, String thruDateName, boolean allAreSame) {
        if (datedValues == null) {
            return null;
        }
        if (moment == null) {
            return datedValues;
        }
        if (fromDateName == null) {
            throw new IllegalArgumentException("You must specify the name of the fromDate field to use this method");
        }
        if (thruDateName == null) {
            throw new IllegalArgumentException("You must specify the name of the thruDate field to use this method");
        }
        LinkedList<GenericEntity> result = new LinkedList<GenericEntity>();
        Iterator<T> iter = datedValues.iterator();
        if (allAreSame) {
            Timestamp thruDate;
            Timestamp fromDate;
            GenericEntity datedValue;
            ModelField fromDateField = null;
            ModelField thruDateField = null;
            if (iter.hasNext()) {
                datedValue = (GenericEntity)iter.next();
                fromDateField = datedValue.getModelEntity().getField(fromDateName);
                if (fromDateField == null) {
                    throw new IllegalArgumentException("\"" + fromDateName + "\" is not a field of " + datedValue.getEntityName());
                }
                thruDateField = datedValue.getModelEntity().getField(thruDateName);
                if (fromDateField == null) {
                    throw new IllegalArgumentException("\"" + thruDateName + "\" is not a field of " + datedValue.getEntityName());
                }
                fromDate = (Timestamp)datedValue.dangerousGetNoCheckButFast(fromDateField);
                thruDate = (Timestamp)datedValue.dangerousGetNoCheckButFast(thruDateField);
                if ((thruDate == null || thruDate.after(moment)) && (fromDate == null || fromDate.before(moment))) {
                    result.add(datedValue);
                }
            }
            while (iter.hasNext()) {
                datedValue = (GenericEntity)iter.next();
                fromDate = (Timestamp)datedValue.dangerousGetNoCheckButFast(fromDateField);
                thruDate = (Timestamp)datedValue.dangerousGetNoCheckButFast(thruDateField);
                if (thruDate != null && !thruDate.after(moment) || fromDate != null && !fromDate.before(moment)) continue;
                result.add(datedValue);
            }
        } else {
            while (iter.hasNext()) {
                GenericEntity datedValue = (GenericEntity)iter.next();
                Timestamp fromDate = datedValue.getTimestamp(fromDateName);
                Timestamp thruDate = datedValue.getTimestamp(thruDateName);
                if (thruDate != null && !thruDate.after(moment) || fromDate != null && !fromDate.before(moment)) continue;
                result.add(datedValue);
            }
        }
        return result;
    }

    public static <T extends GenericEntity> List<T> filterByAnd(List<? extends T> values, Map<String, ?> fields) {
        if (values == null) {
            return null;
        }
        ArrayList<Object> result = null;
        if (fields == null || fields.size() == 0) {
            result = new ArrayList<T>(values);
        } else {
            result = new ArrayList(values.size());
            for (GenericEntity value : values) {
                if (!value.matchesFields(fields)) continue;
                result.add(value);
            }
        }
        return result;
    }

    public static <T extends GenericValue> List<T> filterByAnd(List<T> values, List<? extends EntityExpr> exprs) {
        if (values == null) {
            return null;
        }
        if (exprs == null || exprs.size() == 0) {
            return values;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        for (GenericValue value : values) {
            Iterator<? extends EntityExpr> exprIter = exprs.iterator();
            boolean include = true;
            while (exprIter.hasNext()) {
                EntityExpr expr = exprIter.next();
                Object lhs = value.get((String)expr.getLhs());
                Object rhs = expr.getRhs();
                int operatorId = expr.getOperator().getId();
                switch (operatorId) {
                    case 1: {
                        if (lhs == null) {
                            if (rhs == null) break;
                            include = false;
                            break;
                        }
                        if (lhs.equals(rhs)) break;
                        include = false;
                        break;
                    }
                    case 2: {
                        if (lhs == null) {
                            if (rhs != null) break;
                            include = false;
                            break;
                        }
                        if (!lhs.equals(rhs)) break;
                        include = false;
                        break;
                    }
                    case 4: {
                        if (lhs == null) {
                            if (rhs != null) break;
                            include = false;
                            break;
                        }
                        if (((Comparable)lhs).compareTo(rhs) > 0) break;
                        include = false;
                        break;
                    }
                    case 6: {
                        if (lhs == null) {
                            if (rhs == null) break;
                            include = false;
                            break;
                        }
                        if (((Comparable)lhs).compareTo(rhs) >= 0) break;
                        include = false;
                        break;
                    }
                    case 3: {
                        if (lhs == null) {
                            if (rhs != null) break;
                            include = false;
                            break;
                        }
                        if (((Comparable)lhs).compareTo(rhs) < 0) break;
                        include = false;
                        break;
                    }
                    case 5: {
                        if (lhs == null) {
                            if (rhs == null) break;
                            include = false;
                            break;
                        }
                        if (((Comparable)lhs).compareTo(rhs) <= 0) break;
                        include = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The " + expr.getOperator().getCode() + " with id " + expr.getOperator().getId() + " operator is not yet supported by filterByAnd");
                    }
                }
                if (include) continue;
                break;
            }
            if (!include) continue;
            result.add(value);
        }
        return result;
    }

    public static <T extends GenericValue> List<T> orderBy(List<T> values, List<String> orderBy) {
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return UtilMisc.toList(values);
        }
        ArrayList<T> result = new ArrayList<T>(values);
        Collections.sort(result, new OrderByComparator(orderBy));
        return result;
    }

    public static List<GenericValue> getRelated(String relationName, List<? extends GenericValue> values) throws GenericEntityException {
        if (values == null) {
            return null;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        for (GenericValue genericValue : values) {
            result.addAll(genericValue.getRelated(relationName));
        }
        return result;
    }

    public static List<GenericValue> getRelatedCache(String relationName, List<? extends GenericValue> values) throws GenericEntityException {
        if (values == null) {
            return null;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        for (GenericValue genericValue : values) {
            result.addAll(genericValue.getRelatedCache(relationName));
        }
        return result;
    }

    public static List<GenericValue> getRelatedByAnd(String relationName, Map<String, ?> fields, List<? extends GenericValue> values) throws GenericEntityException {
        if (values == null) {
            return null;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        for (GenericValue genericValue : values) {
            result.addAll(genericValue.getRelatedByAnd(relationName, fields));
        }
        return result;
    }

    static class OrderByComparator
    implements Comparator<GenericValue> {
        private String field;
        private ModelField modelField = null;
        private boolean descending;
        private Comparator<GenericValue> next = null;

        OrderByComparator(List<String> orderBy) {
            this(orderBy, 0);
        }

        private OrderByComparator(List<String> orderBy, int startIndex) {
            if (orderBy == null) {
                throw new IllegalArgumentException("orderBy may not be empty");
            }
            if (startIndex >= orderBy.size()) {
                throw new IllegalArgumentException("startIndex may not be greater than or equal to orderBy size");
            }
            String fieldAndDirection = orderBy.get(startIndex);
            String upper = fieldAndDirection.trim().toUpperCase();
            if (upper.endsWith(" DESC")) {
                this.descending = true;
                this.field = fieldAndDirection.substring(0, fieldAndDirection.length() - 5);
            } else if (upper.endsWith(" ASC")) {
                this.descending = false;
                this.field = fieldAndDirection.substring(0, fieldAndDirection.length() - 4);
            } else {
                this.descending = false;
                this.field = fieldAndDirection;
            }
            if (startIndex + 1 < orderBy.size()) {
                this.next = new OrderByComparator(orderBy, startIndex + 1);
            }
        }

        @Override
        public int compare(GenericValue obj, GenericValue obj1) {
            int result = this.compareAsc(obj, obj1);
            if (this.descending && result != 0) {
                result = -result;
            }
            if (result == 0 && this.next != null) {
                return this.next.compare(obj, obj1);
            }
            return result;
        }

        private int compareAsc(GenericEntity obj, GenericEntity obj2) {
            if (this.modelField == null) {
                this.modelField = obj.getModelEntity().getField(this.field);
                if (this.modelField == null) {
                    throw new IllegalArgumentException("The field " + this.field + " could not be found in the entity " + obj.getEntityName());
                }
            }
            Object value = obj.dangerousGetNoCheckButFast(this.modelField);
            Object value2 = obj2.dangerousGetNoCheckButFast(this.modelField);
            if (value == null) {
                return value2 == null ? 0 : 1;
            }
            if (value2 == null) {
                return value == null ? 0 : -1;
            }
            int result = ((Comparable)value).compareTo(value2);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj != null && obj instanceof OrderByComparator) {
                OrderByComparator that = (OrderByComparator)obj;
                return this.field.equals(that.field) && this.descending == that.descending && UtilValidate.areEqual(this.next, that.next);
            }
            return false;
        }
    }
}

