/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.io.Serializable;

public class EntityOperator
implements Serializable {
    public static final int ID_EQUALS = 1;
    public static final int ID_NOT_EQUAL = 2;
    public static final int ID_LESS_THAN = 3;
    public static final int ID_GREATER_THAN = 4;
    public static final int ID_LESS_THAN_EQUAL_TO = 5;
    public static final int ID_GREATER_THAN_EQUAL_TO = 6;
    public static final int ID_IN = 7;
    public static final int ID_BETWEEN = 8;
    public static final int ID_NOT = 9;
    public static final int ID_AND = 10;
    public static final int ID_OR = 11;
    public static final int ID_LIKE = 12;
    public static final EntityOperator EQUALS = new EntityOperator(1, "="){

        @Override
        public boolean compare(Object o1, Object o2) {
            return o1 == null && o2 == null || o1 != null && o1.equals(o2);
        }
    };
    public static final EntityOperator NOT_EQUAL = new EntityOperator(2, "<>"){

        @Override
        public boolean compare(Object o1, Object o2) {
            return !(o1 == null && o2 == null || o1 != null && o1.equals(o2));
        }
    };
    public static final EntityOperator LESS_THAN = new EntityOperator(3, "<"){

        @Override
        public boolean compare(Object o1, Object o2) {
            Comparable c1 = null;
            if (o1 != null && o1 instanceof Comparable) {
                c1 = (Comparable)o1;
                return c1.compareTo(o1) < 0;
            }
            return false;
        }
    };
    public static final EntityOperator GREATER_THAN = new EntityOperator(4, ">"){

        @Override
        public boolean compare(Object o1, Object o2) {
            Comparable c1 = null;
            if (o1 != null && o1 instanceof Comparable) {
                c1 = (Comparable)o1;
            }
            return c1.compareTo(o1) > 0;
        }
    };
    public static final EntityOperator LESS_THAN_EQUAL_TO = new EntityOperator(5, "<="){

        @Override
        public boolean compare(Object o1, Object o2) {
            return !GREATER_THAN.compare(o1, o2);
        }
    };
    public static final EntityOperator GREATER_THAN_EQUAL_TO = new EntityOperator(6, ">="){

        @Override
        public boolean compare(Object o1, Object o2) {
            return !LESS_THAN.compare(o1, o2);
        }
    };
    public static final EntityOperator IN = new EntityOperator(7, "IN");
    public static final EntityOperator BETWEEN = new EntityOperator(8, "BETWEEN");
    public static final EntityOperator NOT = new EntityOperator(9, "NOT");
    public static final EntityOperator AND = new EntityOperator(10, "AND");
    public static final EntityOperator OR = new EntityOperator(11, "OR");
    public static final EntityOperator LIKE = new EntityOperator(12, "LIKE"){

        @Override
        public boolean compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (o2 == null) {
                return false;
            }
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.contains(s2);
        }
    };
    private int idInt;
    private String codeString;

    public EntityOperator(int id, String code) {
        this.idInt = id;
        this.codeString = code;
    }

    public String getCode() {
        if (this.codeString == null) {
            return "null";
        }
        return this.codeString;
    }

    public int getId() {
        return this.idInt;
    }

    public String toString() {
        return this.codeString;
    }

    public boolean compare(Object o1, Object o2) {
        throw new UnsupportedOperationException("This class does not implement compare as is has no meaning out side of sql");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityOperator)) {
            return false;
        }
        EntityOperator otherOper = (EntityOperator)obj;
        return this.idInt == otherOper.getId();
    }
}

