/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import com.google.common.collect.Lists;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.GenericNotImplementedException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.comparator.OFBizFieldComparator;
import org.ofbiz.core.entity.jdbc.ReadOnlySQLProcessor;
import org.ofbiz.core.entity.jdbc.SqlJdbcUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelRelation;

public class MemoryHelper
implements GenericHelper {
    private static Map<String, Map<GenericEntity, GenericValue>> cache = MemoryHelper.getNewCache();
    private String helperName;
    private ModelFieldTypeReader modelFieldTypeReader;

    public static void clearCache() {
        cache = MemoryHelper.getNewCache();
    }

    private static <K, V> Map<K, V> getNewCache() {
        return Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToCache(GenericValue value) {
        if (value == null) {
            return false;
        }
        if (!this.veryifyValue(value)) {
            return false;
        }
        value = (GenericValue)value.clone();
        Map<String, Map<GenericEntity, GenericValue>> map = cache;
        synchronized (map) {
            Map<GenericEntity, GenericValue> entityCache = cache.get(value.getEntityName());
            if (entityCache == null) {
                entityCache = MemoryHelper.getNewCache();
                cache.put(value.getEntityName(), entityCache);
            }
            entityCache.put(value.getPrimaryKey(), value);
        }
        return true;
    }

    private GenericValue findFromCache(GenericPK pk) {
        if (pk == null) {
            return null;
        }
        Map<GenericEntity, GenericValue> entityCache = cache.get(pk.getEntityName());
        if (entityCache == null) {
            return null;
        }
        GenericValue value = entityCache.get(pk);
        if (value == null) {
            return null;
        }
        return (GenericValue)value.clone();
    }

    private int removeFromCache(GenericPK pk) {
        if (pk == null) {
            return 0;
        }
        Map<GenericEntity, GenericValue> entityCache = cache.get(pk.getEntityName());
        if (entityCache == null) {
            return 0;
        }
        GenericValue o = entityCache.remove(pk);
        if (o == null) {
            return 0;
        }
        return 1;
    }

    private boolean isAndMatch(Map<String, ?> values, Map<String, ?> fields) {
        for (Map.Entry<String, ?> mapEntry : fields.entrySet()) {
            if (mapEntry.getValue() == null) {
                if (values.get(mapEntry.getKey()) == null) continue;
                return false;
            }
            try {
                if (mapEntry.getValue().equals(values.get(mapEntry.getKey()))) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean isOrMatch(Map<String, ?> values, Map<String, ?> fields) {
        for (Map.Entry<String, ?> mapEntry : fields.entrySet()) {
            if (mapEntry.getValue() == null) {
                if (values.get(mapEntry.getKey()) != null) continue;
                return true;
            }
            try {
                if (!mapEntry.getValue().equals(values.get(mapEntry.getKey()))) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }

    private boolean veryifyValue(GenericValue value) {
        ModelField field;
        ModelEntity me = value.getModelEntity();
        Iterator<ModelField> iterator = me.getPksIterator();
        while (iterator.hasNext()) {
            field = iterator.next();
            if (value.fields.containsKey(field.getName())) continue;
            return false;
        }
        for (Map.Entry entry : value.fields.entrySet()) {
            if (me.getField((String)entry.getKey()) != null) continue;
            return false;
        }
        iterator = me.getFieldsIterator();
        while (iterator.hasNext()) {
            int typeValue;
            field = iterator.next();
            Object o = value.get(field.getName());
            try {
                typeValue = SqlJdbcUtil.getType(this.modelFieldTypeReader.getModelFieldType(field.getType()).getJavaType());
            }
            catch (GenericNotImplementedException e) {
                return false;
            }
            if (o == null) continue;
            switch (typeValue) {
                case 1: {
                    if (o instanceof String) break;
                    return false;
                }
                case 2: {
                    if (o instanceof Timestamp) break;
                    return false;
                }
                case 3: {
                    if (o instanceof Time) break;
                    return false;
                }
                case 4: {
                    if (o instanceof Date) break;
                    return false;
                }
                case 5: {
                    if (o instanceof Integer) break;
                    return false;
                }
                case 6: {
                    if (o instanceof Long) break;
                    return false;
                }
                case 7: {
                    if (o instanceof Float) break;
                    return false;
                }
                case 8: {
                    if (o instanceof Double) break;
                    return false;
                }
                case 9: {
                    if (o instanceof Boolean) break;
                    return false;
                }
            }
        }
        return true;
    }

    public MemoryHelper(String helperName) {
        this.helperName = helperName;
        this.modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
    }

    @Override
    public String getHelperName() {
        return this.helperName;
    }

    @Override
    public GenericValue create(GenericValue value) throws GenericEntityException {
        if (this.addToCache(value)) {
            return value;
        }
        return null;
    }

    public GenericValue create(GenericPK primaryKey) throws GenericEntityException {
        return this.create(new GenericValue(primaryKey));
    }

    @Override
    public GenericValue findByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        return this.findFromCache(primaryKey);
    }

    @Override
    public GenericValue findByPrimaryKeyPartial(GenericPK primaryKey, Set<String> keys) throws GenericEntityException {
        GenericValue value = this.findFromCache(primaryKey);
        value.setFields(value.getFields(keys));
        return value;
    }

    @Override
    public List<GenericValue> findAllByPrimaryKeys(List<? extends GenericPK> primaryKeys) throws GenericEntityException {
        ArrayList<GenericValue> result = new ArrayList<GenericValue>(primaryKeys.size());
        for (GenericPK genericPK : primaryKeys) {
            result.add(this.findByPrimaryKey(genericPK));
        }
        return result;
    }

    @Override
    public int removeByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        return this.removeFromCache(primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GenericValue> findByAnd(ModelEntity modelEntity, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        Map<GenericEntity, GenericValue> entityCache = cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return Collections.emptyList();
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        Map<GenericEntity, GenericValue> map = entityCache;
        synchronized (map) {
            for (Map.Entry<GenericEntity, GenericValue> mapEntry : entityCache.entrySet()) {
                GenericValue value = mapEntry.getValue();
                if (!this.isAndMatch(value.fields, fields)) continue;
                result.add(value);
            }
        }
        ComparatorChain comp = new ComparatorChain();
        if (orderBy != null) {
            for (String fieldAndOrder : orderBy) {
                StringTokenizer stringTokenizer = new StringTokenizer(fieldAndOrder);
                String field = null;
                String order = null;
                if (stringTokenizer.hasMoreElements()) {
                    field = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreElements()) {
                    order = stringTokenizer.nextToken();
                }
                if (field == null) continue;
                if (order == null || "ASC".equalsIgnoreCase(order)) {
                    comp.addComparator((Comparator)new OFBizFieldComparator(field));
                    continue;
                }
                comp.addComparator((Comparator)new ReverseComparator((Comparator)new OFBizFieldComparator(field)));
            }
            Collections.sort(result, comp);
        }
        return result;
    }

    public List<GenericValue> findByAnd(ModelEntity modelEntity, List<? extends EntityCondition> expressions, List<String> orderBy) throws GenericEntityException {
        return null;
    }

    public List<GenericValue> findByLike(ModelEntity modelEntity, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GenericValue> findByOr(ModelEntity modelEntity, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        Map<GenericEntity, GenericValue> entityCache = cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return Collections.emptyList();
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        Map<GenericEntity, GenericValue> map = entityCache;
        synchronized (map) {
            for (Map.Entry<GenericEntity, GenericValue> mapEntry : entityCache.entrySet()) {
                GenericValue value = mapEntry.getValue();
                if (!this.isOrMatch(value.fields, fields)) continue;
                result.add(value);
            }
        }
        return result;
    }

    public List<GenericValue> findByOr(ModelEntity modelEntity, List<? extends EntityCondition> expressions, List<String> orderBy) throws GenericEntityException {
        return null;
    }

    @Override
    public List<GenericValue> findByCondition(ModelEntity modelEntity, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) throws GenericEntityException {
        Map<GenericEntity, GenericValue> entityCache = cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return Collections.emptyList();
        }
        return this.findByConditionWorker(entityCache, modelEntity, entityCondition, fieldsToSelect, orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GenericValue> findByConditionWorker(Map<GenericEntity, GenericValue> entityCache, ModelEntity modelEntity, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) throws GenericEntityException {
        if (entityCondition instanceof EntityExpr) {
            ArrayList<GenericValue> result = new ArrayList<GenericValue>();
            EntityExpr entityExpr = (EntityExpr)entityCondition;
            Map<GenericEntity, GenericValue> map = entityCache;
            synchronized (map) {
                for (Map.Entry<GenericEntity, GenericValue> mapEntry : entityCache.entrySet()) {
                    GenericValue value = mapEntry.getValue();
                    if (!this.checkEntityExpr(value, entityExpr)) continue;
                    result.add(value);
                }
            }
            return result;
        }
        if (entityCondition instanceof EntityConditionList) {
            EntityConditionList entityConditionList = (EntityConditionList)entityCondition;
            Map<GenericEntity, GenericValue> tempEntityCache = entityCache;
            List<GenericValue> tempResult = new ArrayList<GenericValue>();
            for (int i = 0; i < entityConditionList.getConditionListSize(); ++i) {
                EntityCondition subEntityCondition = entityConditionList.getCondition(i);
                if (EntityOperator.AND.equals(entityConditionList.getOperator())) {
                    tempResult = this.findByConditionWorker(tempEntityCache, modelEntity, subEntityCondition, fieldsToSelect, orderBy);
                    tempEntityCache = new HashMap<GenericEntity, GenericValue>();
                    for (GenericValue genericValue : tempResult) {
                        tempEntityCache.put(genericValue, genericValue);
                    }
                    continue;
                }
                if (!EntityOperator.OR.equals(entityConditionList.getOperator())) continue;
                List<GenericValue> list = this.findByConditionWorker(tempEntityCache, modelEntity, subEntityCondition, fieldsToSelect, orderBy);
                for (GenericValue o : list) {
                    if (tempResult.contains(o)) continue;
                    tempResult.add(o);
                }
            }
            return tempResult;
        }
        if (entityCondition instanceof EntityFieldMap) {
            EntityFieldMap entityCond = (EntityFieldMap)entityCondition;
            if (entityCond.getOperator().equals(EntityOperator.AND)) {
                return this.findByAnd(modelEntity, entityCond.fieldMap, orderBy);
            }
            return this.findByOr(modelEntity, entityCond.fieldMap, orderBy);
        }
        if (entityCondition == null) {
            return new ArrayList<GenericValue>(entityCache.values());
        }
        throw new UnsupportedOperationException("findByCondidition not implemented for expression:" + entityCondition.getClass().getName());
    }

    private boolean checkEntityExpr(GenericValue value, EntityExpr entityExpr) {
        EntityOperator operator = entityExpr.getOperator();
        return operator.compare(value.get(entityExpr.getLhs()), entityExpr.getRhs());
    }

    @Override
    public List<GenericValue> findByMultiRelation(GenericValue value, ModelRelation modelRelationOne, ModelEntity modelEntityOne, ModelRelation modelRelationTwo, ModelEntity modelEntityTwo, List<String> orderBy) throws GenericEntityException {
        return null;
    }

    @Override
    public EntityListIterator findListIteratorByCondition(ModelEntity modelEntity, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, Collection<String> fieldsToSelect, List<String> orderBy, EntityFindOptions findOptions) throws GenericEntityException {
        final Iterator<GenericValue> entities = new ArrayList<GenericValue>(this.findByCondition(modelEntity, whereEntityCondition, fieldsToSelect, orderBy)).iterator();
        return new EntityListIterator(new ReadOnlySQLProcessor(null), modelEntity, null, this.modelFieldTypeReader){

            @Override
            public GenericValue next() {
                if (entities.hasNext()) {
                    return (GenericValue)entities.next();
                }
                return null;
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public int removeByAnd(ModelEntity modelEntity, Map<String, ?> fields) throws GenericEntityException {
        Map<GenericEntity, GenericValue> entityCache = cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return 0;
        }
        ArrayList<GenericEntity> removeList = new ArrayList<GenericEntity>();
        for (Map.Entry<GenericEntity, GenericValue> mapEntry : entityCache.entrySet()) {
            GenericValue value = mapEntry.getValue();
            if (!this.isAndMatch(value.fields, fields)) continue;
            removeList.add(mapEntry.getKey());
        }
        return this.removeAll(removeList);
    }

    @Override
    public int removeByCondition(ModelEntity modelEntity, EntityCondition whereCondition) throws GenericEntityException {
        Map<GenericEntity, GenericValue> entityCache = cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return 0;
        }
        List<GenericValue> foundValues = this.findByCondition(modelEntity, whereCondition, null, null);
        return this.removeAll(foundValues);
    }

    @Override
    public int store(GenericValue value) throws GenericEntityException {
        if (this.addToCache(value)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int storeAll(List<? extends GenericValue> values) throws GenericEntityException {
        int count = 0;
        for (GenericValue genericValue : values) {
            if (!this.addToCache(genericValue)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int removeAll(List<? extends GenericEntity> dummyPKs) throws GenericEntityException {
        int count = 0;
        for (GenericEntity genericEntity : dummyPKs) {
            if (genericEntity instanceof GenericPK) {
                count += this.removeFromCache((GenericPK)genericEntity);
                continue;
            }
            HashMap<String, Object> pkFields = new HashMap<String, Object>();
            List<String> pkFieldNames = genericEntity.getModelEntity().getPkFieldNames();
            for (String pkFieldName : pkFieldNames) {
                pkFields.put(pkFieldName, genericEntity.get(pkFieldName));
            }
            GenericPK pk = new GenericPK(genericEntity.getModelEntity(), pkFields);
            count += this.removeFromCache(pk);
        }
        return count;
    }

    @Override
    public void checkDataSource(Map<String, ? extends ModelEntity> modelEntities, Collection<String> messages, boolean addMissing) throws GenericEntityException {
    }

    @Override
    public int count(ModelEntity modelEntity, String fieldName, EntityCondition entityCondition, EntityFindOptions findOptions) throws GenericEntityException {
        Map<GenericEntity, GenericValue> entityCache = cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return 0;
        }
        List<GenericValue> genericValues = this.findByCondition(modelEntity, entityCondition, Lists.newArrayList((Object[])new String[]{fieldName}), null);
        return genericValues.size();
    }
}

