/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.jdbc.SqlJdbcUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilValidate;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModelViewEntity
extends ModelEntity {
    public static final String module = ModelViewEntity.class.getName();
    protected Map<String, ModelMemberEntity> memberModelMemberEntities = new HashMap<String, ModelMemberEntity>();
    protected List<ModelMemberEntity> allModelMemberEntities = new LinkedList<ModelMemberEntity>();
    protected Map<String, ModelEntity> memberModelEntities = null;
    protected List<ModelAlias> aliases = new ArrayList<ModelAlias>();
    protected List<ModelViewLink> viewLinks = new ArrayList<ModelViewLink>();
    protected List<ModelField> groupBys = new ArrayList<ModelField>();

    public ModelViewEntity(ModelReader reader, Element entityElement, Element docElement, UtilTimer utilTimer, Hashtable<String, String> docElementValues) {
        this.modelReader = reader;
        if (utilTimer != null) {
            utilTimer.timerString("  createModelViewEntity: before general/basic info");
        }
        this.populateBasicInfo(entityElement, docElement, docElementValues);
        if (utilTimer != null) {
            utilTimer.timerString("  createModelViewEntity: before \"member-entity\"s");
        }
        NodeList membEntList = entityElement.getElementsByTagName("member-entity");
        for (int i = 0; i < membEntList.getLength(); ++i) {
            Element membEnt = (Element)membEntList.item(i);
            String alias = UtilXml.checkEmpty((String)membEnt.getAttribute("entity-alias"));
            String name = UtilXml.checkEmpty((String)membEnt.getAttribute("entity-name"));
            if (name.length() <= 0 || alias.length() <= 0) {
                Debug.logError((String)("[new ModelViewEntity] entity-alias or entity-name missing on member-entity element of the view-entity " + this.entityName), (String)module);
                continue;
            }
            ModelMemberEntity modelMemberEntity = new ModelMemberEntity(alias, name);
            this.addMemberModelMemberEntity(modelMemberEntity);
        }
        if (utilTimer != null) {
            utilTimer.timerString("  createModelViewEntity: before aliases");
        }
        NodeList aliasList = entityElement.getElementsByTagName("alias");
        for (int i = 0; i < aliasList.getLength(); ++i) {
            Element aliasElement = (Element)aliasList.item(i);
            ModelAlias alias = new ModelAlias(aliasElement);
            this.aliases.add(alias);
        }
        NodeList viewLinkList = entityElement.getElementsByTagName("view-link");
        for (int i = 0; i < viewLinkList.getLength(); ++i) {
            Element viewLinkElement = (Element)viewLinkList.item(i);
            ModelViewLink viewLink = new ModelViewLink(viewLinkElement);
            this.addViewLink(viewLink);
        }
        if (utilTimer != null) {
            utilTimer.timerString("  createModelEntity: before relations");
        }
        this.populateRelated(reader, entityElement);
        this.tableName = null;
    }

    public Map<String, ModelMemberEntity> getMemberModelMemberEntities() {
        return this.memberModelMemberEntities;
    }

    public List<ModelMemberEntity> getAllModelMemberEntities() {
        return this.allModelMemberEntities;
    }

    public ModelMemberEntity getMemberModelMemberEntity(String alias) {
        return this.memberModelMemberEntities.get(alias);
    }

    public ModelEntity getMemberModelEntity(String alias) {
        if (this.memberModelEntities == null) {
            this.memberModelEntities = new HashMap<String, ModelEntity>();
            this.populateFields(this.getModelReader().entityCache);
        }
        return this.memberModelEntities.get(alias);
    }

    public void addMemberModelMemberEntity(ModelMemberEntity modelMemberEntity) {
        this.memberModelMemberEntities.put(modelMemberEntity.getEntityAlias(), modelMemberEntity);
        this.allModelMemberEntities.add(modelMemberEntity);
    }

    public void removeMemberModelMemberEntity(String alias) {
        ModelMemberEntity modelMemberEntity = this.memberModelMemberEntities.remove(alias);
        if (modelMemberEntity == null) {
            return;
        }
        this.allModelMemberEntities.remove(modelMemberEntity);
    }

    public ModelAlias getAlias(int index) {
        return this.aliases.get(index);
    }

    public int getAliasesSize() {
        return this.aliases.size();
    }

    public Iterator<ModelAlias> getAliasesIterator() {
        return this.aliases.iterator();
    }

    public List<ModelAlias> getAliasesCopy() {
        return new ArrayList<ModelAlias>(this.aliases);
    }

    public List<ModelField> getGroupBysCopy() {
        return new ArrayList<ModelField>(this.groupBys);
    }

    public ModelViewLink getViewLink(int index) {
        return this.viewLinks.get(index);
    }

    public int getViewLinksSize() {
        return this.viewLinks.size();
    }

    public Iterator<ModelViewLink> getViewLinksIterator() {
        return this.viewLinks.iterator();
    }

    public List<ModelViewLink> getViewLinksCopy() {
        return new ArrayList<ModelViewLink>(this.viewLinks);
    }

    public void addViewLink(ModelViewLink viewLink) {
        this.viewLinks.add(viewLink);
    }

    public void populateFields(Map<String, ModelEntity> entityCache) {
        ModelEntity aliasedEntity;
        String aliasedEntityName;
        ModelMemberEntity modelMemberEntity;
        if (this.memberModelEntities == null) {
            this.memberModelEntities = new HashMap<String, ModelEntity>();
        }
        for (Map.Entry<String, ModelMemberEntity> entry : this.memberModelMemberEntities.entrySet()) {
            modelMemberEntity = entry.getValue();
            aliasedEntityName = modelMemberEntity.getEntityName();
            aliasedEntity = entityCache.get(aliasedEntityName);
            if (aliasedEntity == null) {
                Debug.logError((String)("[ModelViewEntity.populateFields] ERROR: could not find ModelEntity for entity name: " + aliasedEntityName));
                continue;
            }
            this.memberModelEntities.put(entry.getKey(), aliasedEntity);
        }
        for (ModelAlias alias : this.aliases) {
            modelMemberEntity = this.memberModelMemberEntities.get(alias.entityAlias);
            if (modelMemberEntity == null) {
                Debug.logError((String)("No member entity with alias " + alias.entityAlias + " found in view-entity " + this.getEntityName() + "; this view-entity will NOT be usable..."));
            }
            if ((aliasedEntity = entityCache.get(aliasedEntityName = modelMemberEntity.getEntityName())) == null) {
                Debug.logError((String)("[ModelViewEntity.populateFields] ERROR: could not find ModelEntity for entity name: " + aliasedEntityName));
                continue;
            }
            ModelField aliasedField = aliasedEntity.getField(alias.field);
            if (aliasedField == null) {
                Debug.logError((String)("[ModelViewEntity.populateFields] ERROR: could not find ModelField for field name \"" + alias.field + "\" on entity with name: " + aliasedEntityName));
                continue;
            }
            ModelField field = new ModelField();
            field.name = alias.name;
            field.isPk = alias.isPk != null ? alias.isPk : aliasedField.isPk;
            this.fields.add(field);
            this.fieldsMap.put(field.name, field);
            if (field.isPk) {
                this.pks.add(field);
            } else {
                this.nopks.add(field);
            }
            if (alias.groupBy) {
                this.groupBys.add(field);
            }
            if (UtilValidate.isNotEmpty((String)alias.function) && alias.groupBy) {
                Debug.logWarning((String)("The view-entity alias with name=" + alias.name + " has a function value and is specified as a group-by field; this may be an error, but is not necessarily."));
            }
            field.type = "count".equals(alias.function) || "count-distinct".equals(alias.function) ? "numeric" : aliasedField.type;
            if (UtilValidate.isNotEmpty((String)alias.function)) {
                if ("min".equals(alias.function)) {
                    field.colName = "MIN(" + alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName) + ")";
                } else if ("max".equals(alias.function)) {
                    field.colName = "MAX(" + alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName) + ")";
                } else if ("sum".equals(alias.function)) {
                    field.colName = "SUM(" + alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName) + ")";
                } else if ("avg".equals(alias.function)) {
                    field.colName = "AVG(" + alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName) + ")";
                } else if ("count".equals(alias.function)) {
                    field.colName = "COUNT(" + alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName) + ")";
                } else if ("count-distinct".equals(alias.function)) {
                    field.colName = "COUNT(DISTINCT " + alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName) + ")";
                } else if ("upper".equals(alias.function)) {
                    field.colName = "UPPER(" + alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName) + ")";
                } else if ("lower".equals(alias.function)) {
                    field.colName = "LOWER(" + alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName) + ")";
                } else {
                    Debug.logWarning((String)("Specified alias function [" + alias.function + "] not valid; must be: min, max, sum, avg, count or count-distinct; using a column name with no function function"));
                    field.colName = alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName);
                }
            } else {
                field.colName = alias.entityAlias + "." + SqlJdbcUtil.filterColName(aliasedField.colName);
            }
            field.validators = aliasedField.validators;
        }
    }

    public static class ModelViewLink {
        protected String entityAlias = "";
        protected String relEntityAlias = "";
        protected boolean relOptional = false;
        protected List<ModelKeyMap> keyMaps = new ArrayList<ModelKeyMap>();

        protected ModelViewLink() {
        }

        public ModelViewLink(Element viewLinkElement) {
            this.entityAlias = UtilXml.checkEmpty((String)viewLinkElement.getAttribute("entity-alias"));
            this.relEntityAlias = UtilXml.checkEmpty((String)viewLinkElement.getAttribute("rel-entity-alias"));
            this.relOptional = "true".equals(viewLinkElement.getAttribute("rel-optional"));
            NodeList keyMapList = viewLinkElement.getElementsByTagName("key-map");
            for (int j = 0; j < keyMapList.getLength(); ++j) {
                Element keyMapElement = (Element)keyMapList.item(j);
                ModelKeyMap keyMap = new ModelKeyMap(keyMapElement);
                if (keyMap == null) continue;
                this.keyMaps.add(keyMap);
            }
        }

        public ModelViewLink(String entityAlias, String relEntityAlias, List<? extends ModelKeyMap> keyMaps) {
            this.entityAlias = entityAlias;
            this.relEntityAlias = relEntityAlias;
            this.keyMaps.addAll(keyMaps);
        }

        public String getEntityAlias() {
            return this.entityAlias;
        }

        public String getRelEntityAlias() {
            return this.relEntityAlias;
        }

        public boolean isRelOptional() {
            return this.relOptional;
        }

        public ModelKeyMap getKeyMap(int index) {
            return this.keyMaps.get(index);
        }

        public int getKeyMapsSize() {
            return this.keyMaps.size();
        }

        public Iterator<ModelKeyMap> getKeyMapsIterator() {
            return this.keyMaps.iterator();
        }

        public List<ModelKeyMap> getKeyMapsCopy() {
            return new ArrayList<ModelKeyMap>(this.keyMaps);
        }
    }

    public static class ModelAlias {
        protected String entityAlias = "";
        protected String name = "";
        protected String field = "";
        protected Boolean isPk = null;
        protected boolean groupBy = false;
        protected String function = null;

        protected ModelAlias() {
        }

        public ModelAlias(Element aliasElement) {
            this.entityAlias = UtilXml.checkEmpty((String)aliasElement.getAttribute("entity-alias"));
            this.name = UtilXml.checkEmpty((String)aliasElement.getAttribute("name"));
            this.field = UtilXml.checkEmpty((String)aliasElement.getAttribute("field"), (String)this.name);
            String primKeyValue = UtilXml.checkEmpty((String)aliasElement.getAttribute("prim-key"));
            this.isPk = UtilValidate.isNotEmpty((String)primKeyValue) ? Boolean.valueOf("true".equals(primKeyValue)) : null;
            this.groupBy = "true".equals(UtilXml.checkEmpty((String)aliasElement.getAttribute("group-by")));
            this.function = UtilXml.checkEmpty((String)aliasElement.getAttribute("function"));
        }

        public ModelAlias(String entityAlias, String name, String field, Boolean isPk, boolean groupBy, String function) {
            this.entityAlias = entityAlias;
            this.name = name;
            this.field = field;
            this.isPk = isPk;
            this.groupBy = groupBy;
            this.function = function;
        }

        public String getEntityAlias() {
            return this.entityAlias;
        }

        public String getName() {
            return this.name;
        }

        public String getField() {
            return this.field;
        }

        public Boolean getIsPk() {
            return this.isPk;
        }

        public boolean getGroupBy() {
            return this.groupBy;
        }

        public String getFunction() {
            return this.function;
        }
    }

    public static class ModelMemberEntity {
        protected String entityAlias = "";
        protected String entityName = "";

        public ModelMemberEntity(String entityAlias, String entityName) {
            this.entityAlias = entityAlias;
            this.entityName = entityName;
        }

        public String getEntityAlias() {
            return this.entityAlias;
        }

        public String getEntityName() {
            return this.entityName;
        }
    }
}

