/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.ConnectionProvider;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;
import org.ofbiz.core.entity.jdbc.dbtype.Oracle10GDatabaseType;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelIndex;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilValidate;

public class DatabaseUtil {
    public static final String module = DatabaseUtil.class.getName();
    private static final Multimap<String, String> allowedFieldTypePromotions = ImmutableMultimap.builder().put((Object)"VARCHAR", (Object)"NVARCHAR").put((Object)"VARCHAR2", (Object)"NVARCHAR2").build();
    protected String helperName;
    protected ModelFieldTypeReader modelFieldTypeReader;
    protected DatasourceInfo datasourceInfo;
    private final ConnectionProvider connectionProvider;

    public DatabaseUtil(String helperName) {
        this.helperName = helperName;
        this.modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
        this.datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        this.connectionProvider = ConnectionFactory.provider;
    }

    DatabaseUtil(String helperName, ModelFieldTypeReader modelFieldTypeReader, DatasourceInfo datasourceInfo, ConnectionProvider connectionProvider) {
        this.helperName = helperName;
        this.modelFieldTypeReader = modelFieldTypeReader;
        this.datasourceInfo = datasourceInfo;
        this.connectionProvider = connectionProvider;
    }

    public Connection getConnection() throws SQLException, GenericEntityException {
        return this.connectionProvider.getConnection(this.helperName);
    }

    public void checkDb(Map<String, ? extends ModelEntity> modelEntities, Collection<String> messages, boolean addMissing) {
        this.checkDb(modelEntities, messages, addMissing, addMissing, addMissing);
    }

    public void checkDb(Map<String, ? extends ModelEntity> modelEntities, Collection<String> messages, boolean addMissing, boolean promote, boolean widen) {
        ModelRelation modelRelation;
        String entityName;
        String indErrMsg;
        String errMsg;
        UtilTimer timer = new UtilTimer();
        timer.timerString("Start - Before Get Database metadata");
        TreeSet<String> tableNames = this.getTableNames(messages);
        TreeSet<String> fkTableNames = tableNames == null ? null : new TreeSet<String>((SortedSet<String>)tableNames);
        TreeSet<String> indexTableNames = tableNames == null ? null : new TreeSet<String>((SortedSet<String>)tableNames);
        HashMap<String, ModelEntity> existingTableEntities = new HashMap<String, ModelEntity>();
        if (tableNames == null) {
            this.error("Could not get table name information from the database, aborting.", messages);
            return;
        }
        timer.timerString("After Get All Table Names");
        Map<String, List<ColumnCheckInfo>> colInfo = this.getColumnInfo(tableNames, messages);
        if (colInfo == null) {
            this.error("Could not get column information from the database, aborting.", messages);
            return;
        }
        timer.timerString("After Get All Column Info");
        timer.timerString("Before Individual Table/Column Check");
        ArrayList<? extends ModelEntity> modelEntityList = new ArrayList<ModelEntity>(modelEntities.values());
        Collections.sort(modelEntityList);
        Iterator<? extends ModelEntity> modelEntityIter = modelEntityList.iterator();
        int curEnt = 0;
        int totalEnt = modelEntityList.size();
        LinkedList<ModelEntity> entitiesAdded = new LinkedList<ModelEntity>();
        while (modelEntityIter.hasNext()) {
            ++curEnt;
            ModelEntity entity = modelEntityIter.next();
            String entityName2 = entity.getEntityName();
            if (entity instanceof ModelViewEntity) {
                this.verbose("(" + timer.timeSinceLast() + "ms) NOT Checking #" + curEnt + "/" + totalEnt + " View Entity " + entityName2, messages);
                continue;
            }
            String tableName = entity.getTableName(this.datasourceInfo);
            String entMessage = "(" + timer.timeSinceLast() + "ms) Checking #" + curEnt + "/" + totalEnt + " Entity " + entityName2 + " with table " + tableName;
            this.verbose(entMessage, messages);
            String string = tableName.toUpperCase();
            if (tableNames.contains(string)) {
                int numCols;
                tableNames.remove(string);
                existingTableEntities.put(entity.getPlainTableName(), entity);
                if (colInfo == null) continue;
                HashMap<String, ModelField> fieldColNames = new HashMap<String, ModelField>();
                for (int fnum = 0; fnum < entity.getFieldsSize(); ++fnum) {
                    ModelField field = entity.getField(fnum);
                    fieldColNames.put(field.getColName().toUpperCase(), field);
                }
                List<ColumnCheckInfo> colList = colInfo.get(string);
                if (colList != null) {
                    for (numCols = 0; numCols < colList.size(); ++numCols) {
                        ColumnCheckInfo ccInfo = colList.get(numCols);
                        if (fieldColNames.containsKey(ccInfo.columnName)) {
                            ModelField field = (ModelField)fieldColNames.remove(ccInfo.columnName);
                            this.checkFieldType(entity, field, ccInfo, messages, promote, widen);
                            continue;
                        }
                        this.warn("Column \"" + ccInfo.columnName + "\" of table \"" + tableName + "\" of entity \"" + entityName2 + "\" exists in the database but has no corresponding field", messages);
                    }
                }
                if (numCols != entity.getFieldsSize()) {
                    String message = "Entity \"" + entityName2 + "\" has " + entity.getFieldsSize() + " fields but table \"" + tableName + "\" has " + numCols + " columns.";
                    this.warn(message, messages);
                }
                for (String s : fieldColNames.keySet()) {
                    ModelField field = (ModelField)fieldColNames.get(s);
                    this.warn("Field \"" + field.getName() + "\" of entity \"" + entityName2 + "\" is missing its corresponding column \"" + field.getColName() + "\"", messages);
                    if (!addMissing) continue;
                    errMsg = this.addColumn(entity, field);
                    if (errMsg != null && errMsg.length() > 0) {
                        this.error("Could not add column \"" + field.getColName() + "\" to table \"" + tableName + "\"", messages);
                        this.error(errMsg, messages);
                        continue;
                    }
                    this.important("Added column \"" + field.getColName() + "\" to table \"" + tableName + "\"", messages);
                }
                continue;
            }
            this.warn("Entity \"" + entityName2 + "\" has no table in the database", messages);
            if (!addMissing) continue;
            String errMsg2 = this.createTable(entity, modelEntities, false, this.datasourceInfo.isUsePkConstraintNames(), this.datasourceInfo.getConstraintNameClipLength(), this.datasourceInfo.getFkStyle(), this.datasourceInfo.isUseFkInitiallyDeferred());
            if (errMsg2 != null && errMsg2.length() > 0) {
                this.error("Could not create table \"" + tableName + "\"", messages);
                this.error(errMsg2, messages);
                continue;
            }
            entitiesAdded.add(entity);
            this.important("Created table \"" + tableName + "\"", messages);
        }
        timer.timerString("After Individual Table/Column Check");
        Iterator<String> tableNamesIter = tableNames.iterator();
        while (tableNamesIter != null && tableNamesIter.hasNext()) {
            String tableName = tableNamesIter.next();
            this.verbose("Table named \"" + tableName + "\" exists in the database but has no corresponding entity", messages);
        }
        if (this.datasourceInfo.isUseFks()) {
            for (ModelEntity curEntity : entitiesAdded) {
                String errMsg3 = this.createForeignKeys(curEntity, modelEntities, this.datasourceInfo.getConstraintNameClipLength(), this.datasourceInfo.getFkStyle(), this.datasourceInfo.isUseFkInitiallyDeferred());
                if (errMsg3 != null && errMsg3.length() > 0) {
                    this.error("Could not create foreign keys for entity \"" + curEntity.getEntityName() + "\"", messages);
                    this.error(errMsg3, messages);
                    continue;
                }
                this.important("Created foreign keys for entity \"" + curEntity.getEntityName() + "\"", messages);
            }
        }
        if (this.datasourceInfo.isUseFkIndices()) {
            for (ModelEntity curEntity : entitiesAdded) {
                indErrMsg = this.createForeignKeyIndices(curEntity, this.datasourceInfo.getConstraintNameClipLength());
                if (indErrMsg != null && indErrMsg.length() > 0) {
                    this.error("Could not create foreign key indices for entity \"" + curEntity.getEntityName() + "\"", messages);
                    this.error(indErrMsg, messages);
                    continue;
                }
                this.important("Created foreign key indices for entity \"" + curEntity.getEntityName() + "\"", messages);
            }
        }
        if (this.datasourceInfo.isUseIndices()) {
            for (ModelEntity curEntity : entitiesAdded) {
                indErrMsg = this.createDeclaredIndices(curEntity);
                if (indErrMsg != null && indErrMsg.length() > 0) {
                    this.error("Could not create declared indices for entity \"" + curEntity.getEntityName() + "\"", messages);
                    this.error(indErrMsg, messages);
                    continue;
                }
                this.important("Created declared indices for entity \"" + curEntity.getEntityName() + "\"", messages);
            }
            this.createMissingIndices(existingTableEntities, messages);
        }
        if (this.datasourceInfo.isUseFks() && this.datasourceInfo.isCheckForeignKeysOnStart()) {
            int numFksCreated = 0;
            Map<String, Map<String, ReferenceCheckInfo>> refTableInfoMap = this.getReferenceInfo(fkTableNames, messages);
            if (refTableInfoMap != null) {
                for (ModelEntity modelEntity : modelEntityList) {
                    entityName = modelEntity.getEntityName();
                    if (modelEntity instanceof ModelViewEntity) {
                        this.verbose("NOT Checking View Entity " + modelEntity.getEntityName(), messages);
                        continue;
                    }
                    Map<String, ReferenceCheckInfo> rcInfoMap = refTableInfoMap.get(modelEntity.getTableName(this.datasourceInfo));
                    Iterator<ModelRelation> relations = modelEntity.getRelationsIterator();
                    boolean createdConstraints = false;
                    while (relations.hasNext()) {
                        String errMsg4;
                        modelRelation = relations.next();
                        if (!"one".equals(modelRelation.getType())) continue;
                        ModelEntity relModelEntity = modelEntities.get(modelRelation.getRelEntityName());
                        String relConstraintName = this.makeFkConstraintName(modelRelation, this.datasourceInfo.getConstraintNameClipLength());
                        ReferenceCheckInfo rcInfo = null;
                        if (rcInfoMap != null) {
                            rcInfo = rcInfoMap.get(relConstraintName);
                        }
                        if (rcInfo != null) {
                            rcInfoMap.remove(relConstraintName);
                            continue;
                        }
                        if (Debug.verboseOn()) {
                            Debug.logVerbose((String)("No Foreign Key Constraint " + relConstraintName + " found in entity " + entityName));
                        }
                        if ((errMsg4 = this.createForeignKey(modelEntity, modelRelation, relModelEntity, this.datasourceInfo.getConstraintNameClipLength(), this.datasourceInfo.getFkStyle(), this.datasourceInfo.isUseFkInitiallyDeferred())) != null && errMsg4.length() > 0) {
                            this.error("Could not create foreign key " + relConstraintName + " for entity \"" + modelEntity.getEntityName() + "\"", messages);
                            this.error(errMsg4, messages);
                            continue;
                        }
                        this.verbose("Created foreign key " + relConstraintName + " for entity \"" + modelEntity.getEntityName() + "\"", messages);
                        createdConstraints = true;
                        ++numFksCreated;
                    }
                    if (createdConstraints) {
                        this.important("Created foreign key(s) for entity \"" + modelEntity.getEntityName() + "\"", messages);
                    }
                    if (rcInfoMap == null) continue;
                    for (String rcKeyLeft : rcInfoMap.keySet()) {
                        Debug.logImportant((String)("Unknown Foreign Key Constraint " + rcKeyLeft + " found in table " + modelEntity.getTableName(this.datasourceInfo)));
                    }
                }
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Created " + numFksCreated + " fk refs"));
            }
        }
        if (this.datasourceInfo.isUseFkIndices() && this.datasourceInfo.isCheckFkIndicesOnStart()) {
            int numIndicesCreated = 0;
            Map<String, Set<String>> tableIndexListMap = this.getIndexInfo(indexTableNames, messages);
            if (tableIndexListMap != null) {
                for (ModelEntity modelEntity : modelEntityList) {
                    entityName = modelEntity.getEntityName();
                    if (modelEntity instanceof ModelViewEntity) {
                        this.verbose("NOT Checking View Entity " + modelEntity.getEntityName(), messages);
                        continue;
                    }
                    Set<String> tableIndexList = tableIndexListMap.get(modelEntity.getTableName(this.datasourceInfo));
                    if (tableIndexList == null) {
                        String message;
                        String indErrMsg2 = this.createForeignKeyIndices(modelEntity, this.datasourceInfo.getConstraintNameClipLength());
                        if (indErrMsg2 != null && indErrMsg2.length() > 0) {
                            message = "Could not create foreign key indices for entity \"" + modelEntity.getEntityName() + "\"";
                            this.error(message, messages);
                            this.error(indErrMsg2, messages);
                        } else {
                            message = "Created foreign key indices for entity \"" + modelEntity.getEntityName() + "\"";
                            this.important(message, messages);
                        }
                    } else {
                        boolean createdConstraints = false;
                        Iterator<ModelRelation> relations = modelEntity.getRelationsIterator();
                        while (relations.hasNext()) {
                            String message;
                            modelRelation = relations.next();
                            if (!"one".equals(modelRelation.getType())) continue;
                            String relConstraintName = this.makeFkConstraintName(modelRelation, this.datasourceInfo.getConstraintNameClipLength());
                            if (tableIndexList.contains(relConstraintName)) {
                                tableIndexList.remove(relConstraintName);
                                continue;
                            }
                            if (Debug.verboseOn()) {
                                Debug.logVerbose((String)("No Index " + relConstraintName + " found for entity " + entityName));
                            }
                            if ((errMsg = this.createForeignKeyIndex(modelEntity, modelRelation, this.datasourceInfo.getConstraintNameClipLength())) != null && errMsg.length() > 0) {
                                message = "Could not create foreign key index " + relConstraintName + " for entity \"" + modelEntity.getEntityName() + "\"";
                                this.error(message, messages);
                                this.error(errMsg, messages);
                                continue;
                            }
                            message = "Created foreign key index " + relConstraintName + " for entity \"" + modelEntity.getEntityName() + "\"";
                            this.verbose(message, messages);
                            createdConstraints = true;
                            ++numIndicesCreated;
                        }
                        if (createdConstraints) {
                            this.important("Created foreign key index/indices for entity \"" + modelEntity.getEntityName() + "\"", messages);
                        }
                    }
                    if (tableIndexList == null) continue;
                    for (String indexLeft : tableIndexList) {
                        Debug.logImportant((String)("Unknown Index " + indexLeft + " found in table " + modelEntity.getTableName(this.datasourceInfo)));
                    }
                }
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Created " + numIndicesCreated + " indices"));
            }
        }
        timer.timerString("Finished Checking Entity Database");
    }

    void checkFieldType(ModelEntity entity, ModelField field, ColumnCheckInfo ccInfo, Collection<String> messages, boolean promote, boolean widen) {
        String fieldType = field.getType();
        ModelFieldType modelFieldType = this.modelFieldTypeReader.getModelFieldType(fieldType);
        if (modelFieldType != null) {
            ColumnTypeParser parsedColumnType = new ColumnTypeParser(entity, ccInfo, messages, modelFieldType).invoke();
            String typeName = parsedColumnType.getTypeName();
            int decimalDigits = parsedColumnType.getDecimalDigits();
            String fullTypeStr = parsedColumnType.getFullTypeStr();
            if (!ccInfo.typeName.equals(typeName.toUpperCase())) {
                Collection allowedPromotions = allowedFieldTypePromotions.get((Object)ccInfo.typeName);
                if (promote && allowedPromotions != null && allowedPromotions.contains(typeName.toUpperCase()) && decimalDigits == -1) {
                    String errorMessage = this.modifyColumnType(entity, field);
                    if (errorMessage == null) {
                        String message = "Column \"" + ccInfo.columnName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" is of wrong type and has been promoted from \"" + ccInfo.typeAsString() + "\" to \"" + fullTypeStr + "\".";
                        this.important(message, messages);
                    } else {
                        this.error("Could not promote column \"" + ccInfo.columnName + "\" in table \"" + entity.getTableName(this.datasourceInfo) + "\" from type: \"" + ccInfo.typeAsString() + "\" to type: \"" + fullTypeStr + "\".", messages);
                        this.error(errorMessage, messages);
                    }
                } else {
                    String message = "WARNING: Column \"" + ccInfo.columnName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" is of type \"" + ccInfo.typeAsString() + "\" in the database, but is defined as type \"" + fullTypeStr + "\" in the entity definition.";
                    this.error(message, messages);
                }
            } else {
                String message;
                if (this.isTypeChangeNeeded(parsedColumnType)) {
                    if (this.isTypeChangeAllowed(parsedColumnType, widen)) {
                        String errorMessage = this.modifyColumnType(entity, field);
                        if (errorMessage == null) {
                            String message2 = "Column \"" + ccInfo.columnName + "\" of type \"" + typeName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" has different type definition and has been changed from " + ccInfo.typeAsString() + " to " + fullTypeStr + ".";
                            this.important(message2, messages);
                        } else {
                            this.error("Could not widen column \"" + ccInfo.columnName + "\" in table \"" + entity.getTableName(this.datasourceInfo) + "\" to size: " + fullTypeStr + ".", messages);
                            this.error(errorMessage, messages);
                        }
                    } else {
                        message = "WARNING: Column \"" + ccInfo.columnName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" has a column size of \"" + ccInfo.typeAsString() + "\" in the database, but is defined to have a column size of \"" + fullTypeStr + "\" in the entity definition.";
                        this.warn(message, messages);
                    }
                }
                if (decimalDigits != -1 && decimalDigits != ccInfo.decimalDigits) {
                    message = "WARNING: Column \"" + ccInfo.columnName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" has a decimalDigits of \"" + ccInfo.decimalDigits + "\" in the database, but is defined to have a decimalDigits of \"" + decimalDigits + "\" in the entity definition.";
                    this.warn(message, messages);
                }
            }
        } else {
            String message = "Column \"" + ccInfo.columnName + "\" of table \"" + entity.getTableName(this.datasourceInfo) + "\" of entity \"" + entity.getEntityName() + "\" has a field type name of \"" + fieldType + "\" which is not found in the field type definitions";
            this.error(message, messages);
        }
    }

    private boolean isTypeChangeAllowed(ColumnTypeParser type, boolean widen) {
        boolean oracleUnicodeWidening = type.isOracle && Oracle10GDatabaseType.detectUnicodeWidening(type.typeName, type.ccInfo, type.typeNameExtension);
        return widen && type.decimalDigits == -1 && (type.columnSize > ((ColumnTypeParser)type).ccInfo.columnSize || oracleUnicodeWidening);
    }

    private boolean isTypeChangeNeeded(ColumnTypeParser type) {
        boolean ret;
        boolean bl = ret = type.columnSize != -1 && ((ColumnTypeParser)type).ccInfo.columnSize != -1 && type.columnSize != ((ColumnTypeParser)type).ccInfo.columnSize;
        if (ret || !type.isOracle) {
            return ret;
        }
        boolean oracleUnicodeWidening = Oracle10GDatabaseType.detectUnicodeWidening(type.typeName, type.ccInfo, type.typeNameExtension);
        boolean columnWithOracleUnicode = Oracle10GDatabaseType.detectUnicodeExtension(type.ccInfo);
        return ret | oracleUnicodeWidening || columnWithOracleUnicode && !"CHAR".equals(type.typeNameExtension);
    }

    /*
     * Exception decompiling
     */
    private String modifyColumnType(ModelEntity entity, ModelField field) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void createMissingIndices(Map<String, ModelEntity> tableToModelEntities, Collection<String> messages) {
        Map<String, Set<String>> indexInfo = this.getIndexInfo(tableToModelEntities.keySet(), messages, true);
        for (Map.Entry<String, Set<String>> indexInfoEntry : indexInfo.entrySet()) {
            String tableName = indexInfoEntry.getKey();
            Set<String> actualIndexes = indexInfoEntry.getValue();
            ModelEntity modelEntity = tableToModelEntities.get(tableName);
            Iterator<ModelIndex> indexesIterator = modelEntity.getIndexesIterator();
            StringBuilder retMsgsBuffer = new StringBuilder();
            while (indexesIterator.hasNext()) {
                String retMsg;
                ModelIndex modelIndex = indexesIterator.next();
                if (actualIndexes.contains(modelIndex.getName().toUpperCase())) continue;
                if (Debug.infoOn()) {
                    Debug.logInfo((String)("Missing index '" + modelIndex.getName() + "' on existing table '" + tableName + "' ...creating"));
                }
                if ((retMsg = this.createDeclaredIndex(modelEntity, modelIndex)) == null || retMsg.length() <= 0) continue;
                if (retMsgsBuffer.length() > 0) {
                    retMsgsBuffer.append("\n");
                }
                retMsgsBuffer.append(retMsg);
            }
            if (retMsgsBuffer.length() <= 0) continue;
            this.error("Could not create missing indices for entity \"" + modelEntity.getEntityName() + "\"", messages);
            this.error(retMsgsBuffer.toString(), messages);
        }
    }

    public List<ModelEntity> induceModelFromDb(Collection<String> messages) {
        TreeSet<String> tableNames = this.getTableNames(messages);
        Map<String, List<ColumnCheckInfo>> colInfo = this.getColumnInfo(tableNames, messages);
        LinkedList<ModelEntity> newEntList = new LinkedList<ModelEntity>();
        for (String tableName : new TreeSet<String>(colInfo.keySet())) {
            List<ColumnCheckInfo> colList = colInfo.get(tableName);
            ModelEntity newEntity = new ModelEntity(tableName, colList, this.modelFieldTypeReader);
            newEntList.add(newEntity);
        }
        return newEntList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet<String> getTableNames(Collection<String> messages) {
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            this.error("Unable to establish a connection with the database... Error was:" + sqle.toString(), messages);
            return null;
        }
        catch (GenericEntityException e) {
            this.error("Unable to establish a connection with the database... Error was:" + e.toString(), messages);
            return null;
        }
        if (connection == null) {
            this.error("Unable to establish a connection with the database, no additional information available.", messages);
            return null;
        }
        DatabaseMetaData dbData = null;
        try {
            dbData = connection.getMetaData();
        }
        catch (SQLException sqle) {
            this.error("Unable to get database metadata... Error was:" + sqle.toString(), messages);
            return null;
        }
        if (dbData == null) {
            Debug.logWarning((String)"Unable to get database metadata; method returned null", (String)module);
        }
        this.logDbInfo(dbData);
        if (Debug.infoOn()) {
            Debug.logInfo((String)"Getting Table Info From Database");
        }
        TreeSet<String> tableNames = new TreeSet<String>();
        ResultSet tableSet = null;
        try {
            String[] types = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM"};
            String lookupSchemaName = this.lookupSchemaName(dbData);
            tableSet = dbData.getTables(null, lookupSchemaName, null, types);
            if (tableSet == null) {
                Debug.logWarning((String)"getTables returned null set", (String)module);
            }
        }
        catch (SQLException sqle) {
            this.error("Unable to get list of table information, let's try the create anyway... Error was:" + sqle.toString(), messages);
            this.cleanup(connection, messages);
            return tableNames;
        }
        try {
            while (tableSet.next()) {
                try {
                    String tableName = tableSet.getString("TABLE_NAME");
                    tableName = tableName == null ? null : tableName.toUpperCase();
                    tableName = this.convertToSchemaTableName(tableName, dbData);
                    String tableType = tableSet.getString("TABLE_TYPE");
                    String string = tableType = tableType == null ? null : tableType.toUpperCase();
                    if (tableType != null && !"TABLE".equals(tableType) && !"VIEW".equals(tableType) && !"ALIAS".equals(tableType) && !"SYNONYM".equals(tableType)) continue;
                    tableNames.add(tableName);
                }
                catch (SQLException sqle) {
                    this.error("Error getting table information... Error was:" + sqle.toString(), messages);
                }
            }
        }
        catch (SQLException sqle) {
            this.error("Error getting next table information... Error was:" + sqle.toString(), messages);
        }
        finally {
            try {
                tableSet.close();
            }
            catch (SQLException sqle) {
                this.error("Unable to close ResultSet for table list, continuing anyway... Error was:" + sqle.toString(), messages);
            }
            this.cleanup(connection, messages);
        }
        return tableNames;
    }

    private String lookupSchemaName(DatabaseMetaData dbData) throws SQLException {
        return this.datasourceInfo == null ? null : DatabaseUtil.getSchemaPattern(dbData, this.datasourceInfo.getSchemaName());
    }

    public static String getSchemaPattern(DatabaseMetaData dbData, String schemaName) throws SQLException {
        if (dbData.supportsSchemasInTableDefinitions()) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName;
            }
            if ("Oracle".equalsIgnoreCase(dbData.getDatabaseProductName())) {
                return dbData.getUserName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<ColumnCheckInfo>> getColumnInfo(Set<String> tableNames, Collection<String> messages) {
        if (tableNames.size() == 0) {
            return new HashMap<String, List<ColumnCheckInfo>>();
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            this.error("Unable to establish a connection with the database... Error was:" + sqle.toString(), messages);
            return null;
        }
        catch (GenericEntityException e) {
            this.error("Unable to establish a connection with the database... Error was:" + e.toString(), messages);
            return null;
        }
        DatabaseMetaData dbData = null;
        try {
            dbData = connection.getMetaData();
        }
        catch (SQLException sqle) {
            this.error("Unable to get database metadata... Error was:" + sqle.toString(), messages);
            this.cleanup(connection, messages);
            return null;
        }
        if (Debug.infoOn()) {
            Debug.logInfo((String)"Getting Column Info From Database");
        }
        HashMap<String, List<ColumnCheckInfo>> colInfo = new HashMap<String, List<ColumnCheckInfo>>();
        try {
            String lookupSchemaName = this.lookupSchemaName(dbData);
            ResultSet rsCols = dbData.getColumns(null, lookupSchemaName, null, null);
            while (rsCols.next()) {
                try {
                    ArrayList<ColumnCheckInfo> tableColInfo;
                    ColumnCheckInfo ccInfo = new ColumnCheckInfo();
                    ccInfo.tableName = rsCols.getString("TABLE_NAME");
                    ccInfo.tableName = ccInfo.tableName == null ? null : ccInfo.tableName.toUpperCase();
                    ccInfo.tableName = this.convertToSchemaTableName(ccInfo.tableName, dbData);
                    if (!tableNames.contains(ccInfo.tableName)) continue;
                    ccInfo.columnName = rsCols.getString("COLUMN_NAME");
                    ccInfo.columnName = ccInfo.columnName == null ? null : ccInfo.columnName.toUpperCase();
                    ccInfo.typeName = rsCols.getString("TYPE_NAME");
                    ccInfo.typeName = ccInfo.typeName == null ? null : ccInfo.typeName.toUpperCase();
                    ccInfo.columnSize = rsCols.getInt("COLUMN_SIZE");
                    ccInfo.maxSizeInBytes = rsCols.getInt("CHAR_OCTET_LENGTH");
                    ccInfo.decimalDigits = rsCols.getInt("DECIMAL_DIGITS");
                    String isNullableSqlResponse = rsCols.getString("IS_NULLABLE");
                    if (isNullableSqlResponse != null && !isNullableSqlResponse.isEmpty()) {
                        Boolean bl = ccInfo.isNullable = "YES".equals(isNullableSqlResponse.toUpperCase()) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    if ((tableColInfo = (ArrayList<ColumnCheckInfo>)colInfo.get(ccInfo.tableName)) == null) {
                        tableColInfo = new ArrayList<ColumnCheckInfo>();
                        colInfo.put(ccInfo.tableName, tableColInfo);
                    }
                    tableColInfo.add(ccInfo);
                }
                catch (SQLException sqle) {
                    this.error("Error getting column info for column. Error was:" + sqle.toString(), messages);
                }
            }
            try {
                rsCols.close();
            }
            catch (SQLException sqle) {
                this.error("Unable to close ResultSet for column list, continuing anyway... Error was:" + sqle.toString(), messages);
            }
        }
        catch (SQLException sqle) {
            this.error("Error getting column metadata for Error was:" + sqle.toString() + ". Not checking columns.", messages);
        }
        finally {
            this.cleanup(connection, messages);
        }
        return colInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, ReferenceCheckInfo>> getReferenceInfo(Set<String> tableNames, Collection<String> messages) {
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            this.error("Unable to establish a connection with the database... Error was:" + sqle.toString(), messages);
            return null;
        }
        catch (GenericEntityException e) {
            this.error("Unable to establish a connection with the database... Error was:" + e.toString(), messages);
            return null;
        }
        DatabaseMetaData dbData = null;
        try {
            dbData = connection.getMetaData();
        }
        catch (SQLException sqle) {
            this.error("Unable to get database metadata... Error was:" + sqle.toString(), messages);
            this.cleanup(connection, messages);
            return null;
        }
        if (Debug.infoOn()) {
            Debug.logInfo((String)"Getting Foreign Key (Reference) Info From Database");
        }
        HashMap<String, Map<String, ReferenceCheckInfo>> refInfo = new HashMap<String, Map<String, ReferenceCheckInfo>>();
        try {
            String lookupSchemaName = this.lookupSchemaName(dbData);
            ResultSet rsCols = dbData.getImportedKeys(null, lookupSchemaName, null);
            int totalFkRefs = 0;
            while (rsCols.next()) {
                try {
                    HashMap<String, ReferenceCheckInfo> tableRefInfo;
                    ReferenceCheckInfo rcInfo = new ReferenceCheckInfo();
                    rcInfo.pkTableName = rsCols.getString("PKTABLE_NAME");
                    rcInfo.pkTableName = rcInfo.pkTableName == null ? null : rcInfo.pkTableName.toUpperCase();
                    rcInfo.pkColumnName = rsCols.getString("PKCOLUMN_NAME");
                    rcInfo.pkColumnName = rcInfo.pkColumnName == null ? null : rcInfo.pkColumnName.toUpperCase();
                    rcInfo.fkTableName = rsCols.getString("FKTABLE_NAME");
                    String string = rcInfo.fkTableName = rcInfo.fkTableName == null ? null : rcInfo.fkTableName.toUpperCase();
                    if (!tableNames.contains(rcInfo.fkTableName)) continue;
                    rcInfo.fkColumnName = rsCols.getString("FKCOLUMN_NAME");
                    rcInfo.fkColumnName = rcInfo.fkColumnName == null ? null : rcInfo.fkColumnName.toUpperCase();
                    rcInfo.fkName = rsCols.getString("FK_NAME");
                    String string2 = rcInfo.fkName = rcInfo.fkName == null ? null : rcInfo.fkName.toUpperCase();
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)("Got: " + rcInfo.toString()));
                    }
                    if ((tableRefInfo = (HashMap<String, ReferenceCheckInfo>)refInfo.get(rcInfo.fkTableName)) == null) {
                        tableRefInfo = new HashMap<String, ReferenceCheckInfo>();
                        refInfo.put(rcInfo.fkTableName, tableRefInfo);
                        if (Debug.verboseOn()) {
                            Debug.logVerbose((String)("Adding new Map for table: " + rcInfo.fkTableName));
                        }
                    }
                    if (!tableRefInfo.containsKey(rcInfo.fkName)) {
                        ++totalFkRefs;
                    }
                    tableRefInfo.put(rcInfo.fkName, rcInfo);
                }
                catch (SQLException sqle) {
                    this.error("Error getting fk reference info for table. Error was:" + sqle.toString(), messages);
                }
            }
            try {
                rsCols.close();
            }
            catch (SQLException sqle) {
                this.error("Unable to close ResultSet for fk reference list, continuing anyway... Error was:" + sqle.toString(), messages);
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("There are " + totalFkRefs + " foreign key refs in the database"));
            }
        }
        catch (SQLException sqle) {
            this.error("Error getting fk reference metadata Error was:" + sqle.toString() + ". Not checking fk refs.", messages);
            refInfo = null;
        }
        finally {
            this.cleanup(connection, messages);
        }
        return refInfo;
    }

    public Map<String, Set<String>> getIndexInfo(Set<String> tableNames, Collection<String> messages) {
        return this.getIndexInfo(tableNames, messages, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Set<String>> getIndexInfo(Set<String> tableNames, Collection<String> messages, boolean includeUnique) {
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            this.error("Unable to establish a connection with the database... Error was:" + sqle.toString(), messages);
            return null;
        }
        catch (GenericEntityException e) {
            this.error("Unable to establish a connection with the database... Error was:" + e.toString(), messages);
            return null;
        }
        DatabaseMetaData dbData = null;
        try {
            dbData = connection.getMetaData();
        }
        catch (SQLException sqle) {
            this.error("Unable to get database metadata... Error was:" + sqle.toString(), messages);
            this.cleanup(connection, messages);
            return null;
        }
        if (Debug.infoOn()) {
            Debug.logInfo((String)"Getting Index Info From Database");
        }
        HashMap<String, Set<String>> indexInfo = new HashMap<String, Set<String>>();
        try {
            int totalIndices = 0;
            Iterator<String> tableNamesIter = tableNames.iterator();
            String lookupSchemaName = this.lookupSchemaName(dbData);
            DatabaseType databaseType = DatabaseTypeFactory.getTypeForConnection(connection);
            while (tableNamesIter.hasNext()) {
                String curTableName = tableNamesIter.next();
                ResultSet rsCols = null;
                try {
                    rsCols = this.getIndexInfo(dbData, databaseType, lookupSchemaName, curTableName);
                }
                catch (Exception e) {
                    Debug.logWarning((Throwable)e, (String)("Error getting index info for table: " + curTableName + " using lookupSchemaName " + lookupSchemaName));
                }
                while (rsCols != null && rsCols.next()) {
                    try {
                        if (rsCols.getShort("TYPE") == 0 || !includeUnique && !rsCols.getBoolean("NON_UNIQUE")) continue;
                        String indexName = rsCols.getString("INDEX_NAME");
                        indexName = indexName == null ? null : indexName.toUpperCase();
                        TreeSet<String> tableIndexList = (TreeSet<String>)indexInfo.get(curTableName);
                        if (tableIndexList == null) {
                            tableIndexList = new TreeSet<String>();
                            indexInfo.put(curTableName, tableIndexList);
                            if (Debug.verboseOn()) {
                                Debug.logVerbose((String)("Adding new Map for table: " + curTableName));
                            }
                        }
                        if (!tableIndexList.contains(indexName)) {
                            ++totalIndices;
                        }
                        tableIndexList.add(indexName);
                    }
                    catch (SQLException sqle) {
                        this.error("Error getting fk reference info for table. Error was:" + sqle.toString(), messages);
                    }
                }
                if (rsCols == null) continue;
                try {
                    rsCols.close();
                }
                catch (SQLException sqle) {
                    this.error("Unable to close ResultSet for fk reference list, continuing anyway... Error was:" + sqle.toString(), messages);
                }
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("There are " + totalIndices + " indices in the database"));
            }
        }
        catch (SQLException sqle) {
            this.error("Error getting fk reference metadata Error was:" + sqle.toString() + ". Not checking fk refs.", messages);
            indexInfo = null;
        }
        finally {
            this.cleanup(connection, messages);
        }
        return indexInfo;
    }

    private ResultSet getIndexInfo(DatabaseMetaData dbData, DatabaseType dbType, String schemaName, String tableName) throws SQLException {
        ResultSet rsCols;
        if (DatabaseTypeFactory.ORACLE_10G == dbType || DatabaseTypeFactory.ORACLE_8I == dbType) {
            rsCols = dbData.getIndexInfo(null, schemaName, tableName.toUpperCase(), false, true);
        } else {
            boolean isPostgres;
            rsCols = dbData.getIndexInfo(null, schemaName, tableName, false, true);
            boolean bl = isPostgres = DatabaseTypeFactory.POSTGRES == dbType || DatabaseTypeFactory.POSTGRES_7_2 == dbType || DatabaseTypeFactory.POSTGRES_7_3 == dbType;
            if (isPostgres) {
                if (rsCols == null || !rsCols.next()) {
                    rsCols = dbData.getIndexInfo(null, schemaName, tableName.toLowerCase(), false, true);
                } else {
                    rsCols.beforeFirst();
                }
            }
        }
        return rsCols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTable(ModelEntity entity, Map<String, ? extends ModelEntity> modelEntities, boolean addFks, boolean usePkConstraintNames, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        if (entity == null) {
            return "ModelEntity was null and is required to create a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create table for a view entity";
        }
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to establish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to establish a connection with the database... Error was: " + e.toString();
        }
        StringBuilder sqlBuf = new StringBuilder("CREATE TABLE ");
        sqlBuf.append(entity.getTableName(this.datasourceInfo));
        sqlBuf.append(" (");
        for (int i = 0; i < entity.getFieldsSize(); ++i) {
            ModelField field = entity.getField(i);
            ModelFieldType type = this.modelFieldTypeReader.getModelFieldType(field.getType());
            if (type == null) {
                return "Field type [" + type + "] not found for field [" + field.getName() + "] of entity [" + entity.getEntityName() + "], not creating table.";
            }
            sqlBuf.append(field.getColName());
            sqlBuf.append(" ");
            sqlBuf.append(type.getSqlType());
            if (field.getIsPk()) {
                sqlBuf.append(" NOT NULL, ");
                continue;
            }
            sqlBuf.append(", ");
        }
        String pkName = "PK_" + entity.getPlainTableName();
        if (pkName.length() > constraintNameClipLength) {
            pkName = pkName.substring(0, constraintNameClipLength);
        }
        if (usePkConstraintNames) {
            sqlBuf.append("CONSTRAINT ");
            sqlBuf.append(pkName);
        }
        sqlBuf.append(" PRIMARY KEY (");
        sqlBuf.append(entity.colNameString(entity.getPksCopy()));
        sqlBuf.append(")");
        if (addFks) {
            Iterator<ModelRelation> relationsIter = entity.getRelationsIterator();
            while (relationsIter.hasNext()) {
                ModelRelation modelRelation = relationsIter.next();
                if (!"one".equals(modelRelation.getType())) continue;
                ModelEntity relModelEntity = modelEntities.get(modelRelation.getRelEntityName());
                if (relModelEntity == null) {
                    Debug.logError((String)("Error adding foreign key: ModelEntity was null for related entity name " + modelRelation.getRelEntityName()));
                    continue;
                }
                if (relModelEntity instanceof ModelViewEntity) {
                    Debug.logError((String)("Error adding foreign key: related entity is a view entity for related entity name " + modelRelation.getRelEntityName()));
                    continue;
                }
                sqlBuf.append(", ");
                sqlBuf.append(this.makeFkConstraintClause(entity, modelRelation, relModelEntity, constraintNameClipLength, fkStyle, useFkInitiallyDeferred));
            }
        }
        sqlBuf.append(")");
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[createTable] sql=" + sqlBuf.toString()));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(sqlBuf.toString());
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + sqlBuf.toString() + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addColumn(ModelEntity entity, ModelField field) {
        if (entity == null || field == null) {
            return "ModelEntity or ModelField where null, cannot add column";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot add column for a view entity";
        }
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to establish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to establish a connection with the database... Error was: " + e.toString();
        }
        ModelFieldType type = this.modelFieldTypeReader.getModelFieldType(field.getType());
        if (type == null) {
            return "Field type [" + type + "] not found for field [" + field.getName() + "] of entity [" + entity.getEntityName() + "], not adding column.";
        }
        StringBuilder sqlBuf = new StringBuilder("ALTER TABLE ");
        sqlBuf.append(entity.getTableName(this.datasourceInfo));
        sqlBuf.append(" ADD ");
        sqlBuf.append(field.getColName());
        sqlBuf.append(" ");
        sqlBuf.append(type.getSqlType());
        String sql = sqlBuf.toString();
        if (Debug.infoOn()) {
            Debug.logInfo((String)("[addColumn] sql=" + sql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException sqle) {
            String sql2 = "ALTER TABLE " + entity.getTableName(this.datasourceInfo) + " ADD COLUMN " + field.getColName() + " " + type.getSqlType();
            if (Debug.infoOn()) {
                Debug.logInfo((String)("[addColumn] sql failed, trying sql2=" + sql2));
            }
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate(sql2);
            }
            catch (SQLException sqle2) {
                String string = "SQL Exception while executing the following:\n" + sql + "\nError was: " + sqle.toString();
                return string;
            }
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String makeFkConstraintName(ModelRelation modelRelation, int constraintNameClipLength) {
        String relConstraintName = modelRelation.getFkName();
        if (relConstraintName == null || relConstraintName.length() == 0) {
            relConstraintName = modelRelation.getTitle() + modelRelation.getRelEntityName();
            relConstraintName = relConstraintName.toUpperCase();
        }
        if (relConstraintName.length() > constraintNameClipLength) {
            relConstraintName = relConstraintName.substring(0, constraintNameClipLength);
        }
        return relConstraintName;
    }

    public String createForeignKeys(ModelEntity entity, Map<String, ? extends ModelEntity> modelEntities, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        if (entity == null) {
            return "ModelEntity was null and is required to create foreign keys for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create foreign keys for a view entity";
        }
        StringBuilder retMsgsBuffer = new StringBuilder();
        Iterator<ModelRelation> relationsIter = entity.getRelationsIterator();
        while (relationsIter.hasNext()) {
            ModelRelation modelRelation = relationsIter.next();
            if (!"one".equals(modelRelation.getType())) continue;
            ModelEntity relModelEntity = modelEntities.get(modelRelation.getRelEntityName());
            if (relModelEntity == null) {
                Debug.logError((String)("Error adding foreign key: ModelEntity was null for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            if (relModelEntity instanceof ModelViewEntity) {
                Debug.logError((String)("Error adding foreign key: related entity is a view entity for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            String retMsg = this.createForeignKey(entity, modelRelation, relModelEntity, constraintNameClipLength, fkStyle, useFkInitiallyDeferred);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createForeignKey(ModelEntity entity, ModelRelation modelRelation, ModelEntity relModelEntity, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to establish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to establish a connection with the database... Error was: " + e.toString();
        }
        StringBuilder sqlBuf = new StringBuilder("ALTER TABLE ");
        sqlBuf.append(entity.getTableName(this.datasourceInfo));
        sqlBuf.append(" ADD ");
        sqlBuf.append(this.makeFkConstraintClause(entity, modelRelation, relModelEntity, constraintNameClipLength, fkStyle, useFkInitiallyDeferred));
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[createForeignKey] sql=" + sqlBuf.toString()));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(sqlBuf.toString());
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + sqlBuf.toString() + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String makeFkConstraintClause(ModelEntity entity, ModelRelation modelRelation, ModelEntity relModelEntity, int constraintNameClipLength, String fkStyle, boolean useFkInitiallyDeferred) {
        String relConstraintName;
        Iterator<ModelKeyMap> keyMapsIter = modelRelation.getKeyMapsIterator();
        StringBuilder mainCols = new StringBuilder();
        StringBuilder relCols = new StringBuilder();
        while (keyMapsIter.hasNext()) {
            ModelKeyMap keyMap = keyMapsIter.next();
            ModelField mainField = entity.getField(keyMap.getFieldName());
            if (mainCols.length() > 0) {
                mainCols.append(", ");
            }
            mainCols.append(mainField.getColName());
            ModelField relField = relModelEntity.getField(keyMap.getRelFieldName());
            if (relCols.length() > 0) {
                relCols.append(", ");
            }
            relCols.append(relField.getColName());
        }
        StringBuilder sqlBuf = new StringBuilder("");
        if ("name_constraint".equals(fkStyle)) {
            sqlBuf.append("CONSTRAINT ");
            relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
            sqlBuf.append(relConstraintName);
            sqlBuf.append(" FOREIGN KEY (");
            sqlBuf.append(mainCols.toString());
            sqlBuf.append(") REFERENCES ");
            sqlBuf.append(relModelEntity.getTableName(this.datasourceInfo));
            sqlBuf.append(" (");
            sqlBuf.append(relCols.toString());
            sqlBuf.append(")");
            if (useFkInitiallyDeferred) {
                sqlBuf.append(" INITIALLY DEFERRED");
            }
        } else if ("name_fk".equals(fkStyle)) {
            sqlBuf.append(" FOREIGN KEY ");
            relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
            sqlBuf.append(relConstraintName);
            sqlBuf.append(" (");
            sqlBuf.append(mainCols.toString());
            sqlBuf.append(") REFERENCES ");
            sqlBuf.append(relModelEntity.getTableName(this.datasourceInfo));
            sqlBuf.append(" (");
            sqlBuf.append(relCols.toString());
            sqlBuf.append(")");
            if (useFkInitiallyDeferred) {
                sqlBuf.append(" INITIALLY DEFERRED");
            }
        } else {
            String emsg = "ERROR: fk-style specified for this data-source is not valid: " + fkStyle;
            Debug.logError((String)emsg);
            throw new IllegalArgumentException(emsg);
        }
        return sqlBuf.toString();
    }

    public String deleteForeignKeys(ModelEntity entity, Map<String, ? extends ModelEntity> modelEntities, int constraintNameClipLength) {
        if (entity == null) {
            return "ModelEntity was null and is required to delete foreign keys for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot delete foreign keys for a view entity";
        }
        Iterator<ModelRelation> relationsIter = entity.getRelationsIterator();
        StringBuilder retMsgsBuffer = new StringBuilder();
        while (relationsIter.hasNext()) {
            ModelRelation modelRelation = relationsIter.next();
            if (!"one".equals(modelRelation.getType())) continue;
            ModelEntity relModelEntity = modelEntities.get(modelRelation.getRelEntityName());
            if (relModelEntity == null) {
                Debug.logError((String)("Error removing foreign key: ModelEntity was null for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            if (relModelEntity instanceof ModelViewEntity) {
                Debug.logError((String)("Error removing foreign key: related entity is a view entity for related entity name " + modelRelation.getRelEntityName()));
                continue;
            }
            String retMsg = this.deleteForeignKey(entity, modelRelation, relModelEntity, constraintNameClipLength);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteForeignKey(ModelEntity entity, ModelRelation modelRelation, ModelEntity relModelEntity, int constraintNameClipLength) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to establish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to establish a connection with the database... Error was: " + e.toString();
        }
        String relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
        StringBuilder sqlBuf = new StringBuilder("ALTER TABLE ");
        sqlBuf.append(entity.getTableName(this.datasourceInfo));
        sqlBuf.append(" DROP CONSTRAINT ");
        sqlBuf.append(relConstraintName);
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[deleteForeignKey] sql=" + sqlBuf.toString()));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(sqlBuf.toString());
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + sqlBuf.toString() + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String createDeclaredIndices(ModelEntity entity) {
        if (entity == null) {
            return "ModelEntity was null and is required to create declared indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create declared indices for a view entity";
        }
        StringBuilder retMsgsBuffer = new StringBuilder();
        Iterator<ModelIndex> indexesIter = entity.getIndexesIterator();
        while (indexesIter.hasNext()) {
            ModelIndex modelIndex = indexesIter.next();
            String retMsg = this.createDeclaredIndex(entity, modelIndex);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDeclaredIndex(ModelEntity entity, ModelIndex modelIndex) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to establish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to establish a connection with the database... Error was: " + e.toString();
        }
        String createIndexSql = this.makeIndexClause(entity, modelIndex);
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[createForeignKeyIndex] index sql=" + createIndexSql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createIndexSql);
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + createIndexSql + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String makeIndexClause(ModelEntity entity, ModelIndex modelIndex) {
        Iterator<String> fieldNamesIter = modelIndex.getIndexFieldsIterator();
        StringBuilder mainCols = new StringBuilder();
        while (fieldNamesIter.hasNext()) {
            String fieldName = fieldNamesIter.next();
            ModelField mainField = entity.getField(fieldName);
            if (mainCols.length() > 0) {
                mainCols.append(", ");
            }
            mainCols.append(mainField.getColName());
        }
        StringBuilder indexSqlBuf = new StringBuilder("CREATE ");
        if (modelIndex.getUnique()) {
            indexSqlBuf.append("UNIQUE ");
        }
        indexSqlBuf.append("INDEX ");
        indexSqlBuf.append(modelIndex.getName());
        indexSqlBuf.append(" ON ");
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(" (");
        indexSqlBuf.append(mainCols.toString());
        indexSqlBuf.append(")");
        return indexSqlBuf.toString();
    }

    public String deleteDeclaredIndices(ModelEntity entity) {
        if (entity == null) {
            return "ModelEntity was null and is required to delete foreign keys indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot delete foreign keys indices for a view entity";
        }
        StringBuilder retMsgsBuffer = new StringBuilder();
        Iterator<ModelIndex> indexesIter = entity.getIndexesIterator();
        while (indexesIter.hasNext()) {
            ModelIndex modelIndex = indexesIter.next();
            String retMsg = this.deleteDeclaredIndex(entity, modelIndex);
            if (retMsg == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteDeclaredIndex(ModelEntity entity, ModelIndex modelIndex) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to establish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to establish a connection with the database... Error was: " + e.toString();
        }
        StringBuilder indexSqlBuf = new StringBuilder("DROP INDEX ");
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(".");
        indexSqlBuf.append(modelIndex.getName());
        String deleteIndexSql = indexSqlBuf.toString();
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[deleteForeignKeyIndex] index sql=" + deleteIndexSql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(deleteIndexSql);
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + deleteIndexSql + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String createForeignKeyIndices(ModelEntity entity, int constraintNameClipLength) {
        if (entity == null) {
            return "ModelEntity was null and is required to create foreign keys indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot create foreign keys indices for a view entity";
        }
        StringBuilder retMsgsBuffer = new StringBuilder();
        Iterator<ModelRelation> relationsIter = entity.getRelationsIterator();
        while (relationsIter.hasNext()) {
            String retMsg;
            ModelRelation modelRelation = relationsIter.next();
            if (!"one".equals(modelRelation.getType()) || (retMsg = this.createForeignKeyIndex(entity, modelRelation, constraintNameClipLength)) == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createForeignKeyIndex(ModelEntity entity, ModelRelation modelRelation, int constraintNameClipLength) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to establish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to establish a connection with the database... Error was: " + e.toString();
        }
        String createIndexSql = this.makeFkIndexClause(entity, modelRelation, constraintNameClipLength);
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[createForeignKeyIndex] index sql=" + createIndexSql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(createIndexSql);
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + createIndexSql + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    public String makeFkIndexClause(ModelEntity entity, ModelRelation modelRelation, int constraintNameClipLength) {
        Iterator<ModelKeyMap> keyMapsIter = modelRelation.getKeyMapsIterator();
        StringBuilder mainCols = new StringBuilder();
        while (keyMapsIter.hasNext()) {
            ModelKeyMap keyMap = keyMapsIter.next();
            ModelField mainField = entity.getField(keyMap.getFieldName());
            if (mainCols.length() > 0) {
                mainCols.append(", ");
            }
            mainCols.append(mainField.getColName());
        }
        StringBuilder indexSqlBuf = new StringBuilder("CREATE INDEX ");
        String relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
        indexSqlBuf.append(relConstraintName);
        indexSqlBuf.append(" ON ");
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(" (");
        indexSqlBuf.append(mainCols.toString());
        indexSqlBuf.append(")");
        return indexSqlBuf.toString();
    }

    public String deleteForeignKeyIndices(ModelEntity entity, int constraintNameClipLength) {
        if (entity == null) {
            return "ModelEntity was null and is required to delete foreign keys indices for a table";
        }
        if (entity instanceof ModelViewEntity) {
            return "ERROR: Cannot delete foreign keys indices for a view entity";
        }
        StringBuilder retMsgsBuffer = new StringBuilder();
        Iterator<ModelRelation> relationsIter = entity.getRelationsIterator();
        while (relationsIter.hasNext()) {
            String retMsg;
            ModelRelation modelRelation = relationsIter.next();
            if (!"one".equals(modelRelation.getType()) || (retMsg = this.deleteForeignKeyIndex(entity, modelRelation, constraintNameClipLength)) == null || retMsg.length() <= 0) continue;
            if (retMsgsBuffer.length() > 0) {
                retMsgsBuffer.append("\n");
            }
            retMsgsBuffer.append(retMsg);
        }
        if (retMsgsBuffer.length() > 0) {
            return retMsgsBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteForeignKeyIndex(ModelEntity entity, ModelRelation modelRelation, int constraintNameClipLength) {
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sqle) {
            return "Unable to establish a connection with the database... Error was: " + sqle.toString();
        }
        catch (GenericEntityException e) {
            return "Unable to establish a connection with the database... Error was: " + e.toString();
        }
        StringBuilder indexSqlBuf = new StringBuilder("DROP INDEX ");
        String relConstraintName = this.makeFkConstraintName(modelRelation, constraintNameClipLength);
        indexSqlBuf.append(entity.getTableName(this.datasourceInfo));
        indexSqlBuf.append(".");
        indexSqlBuf.append(relConstraintName);
        String deleteIndexSql = indexSqlBuf.toString();
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[deleteForeignKeyIndex] index sql=" + deleteIndexSql));
        }
        try {
            stmt = connection.createStatement();
            stmt.executeUpdate(deleteIndexSql);
        }
        catch (SQLException sqle) {
            String string = "SQL Exception while executing the following:\n" + deleteIndexSql + "\nError was: " + sqle.toString();
            return string;
        }
        finally {
            this.cleanup(connection, stmt);
        }
        return null;
    }

    private String convertToSchemaTableName(String tableName, DatabaseMetaData dbData) throws SQLException {
        if (tableName != null && dbData.supportsSchemasInTableDefinitions() && this.datasourceInfo.getSchemaName() != null && this.datasourceInfo.getSchemaName().length() > 0 && !tableName.startsWith(this.datasourceInfo.getSchemaName() + ".")) {
            return this.datasourceInfo.getSchemaName().toUpperCase() + "." + tableName;
        }
        return tableName;
    }

    private void logDbInfo(DatabaseMetaData dbData) {
        try {
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Database Product Name is " + dbData.getDatabaseProductName()), (String)module);
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Database Product Version is " + dbData.getDatabaseProductVersion()), (String)module);
            }
        }
        catch (SQLException sqle) {
            Debug.logWarning((String)"Unable to get Database name & version information", (String)module);
        }
        try {
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Database Driver Name is " + dbData.getDriverName()), (String)module);
            }
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Database Driver Version is " + dbData.getDriverVersion()), (String)module);
            }
        }
        catch (SQLException sqle) {
            Debug.logWarning((String)"Unable to get Driver name & version information", (String)module);
        }
    }

    private void cleanup(Connection connection, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void cleanup(Connection connection, Collection<String> messages) {
        try {
            connection.close();
        }
        catch (SQLException sqle2) {
            this.error("Unable to close database connection, continuing anyway... Error was:" + sqle2.toString(), messages);
        }
    }

    void error(String message, Collection<String> messages) {
        Debug.logError((String)message, (String)module);
        if (messages != null) {
            messages.add(message);
        }
    }

    void warn(String message, Collection<String> messages) {
        Debug.logWarning((String)message, (String)module);
        if (messages != null) {
            messages.add(message);
        }
    }

    void important(String message, Collection<String> messages) {
        Debug.logImportant((String)message, (String)module);
        if (messages != null) {
            messages.add(message);
        }
    }

    void verbose(String message, Collection<String> messages) {
        Debug.logVerbose((String)message, (String)module);
        if (messages != null) {
            messages.add(message);
        }
    }

    private class ColumnTypeParser {
        private final ModelEntity entity;
        private final ColumnCheckInfo ccInfo;
        private final Collection<String> messages;
        private final ModelFieldType modelFieldType;
        private final boolean isOracle;
        private String fullTypeStr;
        private String typeName;
        private String typeNameExtension;
        private int columnSize;
        private int decimalDigits;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ColumnTypeParser(ModelEntity entity, ColumnCheckInfo ccInfo, Collection<String> messages, ModelFieldType modelFieldType) {
            this.entity = entity;
            this.ccInfo = ccInfo;
            this.messages = messages;
            this.modelFieldType = modelFieldType;
            Connection connection = null;
            boolean isOracle = false;
            try {
                connection = DatabaseUtil.this.getConnection();
                DatabaseType dbType = DatabaseUtil.this.datasourceInfo.getDatabaseTypeFromJDBCConnection(connection);
                isOracle = DatabaseTypeFactory.ORACLE_10G == dbType || DatabaseTypeFactory.ORACLE_8I == dbType;
            }
            catch (SQLException sqle) {
                DatabaseUtil.this.error("Unable to establish a connection with the database... Error was: " + sqle.toString(), messages);
            }
            catch (GenericEntityException e) {
                DatabaseUtil.this.error("Unable to establish a connection with the database... Error was: " + e.toString(), messages);
            }
            finally {
                DatabaseUtil.this.cleanup(connection, null);
            }
            this.isOracle = isOracle;
        }

        public String getFullTypeStr() {
            return this.fullTypeStr;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getTypeNameExtension() {
            return this.typeNameExtension;
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        public int getDecimalDigits() {
            return this.decimalDigits;
        }

        public ColumnTypeParser invoke() {
            this.fullTypeStr = this.modelFieldType.getSqlType();
            int openParen = this.fullTypeStr.indexOf(40);
            int closeParen = this.fullTypeStr.indexOf(41, openParen);
            int comma = this.fullTypeStr.indexOf(44);
            this.typeNameExtension = "";
            this.columnSize = -1;
            this.decimalDigits = -1;
            if (openParen > 0 && closeParen > 0 && closeParen > openParen) {
                this.typeName = this.fullTypeStr.substring(0, openParen);
                if (comma > 0 && comma > openParen && comma < closeParen) {
                    String csStr = this.fullTypeStr.substring(openParen + 1, comma);
                    try {
                        this.columnSize = Integer.parseInt(csStr);
                    }
                    catch (NumberFormatException e) {
                        Debug.logError((Throwable)e, (String)module);
                    }
                    String ddStr = this.fullTypeStr.substring(comma + 1, closeParen);
                    try {
                        this.decimalDigits = Integer.parseInt(ddStr);
                    }
                    catch (NumberFormatException e) {
                        Debug.logError((Throwable)e, (String)module);
                    }
                } else {
                    String fullColumnSizeStr = this.fullTypeStr.substring(openParen + 1, closeParen);
                    try {
                        String[] splitSizeStr = fullColumnSizeStr.trim().split(" +");
                        switch (splitSizeStr.length) {
                            case 2: {
                                if (splitSizeStr[1].matches("BYTE|CHAR")) {
                                    this.typeNameExtension = splitSizeStr[1];
                                } else {
                                    String message = "Definition for column \"" + this.ccInfo.columnName + "\" of table \"" + this.entity.getTableName(DatabaseUtil.this.datasourceInfo) + "\" of entity \"" + this.entity.getEntityName() + "\" has an invalid size extension \"" + splitSizeStr[1] + "\" which will be ignored.";
                                    DatabaseUtil.this.warn(message, this.messages);
                                }
                            }
                            case 1: {
                                this.columnSize = Integer.parseInt(splitSizeStr[0]);
                                break;
                            }
                            default: {
                                throw new NumberFormatException("For input string: \"" + fullColumnSizeStr + "\"");
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        Debug.logError((Throwable)e, (String)module);
                    }
                }
            } else {
                this.typeName = this.fullTypeStr;
            }
            if (UtilValidate.isNotEmpty((String)this.modelFieldType.getSqlTypeAlias())) {
                this.typeName = this.modelFieldType.getSqlTypeAlias();
            }
            return this;
        }
    }

    public static class ReferenceCheckInfo {
        public String pkTableName;
        public String pkColumnName;
        public String fkName;
        public String fkTableName;
        public String fkColumnName;

        public String toString() {
            return "FK Reference from table " + this.fkTableName + " called " + this.fkName + " to PK in table " + this.pkTableName;
        }
    }

    public static class ColumnCheckInfo {
        public String tableName;
        public String columnName;
        public String typeName;
        public int columnSize;
        public int decimalDigits;
        public Boolean isNullable;
        public int maxSizeInBytes;

        public String typeAsString() {
            if (this.columnSize > 0) {
                if (this.decimalDigits > 0) {
                    return String.format("%s(%d,%d)", this.typeName, this.columnSize, this.decimalDigits);
                }
                return String.format("%s(%d%s)", this.typeName, this.columnSize, Oracle10GDatabaseType.detectUnicodeExtension(this) ? " CHAR" : "");
            }
            return this.typeName;
        }
    }
}

