/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.io.File;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.util.StringUtil;

public class ModelUtil {
    public static String upperFirstChar(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() <= 1) {
            return string.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(string);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    public static String lowerFirstChar(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() <= 1) {
            return string.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(string);
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    public static String dbNameToClassName(String columnName) {
        return ModelUtil.upperFirstChar(ModelUtil.dbNameToVarName(columnName));
    }

    public static String dbNameToVarName(String columnName) {
        if (columnName == null) {
            return null;
        }
        StringBuilder fieldName = new StringBuilder(columnName.length());
        boolean toUpper = false;
        for (int i = 0; i < columnName.length(); ++i) {
            char ch = columnName.charAt(i);
            if (ch == '_') {
                toUpper = true;
                continue;
            }
            if (toUpper) {
                fieldName.append(Character.toUpperCase(ch));
                toUpper = false;
                continue;
            }
            fieldName.append(Character.toLowerCase(ch));
        }
        return fieldName.toString();
    }

    public static String javaNameToDbName(String javaName) {
        if (javaName == null) {
            return null;
        }
        if (javaName.length() <= 0) {
            return "";
        }
        StringBuilder dbName = new StringBuilder();
        dbName.append(Character.toUpperCase(javaName.charAt(0)));
        for (int namePos = 1; namePos < javaName.length(); ++namePos) {
            char curChar = javaName.charAt(namePos);
            if (Character.isUpperCase(curChar)) {
                dbName.append('_');
            }
            dbName.append(Character.toUpperCase(curChar));
        }
        return dbName.toString();
    }

    public static String packageToPath(String packageName) {
        return packageName.replace('.', File.separatorChar);
    }

    public static String replaceString(String mainString, String oldString, String newString) {
        return StringUtil.replaceString((String)mainString, (String)oldString, (String)newString);
    }

    public static String induceFieldType(String sqlTypeName, int length, int precision, ModelFieldTypeReader fieldTypeReader) {
        if (sqlTypeName == null) {
            return "invalid";
        }
        if (sqlTypeName.equals("VARCHAR") || sqlTypeName.equals("VARCHAR2")) {
            if (length <= 10) {
                return "very-short";
            }
            if (length <= 60) {
                return "short-varchar";
            }
            if (length <= 255) {
                return "long-varchar";
            }
            if (length <= 4000) {
                return "very-long";
            }
            return "invalid";
        }
        if (sqlTypeName.equals("TEXT")) {
            return "very-long";
        }
        if (sqlTypeName.equals("DECIMAL") || sqlTypeName.equals("NUMERIC")) {
            if (length > 18) {
                return "invalid";
            }
            if (precision == 0) {
                return "numeric";
            }
            if (precision <= 2) {
                return "currency-amount";
            }
            if (precision <= 6) {
                return "floating-point";
            }
            return "invalid";
        }
        if (sqlTypeName.equals("BLOB") || sqlTypeName.equals("OID")) {
            return "blob";
        }
        if (sqlTypeName.equals("DATETIME") || sqlTypeName.equals("TIMESTAMP")) {
            return "date-time";
        }
        if (sqlTypeName.equals("DATE")) {
            return "date";
        }
        if (sqlTypeName.equals("TIME")) {
            return "time";
        }
        if (sqlTypeName.equals("CHAR") && length == 1) {
            return "indicator";
        }
        return "invalid";
    }
}

