/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.config.JndiDatasourceInfo;
import org.ofbiz.core.entity.transaction.JNDIConnectionDetails;
import org.ofbiz.core.entity.transaction.JNDIFactory;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;
import org.ofbiz.core.entity.util.ClassLoaderUtils;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralException;
import org.ofbiz.core.util.JNDIContextFactory;

public class JNDIAutomaticFactory
implements TransactionFactoryInterface {
    public static final String module = JNDIAutomaticFactory.class.getName();
    static TransactionManager transactionManager = null;
    static UserTransaction userTransaction = null;
    protected static Map<String, Object> dsCache = CopyOnWriteMap.newHashMap();
    protected static final Properties CONFIGURATION = new Properties();
    protected static final String AUTO_CONFIGURE_TRANS_MGR;
    protected static final String[] TRANSMGR_NAME_GUESS;
    protected static final String[] USR_TRANSMGR_NAME_GUESS;
    protected static final String AUTO_CONFIGURE_JNDI_PREFIX;
    protected static final String[] JNDI_PREFIX_GUESSES;
    protected static JNDIConnectionDetails conDetails;
    protected static final String LIST_DELIMITER = ",";

    private static String getNonNullProperty(String propertyKey, String defaultValue) {
        String fieldValue = CONFIGURATION.getProperty(propertyKey);
        if (fieldValue != null) {
            return fieldValue;
        }
        Debug.logError((String)(propertyKey + " not set in the ofbiz-database.properties file. Using default value: " + defaultValue));
        return defaultValue;
    }

    static String[] parseList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int currentPosition = 0;
        int nextDelimiter = str.indexOf(LIST_DELIMITER, currentPosition);
        while (nextDelimiter >= currentPosition) {
            list.add(str.substring(currentPosition, nextDelimiter));
            currentPosition = nextDelimiter + LIST_DELIMITER.length();
            nextDelimiter = str.indexOf(LIST_DELIMITER, currentPosition);
        }
        list.add(str.substring(currentPosition));
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TransactionManager getTransactionManager() {
        if (transactionManager != null) return transactionManager;
        Class<JNDIFactory> clazz = JNDIFactory.class;
        synchronized (JNDIFactory.class) {
            if (transactionManager != null) return transactionManager;
            try {
                String jndiName = EntityConfigUtil.getInstance().getTxFactoryTxMgrJndiName();
                String jndiServerName = EntityConfigUtil.getInstance().getTxFactoryTxMgrJndiServerName();
                if (jndiName == null || jndiName.length() <= 0) return transactionManager;
                String[] guessList = new String[]{jndiName};
                if (AUTO_CONFIGURE_TRANS_MGR.equals(jndiName)) {
                    guessList = TRANSMGR_NAME_GUESS;
                }
                transactionManager = (TransactionManager)this.retrieveJNDIObject(jndiServerName, guessList);
            }
            catch (GeneralException e) {
                Debug.logError((Throwable)e);
                transactionManager = null;
            }
            return transactionManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserTransaction getUserTransaction() {
        if (userTransaction != null) return userTransaction;
        Class<JNDIFactory> clazz = JNDIFactory.class;
        synchronized (JNDIFactory.class) {
            if (userTransaction != null) return userTransaction;
            try {
                String jndiName = EntityConfigUtil.getInstance().getTxFactoryUserTxJndiName();
                String jndiServerName = EntityConfigUtil.getInstance().getTxFactoryUserTxJndiServerName();
                if (jndiName == null || jndiName.length() <= 0) return userTransaction;
                String[] guessList = new String[]{jndiName};
                if (AUTO_CONFIGURE_TRANS_MGR.equals(jndiName)) {
                    guessList = USR_TRANSMGR_NAME_GUESS;
                }
                userTransaction = (UserTransaction)this.retrieveJNDIObject(jndiServerName, guessList);
            }
            catch (GeneralException e) {
                Debug.logError((Throwable)e);
                transactionManager = null;
            }
            return userTransaction;
        }
    }

    private Object retrieveJNDIObject(String jndiServerName, String[] jndiNameGuesses) throws GeneralException {
        for (int i = 0; i < jndiNameGuesses.length; ++i) {
            String jndiNameGuess = jndiNameGuesses[i];
            try {
                Object jndiObject;
                InitialContext ic = JNDIContextFactory.getInitialContext((String)jndiServerName);
                if (ic == null || (jndiObject = ic.lookup(jndiNameGuess)) == null) continue;
                Debug.logInfo((String)("JNDI Object found using the look-up name " + jndiNameGuess), (String)module);
                return jndiObject;
            }
            catch (NamingException ne) {
                Debug.logInfo((String)("JNDI Object not found using the look-up name " + jndiNameGuess + " in JNDI."), (String)module);
            }
        }
        Debug.logWarning((String)("JNDI Object could not be found in " + this.arrayToString(jndiNameGuesses)), (String)module);
        return null;
    }

    private String arrayToString(String[] arr) {
        StringBuffer buff = new StringBuffer();
        buff.append("{");
        if (arr != null) {
            for (int i = 0; i < arr.length - 1; ++i) {
                buff.append(arr[i] + LIST_DELIMITER);
            }
            buff.append(arr[arr.length - 1]);
        }
        buff.append("}");
        return buff.toString();
    }

    public String getTxMgrName() {
        return "jndi";
    }

    public Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        Connection con = null;
        if (datasourceInfo.getJndiDatasource() != null) {
            if (!conDetails.detailsSet()) {
                JndiDatasourceInfo jndiDatasource = datasourceInfo.getJndiDatasource();
                String jndiName = jndiDatasource.getJndiName();
                boolean guessJndiName = jndiName.startsWith(AUTO_CONFIGURE_JNDI_PREFIX);
                conDetails.setServerName(jndiDatasource.getJndiServerName());
                if (guessJndiName) {
                    String jndiSuffix = jndiName.substring(AUTO_CONFIGURE_JNDI_PREFIX.length());
                    for (int i = 0; i < JNDI_PREFIX_GUESSES.length; ++i) {
                        String jndiPrefixGuess = JNDI_PREFIX_GUESSES[i];
                        con = JNDIAutomaticFactory.getJndiConnection(jndiPrefixGuess + jndiSuffix, conDetails.getServerName());
                        if (con != null) {
                            conDetails.setConnectionName(jndiPrefixGuess + jndiSuffix);
                            Debug.logInfo((String)("Found connection using the JNDI name '" + jndiPrefixGuess + jndiSuffix + "'"), (String)module);
                            break;
                        }
                        Debug.logInfo((String)("Failed to find connection using the JNDI name '" + jndiPrefixGuess + jndiSuffix + "'"), (String)module);
                    }
                } else {
                    conDetails.setConnectionName(jndiName);
                }
            }
            if (con == null) {
                con = JNDIAutomaticFactory.getJndiConnection(conDetails.getConnectionName(), conDetails.getServerName());
            }
            if (con != null) {
                return con;
            }
        } else {
            Debug.logError((String)("JNDI loaded is the configured transaction manager but no jndi-jdbc element was specified in the " + helperName + " datasource. Please check your configuration; will try other sources"));
        }
        if (datasourceInfo.getJdbcDatasource() != null) {
            return ConnectionFactory.tryGenericConnectionSources(helperName, datasourceInfo.getJdbcDatasource());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getJndiConnection(String jndiName, String jndiServerName) throws SQLException, GenericEntityException {
        Object ds = dsCache.get(jndiName);
        if (ds != null) {
            if (ds instanceof XADataSource) {
                XADataSource xads = (XADataSource)ds;
                return TransactionUtil.enlistConnection(xads.getXAConnection());
            }
            DataSource nds = (DataSource)ds;
            return nds.getConnection();
        }
        Class<ConnectionFactory> clazz = ConnectionFactory.class;
        synchronized (ConnectionFactory.class) {
            ds = dsCache.get(jndiName);
            if (ds != null) {
                if (ds instanceof XADataSource) {
                    XADataSource xads = (XADataSource)ds;
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return TransactionUtil.enlistConnection(xads.getXAConnection());
                }
                DataSource nds = (DataSource)ds;
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return nds.getConnection();
            }
            try {
                InitialContext ic;
                if (Debug.infoOn()) {
                    Debug.logInfo((String)("Doing JNDI lookup for name " + jndiName), (String)module);
                }
                if ((ic = JNDIContextFactory.getInitialContext((String)jndiServerName)) != null) {
                    ds = ic.lookup(jndiName);
                } else {
                    Debug.logWarning((String)("Initial Context returned was NULL for server name " + jndiServerName), (String)module);
                }
                if (ds != null) {
                    Connection con;
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)"Got a Datasource object.", (String)module);
                    }
                    dsCache.put(jndiName, ds);
                    if (ds instanceof XADataSource) {
                        if (Debug.infoOn()) {
                            Debug.logInfo((String)("Got XADataSource for name " + jndiName), (String)module);
                        }
                        XADataSource xads = (XADataSource)ds;
                        XAConnection xac = xads.getXAConnection();
                        con = TransactionUtil.enlistConnection(xac);
                    } else {
                        if (Debug.infoOn()) {
                            Debug.logInfo((String)("Got DataSource for name " + jndiName), (String)module);
                        }
                        DataSource nds = (DataSource)ds;
                        con = nds.getConnection();
                    }
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return con;
                }
                Debug.logError((String)"Datasource returned was NULL.", (String)module);
            }
            catch (NamingException ne) {
            }
            catch (GenericConfigException gce) {
                throw new GenericEntityException("Problems with the JNDI configuration.", gce.getNested());
            }
            return null;
        }
    }

    public void removeDatasource(String helperName) {
        DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        if (datasourceInfo.getJndiDatasource() == null && datasourceInfo.getJdbcDatasource() != null) {
            ConnectionFactory.removeDatasource(helperName);
        }
    }

    static {
        try {
            CONFIGURATION.load(ClassLoaderUtils.getResourceAsStream("ofbiz-database.properties", JNDIFactory.class));
        }
        catch (Exception e) {
            Debug.logError((String)"Unable to find ofbiz-database.properties file. Using default values for ofbiz configuration.");
        }
        AUTO_CONFIGURE_TRANS_MGR = JNDIAutomaticFactory.getNonNullProperty("transactionManager.autoConfigure", "${auto-jndi-name}");
        TRANSMGR_NAME_GUESS = JNDIAutomaticFactory.parseList(JNDIAutomaticFactory.getNonNullProperty("transactionManager.guess", "java:comp/UserTransaction,java:comp/env/UserTransaction"));
        USR_TRANSMGR_NAME_GUESS = JNDIAutomaticFactory.parseList(JNDIAutomaticFactory.getNonNullProperty("usrTransactionManager.guess", "java:comp/UserTransaction,java:comp/env/UserTransaction"));
        AUTO_CONFIGURE_JNDI_PREFIX = JNDIAutomaticFactory.getNonNullProperty("jndiPrefix.autoConfigure", "${auto-server-prefix}");
        JNDI_PREFIX_GUESSES = JNDIAutomaticFactory.parseList(JNDIAutomaticFactory.getNonNullProperty("jndiPrefix.guess", "jdbc/,java:comp/env/jdbc/,"));
        conDetails = new JNDIConnectionDetails();
    }
}

