/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelUtil;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModelRelation {
    protected String title;
    protected String type;
    protected String relEntityName;
    protected String fkName;
    protected List keyMaps = new ArrayList();
    protected ModelEntity mainEntity = null;

    public ModelRelation() {
        this.title = "";
        this.type = "";
        this.relEntityName = "";
        this.fkName = "";
    }

    public ModelRelation(ModelEntity mainEntity, Element relationElement) {
        this.mainEntity = mainEntity;
        this.type = UtilXml.checkEmpty((String)relationElement.getAttribute("type"));
        this.title = UtilXml.checkEmpty((String)relationElement.getAttribute("title"));
        this.relEntityName = UtilXml.checkEmpty((String)relationElement.getAttribute("rel-entity-name"));
        this.fkName = UtilXml.checkEmpty((String)relationElement.getAttribute("fk-name"));
        NodeList keyMapList = relationElement.getElementsByTagName("key-map");
        for (int i = 0; i < keyMapList.getLength(); ++i) {
            ModelKeyMap keyMap;
            Element keyMapElement = (Element)keyMapList.item(i);
            if (keyMapElement.getParentNode() != relationElement || (keyMap = new ModelKeyMap(keyMapElement)) == null) continue;
            this.keyMaps.add(keyMap);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRelEntityName() {
        return this.relEntityName;
    }

    public void setRelEntityName(String relEntityName) {
        this.relEntityName = relEntityName;
    }

    public String getFkName() {
        return this.fkName;
    }

    public void setFkName(String fkName) {
        this.fkName = fkName;
    }

    public ModelEntity getMainEntity() {
        return this.mainEntity;
    }

    public void setMainEntity(ModelEntity mainEntity) {
        this.mainEntity = mainEntity;
    }

    public Iterator getKeyMapsIterator() {
        return this.keyMaps.iterator();
    }

    public int getKeyMapsSize() {
        return this.keyMaps.size();
    }

    public ModelKeyMap getKeyMap(int index) {
        return (ModelKeyMap)this.keyMaps.get(index);
    }

    public void addKeyMap(ModelKeyMap keyMap) {
        this.keyMaps.add(keyMap);
    }

    public ModelKeyMap removeKeyMap(int index) {
        return (ModelKeyMap)this.keyMaps.remove(index);
    }

    public ModelKeyMap findKeyMap(String fieldName) {
        for (int i = 0; i < this.keyMaps.size(); ++i) {
            ModelKeyMap keyMap = (ModelKeyMap)this.keyMaps.get(i);
            if (!keyMap.fieldName.equals(fieldName)) continue;
            return keyMap;
        }
        return null;
    }

    public ModelKeyMap findKeyMapByRelated(String relFieldName) {
        for (int i = 0; i < this.keyMaps.size(); ++i) {
            ModelKeyMap keyMap = (ModelKeyMap)this.keyMaps.get(i);
            if (!keyMap.relFieldName.equals(relFieldName)) continue;
            return keyMap;
        }
        return null;
    }

    public String keyMapString(String separator, String afterLast) {
        int i;
        String returnString = "";
        if (this.keyMaps.size() < 1) {
            return "";
        }
        for (i = 0; i < this.keyMaps.size() - 1; ++i) {
            returnString = returnString + ((ModelKeyMap)this.keyMaps.get((int)i)).fieldName + separator;
        }
        returnString = returnString + ((ModelKeyMap)this.keyMaps.get((int)i)).fieldName + afterLast;
        return returnString;
    }

    public String keyMapUpperString(String separator, String afterLast) {
        if (this.keyMaps.size() < 1) {
            return "";
        }
        StringBuffer returnString = new StringBuffer(this.keyMaps.size() * 10);
        int i = 0;
        while (true) {
            ModelKeyMap kmap = (ModelKeyMap)this.keyMaps.get(i);
            returnString.append(ModelUtil.upperFirstChar(kmap.fieldName));
            if (++i >= this.keyMaps.size()) break;
            returnString.append(separator);
        }
        returnString.append(afterLast);
        return returnString.toString();
    }

    public String keyMapRelatedUpperString(String separator, String afterLast) {
        if (this.keyMaps.size() < 1) {
            return "";
        }
        StringBuffer returnString = new StringBuffer(this.keyMaps.size() * 10);
        int i = 0;
        while (true) {
            ModelKeyMap kmap = (ModelKeyMap)this.keyMaps.get(i);
            returnString.append(ModelUtil.upperFirstChar(kmap.relFieldName));
            if (++i >= this.keyMaps.size()) break;
            returnString.append(separator);
        }
        returnString.append(afterLast);
        return returnString.toString();
    }
}

