/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc;

import java.util.Properties;
import org.ofbiz.core.entity.jdbc.interceptors.NoopSQLInterceptorFactory;
import org.ofbiz.core.entity.jdbc.interceptors.SQLInterceptor;
import org.ofbiz.core.entity.jdbc.interceptors.SQLInterceptorFactory;
import org.ofbiz.core.entity.util.ClassLoaderUtils;
import org.ofbiz.core.util.Debug;

class SQLInterceptorSupport {
    public static final String INTERCEPTOR_FACTORY_CLASS_NAME_KEY = "sqlinterceptor.factory.class";
    private static final Properties CONFIGURATION = new Properties();
    private static final SQLInterceptorFactory interceptorFactory;

    SQLInterceptorSupport() {
    }

    static SQLInterceptor getNonNullSQLInterceptor(String ofbizHelperName) {
        if (interceptorFactory == null) {
            throw new IllegalStateException("How can this happen? interceptorFactory must be non null by design");
        }
        SQLInterceptor sqlInterceptor = interceptorFactory.newSQLInterceptor(ofbizHelperName);
        if (sqlInterceptor == null) {
            sqlInterceptor = NoopSQLInterceptorFactory.NOOP_INTERCEPTOR;
        }
        return sqlInterceptor;
    }

    private static SQLInterceptorFactory loadInterceptorFactoryClass() {
        SQLInterceptorFactory interceptorFactory = NoopSQLInterceptorFactory.NOOP_INTERCEPTOR_FACTORY;
        String className = CONFIGURATION.getProperty(INTERCEPTOR_FACTORY_CLASS_NAME_KEY);
        if (className != null) {
            try {
                Class interceptorFactoryClass = ClassLoaderUtils.loadClass(className, SQLInterceptorSupport.class);
                if (SQLInterceptorFactory.class.isAssignableFrom(interceptorFactoryClass)) {
                    try {
                        interceptorFactory = (SQLInterceptorFactory)interceptorFactoryClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        Debug.logError((Throwable)e, (String)("Unable to load SQLInterceptorFactory class. " + className));
                    }
                    catch (IllegalAccessException e) {
                        Debug.logError((Throwable)e, (String)("Unable to load SQLInterceptorFactory class. " + className));
                    }
                }
            }
            catch (ClassNotFoundException e) {
                Debug.logError((Throwable)e, (String)("Unable to load SQLInterceptorFactory class. " + className));
            }
        }
        return interceptorFactory;
    }

    static {
        try {
            CONFIGURATION.load(ClassLoaderUtils.getResourceAsStream("ofbiz-database.properties", SQLInterceptorSupport.class));
        }
        catch (Exception e) {
            Debug.logError((String)"Unable to find ofbiz-database.properties file. Using default values for ofbiz configuration.");
        }
        interceptorFactory = SQLInterceptorSupport.loadInterceptorFactoryClass();
    }
}

