/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.GenericNotImplementedException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.comparator.OFBizFieldComparator;
import org.ofbiz.core.entity.jdbc.ReadOnlySQLProcessor;
import org.ofbiz.core.entity.jdbc.SqlJdbcUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelRelation;

public class MemoryHelper
implements GenericHelper {
    private static Map cache = MemoryHelper.getNewCache();
    private String helperName;
    private ModelFieldTypeReader modelFieldTypeReader;

    public static void clearCache() {
        cache = MemoryHelper.getNewCache();
    }

    private static final Map getNewCache() {
        return Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToCache(GenericValue value) {
        if (value == null) {
            return false;
        }
        if (!this.veryifyValue(value)) {
            return false;
        }
        value = (GenericValue)value.clone();
        Map map = cache;
        synchronized (map) {
            Map entityCache = (Map)cache.get(value.getEntityName());
            if (entityCache == null) {
                entityCache = MemoryHelper.getNewCache();
                cache.put(value.getEntityName(), entityCache);
            }
            entityCache.put(value.getPrimaryKey(), value);
        }
        return true;
    }

    private GenericValue findFromCache(GenericPK pk) {
        if (pk == null) {
            return null;
        }
        Map entityCache = (Map)cache.get(pk.getEntityName());
        if (entityCache == null) {
            return null;
        }
        GenericValue value = (GenericValue)entityCache.get(pk);
        if (value == null) {
            return null;
        }
        return (GenericValue)value.clone();
    }

    private int removeFromCache(GenericPK pk) {
        if (pk == null) {
            return 0;
        }
        Map entityCache = (Map)cache.get(pk.getEntityName());
        if (entityCache == null) {
            return 0;
        }
        Object o = entityCache.remove(pk);
        if (o == null) {
            return 0;
        }
        return 1;
    }

    private boolean isAndMatch(Map values, Map fields) {
        for (Map.Entry mapEntry : fields.entrySet()) {
            if (mapEntry.getValue() == null) {
                if (values.get(mapEntry.getKey()) == null) continue;
                return false;
            }
            try {
                if (mapEntry.getValue().equals(values.get(mapEntry.getKey()))) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean isOrMatch(Map values, Map fields) {
        for (Map.Entry mapEntry : fields.entrySet()) {
            if (mapEntry.getValue() == null) {
                if (values.get(mapEntry.getKey()) != null) continue;
                return true;
            }
            try {
                if (!mapEntry.getValue().equals(values.get(mapEntry.getKey()))) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }

    private boolean veryifyValue(GenericValue value) {
        ModelField field;
        ModelEntity me = value.getModelEntity();
        Iterator iterator = me.getPksIterator();
        while (iterator.hasNext()) {
            field = (ModelField)iterator.next();
            if (value.fields.containsKey(field.getName())) continue;
            return false;
        }
        for (Map.Entry entry : value.fields.entrySet()) {
            if (me.getField((String)entry.getKey()) != null) continue;
            return false;
        }
        iterator = me.getFieldsIterator();
        while (iterator.hasNext()) {
            field = (ModelField)iterator.next();
            Object o = value.get(field.getName());
            int typeValue = 0;
            try {
                typeValue = SqlJdbcUtil.getType(this.modelFieldTypeReader.getModelFieldType(field.getType()).getJavaType());
            }
            catch (GenericNotImplementedException e) {
                return false;
            }
            if (o == null) continue;
            switch (typeValue) {
                case 1: {
                    if (o instanceof String) break;
                    return false;
                }
                case 2: {
                    if (o instanceof Timestamp) break;
                    return false;
                }
                case 3: {
                    if (o instanceof Time) break;
                    return false;
                }
                case 4: {
                    if (o instanceof Date) break;
                    return false;
                }
                case 5: {
                    if (o instanceof Integer) break;
                    return false;
                }
                case 6: {
                    if (o instanceof Long) break;
                    return false;
                }
                case 7: {
                    if (o instanceof Float) break;
                    return false;
                }
                case 8: {
                    if (o instanceof Double) break;
                    return false;
                }
                case 9: {
                    if (o instanceof Boolean) break;
                    return false;
                }
            }
        }
        return true;
    }

    public MemoryHelper(String helperName) {
        this.helperName = helperName;
        this.modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
    }

    public String getHelperName() {
        return this.helperName;
    }

    public GenericValue create(GenericValue value) throws GenericEntityException {
        if (this.addToCache(value)) {
            return value;
        }
        return null;
    }

    public GenericValue create(GenericPK primaryKey) throws GenericEntityException {
        return this.create(new GenericValue(primaryKey));
    }

    public GenericValue findByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        return this.findFromCache(primaryKey);
    }

    public GenericValue findByPrimaryKeyPartial(GenericPK primaryKey, Set keys) throws GenericEntityException {
        GenericValue value = this.findFromCache(primaryKey);
        value.setFields(value.getFields(keys));
        return value;
    }

    public List findAllByPrimaryKeys(List primaryKeys) throws GenericEntityException {
        ArrayList<GenericValue> result = new ArrayList<GenericValue>(primaryKeys.size());
        for (GenericPK pk : primaryKeys) {
            result.add(this.findByPrimaryKey(pk));
        }
        return result;
    }

    public int removeByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        return this.removeFromCache(primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByAnd(ModelEntity modelEntity, Map fields, List orderBy) throws GenericEntityException {
        Map entityCache = (Map)cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        Map map = entityCache;
        synchronized (map) {
            for (Map.Entry mapEntry : entityCache.entrySet()) {
                GenericValue value = (GenericValue)mapEntry.getValue();
                if (!this.isAndMatch(value.fields, fields)) continue;
                result.add(value);
            }
        }
        ComparatorChain comp = new ComparatorChain();
        if (orderBy != null) {
            for (int i = 0; i < orderBy.size(); ++i) {
                String fieldAndOrder = (String)orderBy.get(i);
                StringTokenizer stringTokenizer = new StringTokenizer(fieldAndOrder);
                String field = null;
                String order = null;
                if (stringTokenizer.hasMoreElements()) {
                    field = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreElements()) {
                    order = stringTokenizer.nextToken();
                }
                if (field == null) continue;
                if (order == null || "ASC".equalsIgnoreCase(order)) {
                    comp.addComparator((Comparator)new OFBizFieldComparator(field));
                    continue;
                }
                comp.addComparator((Comparator)new ReverseComparator((Comparator)new OFBizFieldComparator(field)));
            }
            Collections.sort(result, comp);
        }
        return result;
    }

    public List findByAnd(ModelEntity modelEntity, List expressions, List orderBy) throws GenericEntityException {
        return null;
    }

    public List findByLike(ModelEntity modelEntity, Map fields, List orderBy) throws GenericEntityException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByOr(ModelEntity modelEntity, Map fields, List orderBy) throws GenericEntityException {
        Map entityCache = (Map)cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        Map map = entityCache;
        synchronized (map) {
            for (Map.Entry mapEntry : entityCache.entrySet()) {
                GenericValue value = (GenericValue)mapEntry.getValue();
                if (!this.isOrMatch(value.fields, fields)) continue;
                result.add(value);
            }
        }
        return result;
    }

    public List findByOr(ModelEntity modelEntity, List expressions, List orderBy) throws GenericEntityException {
        return null;
    }

    public List findByCondition(ModelEntity modelEntity, EntityCondition entityCondition, Collection fieldsToSelect, List orderBy) throws GenericEntityException {
        Map entityCache = (Map)cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return Collections.EMPTY_LIST;
        }
        List result = this.findByConditionWorker(entityCache, modelEntity, entityCondition, fieldsToSelect, orderBy);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List findByConditionWorker(Map entityCache, ModelEntity modelEntity, EntityCondition entityCondition, Collection fieldsToSelect, List orderBy) throws GenericEntityException {
        if (entityCondition instanceof EntityExpr) {
            ArrayList<GenericValue> result = new ArrayList<GenericValue>();
            EntityExpr entityExpr = (EntityExpr)entityCondition;
            HashMap<GenericValue, GenericValue> hashMap = entityCache;
            synchronized (hashMap) {
                for (Map.Entry mapEntry : entityCache.entrySet()) {
                    GenericValue value = (GenericValue)mapEntry.getValue();
                    if (!this.checkEntityExpr(value, entityExpr)) continue;
                    result.add(value);
                }
            }
            return result;
        }
        if (entityCondition instanceof EntityConditionList) {
            EntityConditionList entityConditionList = (EntityConditionList)entityCondition;
            HashMap<GenericValue, GenericValue> tempEntityCache = entityCache;
            List tempResult = new ArrayList();
            for (int i = 0; i < entityConditionList.getConditionListSize(); ++i) {
                EntityCondition subEntityCondition = entityConditionList.getCondition(i);
                if (EntityOperator.AND.equals(entityConditionList.getOperator())) {
                    tempResult = this.findByConditionWorker(tempEntityCache, modelEntity, subEntityCondition, fieldsToSelect, orderBy);
                    tempEntityCache = new HashMap<GenericValue, GenericValue>();
                    for (int j = 0; j < tempResult.size(); ++j) {
                        GenericValue genericValue = (GenericValue)tempResult.get(j);
                        tempEntityCache.put(genericValue, genericValue);
                    }
                    continue;
                }
                if (!EntityOperator.OR.equals(entityConditionList.getOperator())) continue;
                List list = this.findByConditionWorker(tempEntityCache, modelEntity, subEntityCondition, fieldsToSelect, orderBy);
                for (Object o : list) {
                    if (tempResult.contains(o)) continue;
                    tempResult.add(o);
                }
            }
            return tempResult;
        }
        if (entityCondition instanceof EntityFieldMap) {
            EntityFieldMap entityCond = (EntityFieldMap)entityCondition;
            if (entityCond.getOperator().equals(EntityOperator.AND)) {
                return this.findByAnd(modelEntity, entityCond.fieldMap, orderBy);
            }
            return this.findByOr(modelEntity, entityCond.fieldMap, orderBy);
        }
        if (entityCondition == null) {
            return new ArrayList(entityCache.values());
        }
        throw new UnsupportedOperationException("findByCondidition not implemented for expression:" + entityCondition.getClass().getName());
    }

    private boolean checkEntityExpr(GenericValue value, EntityExpr entityExpr) {
        EntityOperator operator = entityExpr.getOperator();
        return operator.compare(value.get(entityExpr.getLhs()), entityExpr.getRhs());
    }

    public List findByMultiRelation(GenericValue value, ModelRelation modelRelationOne, ModelEntity modelEntityOne, ModelRelation modelRelationTwo, ModelEntity modelEntityTwo, List orderBy) throws GenericEntityException {
        return null;
    }

    public EntityListIterator findListIteratorByCondition(ModelEntity modelEntity, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, Collection fieldsToSelect, List orderBy, EntityFindOptions findOptions) throws GenericEntityException {
        final Iterator entities = new ArrayList(this.findByCondition(modelEntity, whereEntityCondition, fieldsToSelect, orderBy)).iterator();
        EntityListIterator entityListIterator = new EntityListIterator(new ReadOnlySQLProcessor(null), modelEntity, null, this.modelFieldTypeReader){

            public Object next() {
                if (entities.hasNext()) {
                    return entities.next();
                }
                return null;
            }

            public void close() {
            }
        };
        return entityListIterator;
    }

    public int removeByAnd(ModelEntity modelEntity, Map fields) throws GenericEntityException {
        Map entityCache = (Map)cache.get(modelEntity.getEntityName());
        if (entityCache == null) {
            return 0;
        }
        ArrayList removeList = new ArrayList();
        for (Map.Entry mapEntry : entityCache.entrySet()) {
            GenericValue value = (GenericValue)mapEntry.getValue();
            if (!this.isAndMatch(value.fields, fields)) continue;
            removeList.add(mapEntry.getKey());
        }
        return this.removeAll(removeList);
    }

    public int store(GenericValue value) throws GenericEntityException {
        if (this.addToCache(value)) {
            return 1;
        }
        return 0;
    }

    public int storeAll(List values) throws GenericEntityException {
        int count = 0;
        for (GenericValue gv : values) {
            if (!this.addToCache(gv)) continue;
            ++count;
        }
        return count;
    }

    public int removeAll(List dummyPKs) throws GenericEntityException {
        int count = 0;
        for (GenericEntity ge : dummyPKs) {
            if (ge instanceof GenericPK) {
                count += this.removeFromCache((GenericPK)ge);
                continue;
            }
            HashMap<String, Object> pkFields = new HashMap<String, Object>();
            List pkFieldNames = ge.getModelEntity().getPkFieldNames();
            for (int i = 0; i < pkFieldNames.size(); ++i) {
                String fieldName = (String)pkFieldNames.get(i);
                pkFields.put(fieldName, ge.get(fieldName));
            }
            GenericPK pk = new GenericPK(ge.getModelEntity(), pkFields);
            count += this.removeFromCache(pk);
        }
        return count;
    }

    public void checkDataSource(Map modelEntities, Collection messages, boolean addMissing) throws GenericEntityException {
    }
}

